/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.Date;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record UpdateForceLoadExpiryPacket(ChunkDimPos pos, long relativeExpiryTime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateForceLoadExpiryPacket> TYPE = new CustomPacketPayload.Type(FTBChunksAPI.rl("update_force_load_expiry_packet"));
    public static final StreamCodec<FriendlyByteBuf, UpdateForceLoadExpiryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ChunkDimPos.STREAM_CODEC, UpdateForceLoadExpiryPacket::pos, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateForceLoadExpiryPacket::relativeExpiryTime, UpdateForceLoadExpiryPacket::new);

    public UpdateForceLoadExpiryPacket(ChunkDimPos pos, Date expiryDate) {
        this(pos, expiryDate == null ? 0L : Math.max(0L, expiryDate.getTime() - System.currentTimeMillis()));
    }

    public CustomPacketPayload.Type<UpdateForceLoadExpiryPacket> type() {
        return TYPE;
    }

    public static void handle(UpdateForceLoadExpiryPacket message, NetworkManager.PacketContext context) {
        ClaimedChunkImpl chunk;
        ServerPlayer sp;
        ChunkDimPos pos = message.pos;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).level().dimension().equals(pos.dimension()) && (chunk = ClaimedChunkManagerImpl.getInstance().getChunk(pos)) != null && chunk.getTeamData().getTeam().getRankForPlayer(sp.getUUID()).isMemberOrBetter() && chunk.isForceLoaded()) {
            chunk.setForceLoadExpiryTime(message.relativeExpiryTime == 0L ? 0L : System.currentTimeMillis() + message.relativeExpiryTime);
            SendChunkPacket packet = new SendChunkPacket((ResourceKey<Level>)pos.dimension(), chunk.getTeamData().getTeam().getId(), ChunkSyncInfo.create(System.currentTimeMillis(), chunk.getPos().x(), chunk.getPos().z(), chunk));
            NetworkManager.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)packet);
        }
    }
}

