/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.filter.CustomFilter;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CustomConfigScreen
extends AbstractFilterConfigScreen<CustomFilter> {
    private EditBox idEditBox;
    private EditBox extraEditBox;

    public CustomConfigScreen(CustomFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 176, 80);
    }

    @Override
    protected void init() {
        super.init();
        Objects.requireNonNull(this.font);
        this.idEditBox = new EditBox(this.font, this.leftPos + 8, this.topPos + 40, this.guiWidth - 16, 9 + 4, (Component)Component.empty());
        this.idEditBox.setMaxLength(1024);
        this.idEditBox.setBordered(true);
        this.idEditBox.setVisible(true);
        this.idEditBox.setTextColor(0xFFFFFF);
        this.idEditBox.setValue(((CustomFilter)this.filter).getEventId());
        this.idEditBox.setFilter(s -> s.isEmpty() || StringUtils.isAlphanumeric((CharSequence)s));
        this.addRenderableWidget((GuiEventListener)this.idEditBox);
        Objects.requireNonNull(this.font);
        this.extraEditBox = new EditBox(this.font, this.leftPos + 8, this.topPos + 70, this.guiWidth - 16, 9 + 4, (Component)Component.empty());
        this.extraEditBox.setMaxLength(1024);
        this.extraEditBox.setBordered(true);
        this.extraEditBox.setVisible(true);
        this.extraEditBox.setTextColor(0xFFFFFF);
        this.extraEditBox.setValue(((CustomFilter)this.filter).getExtraData());
        this.addRenderableWidget((GuiEventListener)this.extraEditBox);
        this.setInitialFocus((GuiEventListener)this.idEditBox);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"ftbfiltersystem.gui.custom_id"), this.leftPos + 8, this.topPos + 30, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"ftbfiltersystem.gui.custom_data"), this.leftPos + 8, this.topPos + 60, 0x404040, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        if (keyCode == 257 && (this.idEditBox.canConsumeInput() || this.extraEditBox.canConsumeInput())) {
            this.applyChanges();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifier);
    }

    @Override
    @Nullable
    protected CustomFilter makeNewFilter() {
        return new CustomFilter(((CustomFilter)this.filter).getParent(), this.idEditBox.getValue(), this.extraEditBox.getValue());
    }
}

