/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.config.values;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.GameRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameRuleMapping
extends BaseValue<Map<String, Tag>> {
    public GameRuleMapping(@Nullable SNBTConfig c, String n, Map<String, Tag> def) {
        super(c, n, def);
    }

    public void write(SNBTCompoundTag compoundTag) {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        for (Map.Entry entry : ((Map)this.get()).entrySet()) {
            tag.put((String)entry.getKey(), (Tag)entry.getValue());
        }
        compoundTag.comment(this.key, "Mapping of game rule keys to their values. Boolean game rules are stored as byte tags (0 or 1), integer game rules are stored as int tags.");
        compoundTag.put(this.key, (Tag)tag);
    }

    public void read(SNBTCompoundTag compoundTag) {
        if (!compoundTag.contains(this.key)) {
            this.set(Map.of());
            return;
        }
        SNBTCompoundTag tag = compoundTag.getCompound(this.key);
        Set keys = tag.getAllKeys();
        final HashSet knownGameRuleKeys = new HashSet();
        GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull GameRules.Key<T> key, // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull GameRules.Type<T> type) {
                knownGameRuleKeys.add(key.getId());
            }
        });
        for (String key : keys) {
            if (knownGameRuleKeys.contains(key)) continue;
            throw new IllegalStateException("Unknown game rule key in config: " + key);
        }
        HashMap<String, Tag> map = new HashMap<String, Tag>();
        for (String key : tag.getAllKeys()) {
            Tag valueTag = tag.get(key);
            if (valueTag == null) continue;
            if (valueTag.getId() == 1) {
                map.put(key, valueTag);
                continue;
            }
            if (valueTag.getId() == 3) {
                map.put(key, valueTag);
                continue;
            }
            throw new IllegalStateException("Invalid tag type for game rule key '" + key + "': " + valueTag.getId());
        }
        this.set(map);
    }
}

