/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad.client;

import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.packcompanion.features.actionpad.ActionPadFeature;
import dev.ftb.packcompanion.features.actionpad.ActionPadItem;
import dev.ftb.packcompanion.features.actionpad.PadAction;
import dev.ftb.packcompanion.features.actionpad.net.RunActionPacket;
import dev.ftb.packcompanion.features.actionpad.net.TryOpenActionTPAPacket;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.network.PacketDistributor;

public class ActionPadScreen
extends AbstractButtonListScreen {
    private final List<PadAction> actions;
    private final boolean playersOnline;

    public ActionPadScreen(List<PadAction> actions, boolean playersOnline) {
        this.showBottomPanel(false);
        this.setHasSearchBox(true);
        this.setTitle(((ActionPadItem)((Object)ActionPadFeature.ACTION_PAD.get())).getDescription());
        this.actions = actions;
        this.playersOnline = playersOnline;
    }

    public boolean onInit() {
        int max = this.getTheme().getStringWidth((FormattedText)this.getTitle());
        for (PadAction a : this.actions) {
            max = Math.max(max, this.getTheme().getStringWidth((FormattedText)Component.translatable((String)a.name())) + 20);
        }
        this.setSize(Mth.clamp((int)max, (int)150, (int)(this.getWindow().getGuiScaledWidth() * 3 / 4)), Mth.clamp((int)(20 + this.getTopPanelHeight() + (this.actions.size() + 1) * 20), (int)50, (int)(this.getWindow().getGuiScaledHeight() * 3 / 4)));
        return true;
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    public void addButtons(Panel panel) {
        if (this.playersOnline) {
            panel.add((Widget)new SimpleTextButton(this, panel, (Component)Component.translatable((String)"ftbpackcompanion.tpa"), Icons.MARKER){

                public void onClicked(MouseButton mouseButton) {
                    PacketDistributor.sendToServer((CustomPacketPayload)TryOpenActionTPAPacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
        for (final PadAction action : this.actions) {
            panel.add((Widget)new SimpleTextButton(this, panel, (Component)Component.translatable((String)action.name()), action.icon()){

                public void onClicked(MouseButton mouseButton) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new RunActionPacket(action.name()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    if (action.autoclose()) {
                        this.closeGui();
                    }
                }
            });
        }
    }
}

