/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block.neoforge;

import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.FluidTask;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.neoforge.ForgeEnergyTask;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class NeoForgeTaskScreenBlockEntity
extends TaskScreenBlockEntity {
    private AABB cachedRenderAABB = null;
    private final TaskItemHandler itemHandler = new TaskItemHandler();
    private final TaskFluidHandler fluidHandler = new TaskFluidHandler();
    private final TaskEnergyHandler energyHandler = new TaskEnergyHandler();

    public NeoForgeTaskScreenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IEnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    public AABB getRenderBoundingBox() {
        if (this.cachedRenderAABB == null) {
            TaskScreenBlock tsb;
            AABB box = new AABB(this.getBlockPos());
            Block block = this.getBlockState().getBlock();
            this.cachedRenderAABB = !(block instanceof TaskScreenBlock) || (tsb = (TaskScreenBlock)block).getSize() == 1 ? box : box.inflate((double)tsb.getSize());
        }
        return this.cachedRenderAABB;
    }

    private class TaskItemHandler
    implements IItemHandler {
        private TaskItemHandler() {
        }

        public int getSlots() {
            return 2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            ItemStack itemStack;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                if (slot == 0) {
                    itemStack = itemTask.getItemStack().copyWithCount((int)Math.min(NeoForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(itemTask), (long)itemTask.getItemStack().getMaxStackSize()));
                    return itemStack;
                }
            }
            itemStack = ItemStack.EMPTY;
            return itemStack;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemTask itemTask;
            TeamData data = NeoForgeTaskScreenBlockEntity.this.getCachedTeamData();
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask && data.canStartTasks((itemTask = (ItemTask)task).getQuest())) {
                return itemTask.insert(data, stack, simulate);
            }
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int count, boolean simulate) {
            TeamData data;
            ItemTask itemTask;
            Task task;
            if (!NeoForgeTaskScreenBlockEntity.this.isInputOnly() && (task = NeoForgeTaskScreenBlockEntity.this.getTask()) instanceof ItemTask && !ItemMatchingSystem.INSTANCE.isItemFilter((itemTask = (ItemTask)task).getItemStack()) && (data = NeoForgeTaskScreenBlockEntity.this.getCachedTeamData()) != null && data.canStartTasks(itemTask.getQuest()) && !data.isCompleted(itemTask)) {
                int itemsRemoved = (int)Math.min(data.getProgress(itemTask), (long)count);
                if (!simulate) {
                    data.addProgress(itemTask, -itemsRemoved);
                }
                return itemTask.getItemStack().copyWithCount(itemsRemoved);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            int n;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                n = itemTask.getItemStack().getMaxStackSize();
            } else {
                n = 0;
            }
            return n;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            ItemTask itemTask;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            return task instanceof ItemTask && (itemTask = (ItemTask)task).test(stack);
        }
    }

    private class TaskFluidHandler
    implements IFluidHandler {
        private TaskFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            FluidStack fluidStack;
            Task task;
            if (tank == 0 && (task = NeoForgeTaskScreenBlockEntity.this.getTask()) instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                fluidStack = new FluidStack(fluidTask.getFluid(), (int)NeoForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(fluidTask));
            } else {
                fluidStack = FluidStack.EMPTY;
            }
            return fluidStack;
        }

        public int getTankCapacity(int tank) {
            int n;
            Task task;
            if (tank == 0 && (task = NeoForgeTaskScreenBlockEntity.this.getTask()) instanceof FluidTask) {
                FluidTask fluidTask = (FluidTask)task;
                n = (int)fluidTask.getMaxProgress();
            } else {
                n = 0;
            }
            return n;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
            Task task;
            if (tank != 0 || !((task = NeoForgeTaskScreenBlockEntity.this.getTask()) instanceof FluidTask)) {
                return false;
            }
            FluidTask fluidTask = (FluidTask)task;
            FluidStack taskFluidStack = new FluidStack(Holder.direct((Object)fluidTask.getFluid()), 1000, fluidTask.getFluidDataComponentPatch());
            return FluidStack.isSameFluidSameComponents((FluidStack)taskFluidStack, (FluidStack)fluidStack);
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                TeamData data;
                FluidTask fluidTask = (FluidTask)task;
                if (this.isFluidValid(0, fluidStack) && (data = NeoForgeTaskScreenBlockEntity.this.getCachedTeamData()) != null && data.canStartTasks(fluidTask.getQuest()) && !data.isCompleted(fluidTask)) {
                    long space = fluidTask.getMaxProgress() - data.getProgress(fluidTask);
                    long toAdd = Math.min((long)fluidStack.getAmount(), space);
                    if (fluidAction.execute()) {
                        data.addProgress(fluidTask, Math.min((long)fluidStack.getAmount(), toAdd));
                    }
                    return (int)toAdd;
                }
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
            FluidStack fluidStack2;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                if (fluidStack.getFluid() == task2.getFluid()) {
                    fluidStack2 = this.drain(fluidStack.getAmount(), fluidAction);
                    return fluidStack2;
                }
            }
            fluidStack2 = FluidStack.EMPTY;
            return fluidStack2;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof FluidTask) {
                FluidTask task2 = (FluidTask)task;
                TeamData data = NeoForgeTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(task2.getQuest()) && !data.isCompleted(task2)) {
                    long toTake = Math.min((long)maxDrain, data.getProgress(task2));
                    if (fluidAction.execute()) {
                        data.addProgress(task2, -toTake);
                    }
                    FluidStack result = new FluidStack(task2.getFluid(), (int)toTake);
                    result.applyComponents(task2.getFluidDataComponents());
                    return result;
                }
            }
            return FluidStack.EMPTY;
        }
    }

    private class TaskEnergyHandler
    implements IEnergyStorage {
        private TaskEnergyHandler() {
        }

        public int receiveEnergy(int amount, boolean simulate) {
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask energyTask = (ForgeEnergyTask)task;
                TeamData data = NeoForgeTaskScreenBlockEntity.this.getCachedTeamData();
                if (data != null && data.canStartTasks(energyTask.getQuest()) && !data.isCompleted(energyTask)) {
                    long space = energyTask.getMaxProgress() - data.getProgress(energyTask);
                    long toAdd = Math.min(energyTask.getMaxInput(), Math.min((long)amount, space));
                    if (!simulate) {
                        data.addProgress(energyTask, toAdd);
                    }
                    return (int)toAdd;
                }
            }
            return 0;
        }

        public int extractEnergy(int amount, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            int n;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask energyTask = (ForgeEnergyTask)task;
                n = (int)NeoForgeTaskScreenBlockEntity.this.getCachedTeamData().getProgress(energyTask);
            } else {
                n = 0;
            }
            return n;
        }

        public int getMaxEnergyStored() {
            int n;
            Task task = NeoForgeTaskScreenBlockEntity.this.getTask();
            if (task instanceof ForgeEnergyTask) {
                ForgeEnergyTask energyTask = (ForgeEnergyTask)task;
                n = (int)energyTask.getValue();
            } else {
                n = 0;
            }
            return n;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

