/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.generic.currency;

import dev.ftb.mods.ftblibrary.integration.currency.CurrencyHelper;
import dev.ftb.mods.ftblibrary.integration.currency.CurrencyProvider;
import dev.ftb.mods.ftblibrary.integration.currency.FallbackCurrencyProvider;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import dev.ftb.mods.ftbxmodcompat.config.FTBXModConfig;
import dev.ftb.mods.ftbxmodcompat.generic.currency.MagicCoinsProvider;

public class CurrencySetup {
    public static void init() {
        FTBXModConfig.CurrencySelector sel = (FTBXModConfig.CurrencySelector)((Object)FTBXModConfig.CURRENCY_SELECTOR.get());
        if (sel != FTBXModConfig.CurrencySelector.DEFAULT && !sel.isUsable()) {
            FTBXModCompat.LOGGER.error("Currency implementation {} isn't available, falling back to default", (Object)sel);
            sel = FTBXModConfig.CurrencySelector.DEFAULT;
        }
        CurrencyHelper helper = CurrencyHelper.getInstance();
        switch (sel) {
            case MAGIC_COINS: {
                helper.setActiveImpl((CurrencyProvider)MagicCoinsProvider.INSTANCE);
                break;
            }
            case DEFAULT: {
                if (FTBXModCompat.isMagicCoinsLoaded) {
                    helper.setActiveImpl((CurrencyProvider)MagicCoinsProvider.INSTANCE);
                    break;
                }
                helper.setActiveImpl((CurrencyProvider)FallbackCurrencyProvider.INSTANCE);
            }
        }
        FTBXModCompat.LOGGER.info("Chose [{}] as the active currency implementation", (Object)helper.getProvider().getName());
    }
}

