/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.util;

import ky.someone.mods.gag.util.TooltipStyle;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public interface Tooltips {
    public static final TooltipStyle MAIN = TooltipStyle.color(16562523);
    public static final TooltipStyle EXTRA = new TooltipStyle(style -> style.withColor(1036780).withItalic(Boolean.valueOf(true)));
    public static final TooltipStyle FLAVOUR = new TooltipStyle(style -> style.withColor(ChatFormatting.GRAY));
    public static final TooltipStyle SUCCESS = TooltipStyle.color(5164173);
    public static final TooltipStyle FAIL = TooltipStyle.color(16608605);
    public static final TooltipStyle INFO = TooltipStyle.color(0x5555FF);
    public static final Component TRUE = SUCCESS.literal("\u2714");
    public static final Component FALSE = SUCCESS.literal("\u2718");

    public static MutableComponent bool(boolean value) {
        return (value ? TRUE : FALSE).copy();
    }

    public static Style styledRatio(Style parent, double ratio) {
        double clampedRatio = Mth.clamp((double)ratio, (double)0.0, (double)1.5);
        return parent.withColor(Mth.hsvToRgb((float)((float)clampedRatio / 3.0f), (float)1.0f, (float)1.0f));
    }

    public static Component asStyledValue(double value, double max) {
        return Tooltips.asStyledValue(value, max, Double.toString(value));
    }

    public static Component asStyledValue(double value, double max, String formattedValue) {
        return Component.literal((String)formattedValue).withStyle(Tooltips.styledRatio(Style.EMPTY, value / max));
    }

    public static Component asStyledLang(double value, double max, String formattedValue) {
        return Component.translatable((String)formattedValue).withStyle(Tooltips.styledRatio(Style.EMPTY, value / max));
    }
}

