/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.renderer.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.strawberry.gaze.GazeMod;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;

public class WheelCurioModel
extends EntityModel<LivingEntity> {
    public static ModelLayerLocation LAYER = new ModelLayerLocation(GazeMod.gazePath("wheel"), "main");
    public final ModelPart wheel;

    public WheelCurioModel(ModelPart root) {
        this.wheel = root.getChild("wheel");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition root = meshdefinition.getRoot();
        PartDefinition wheel = root.addOrReplaceChild("wheel", CubeListBuilder.create(), PartPose.ZERO);
        JsonObject json = WheelCurioModel.loadJsonModel("gaze", "models/entity/wheel.json");
        JsonArray elements = json.getAsJsonArray("elements");
        Map<String, Integer> textureLayerY = Map.of("#0", 52, "#1", 38, "#2", 0);
        for (int i = 0; i < elements.size(); ++i) {
            JsonObject el = elements.get(i).getAsJsonObject();
            JsonArray from = el.getAsJsonArray("from");
            JsonArray to = el.getAsJsonArray("to");
            float fromX = from.get(0).getAsFloat();
            float fromY = from.get(1).getAsFloat();
            float fromZ = from.get(2).getAsFloat();
            float toX = to.get(0).getAsFloat();
            float toY = to.get(1).getAsFloat();
            float toZ = to.get(2).getAsFloat();
            float sizeX = toX - fromX;
            float sizeY = toY - fromY;
            float sizeZ = toZ - fromZ;
            float pivotX = 0.0f;
            float pivotY = 0.0f;
            float pivotZ = 0.0f;
            float rotX = 0.0f;
            float rotY = 0.0f;
            float rotZ = 0.0f;
            if (el.has("rotation")) {
                JsonObject rot = el.getAsJsonObject("rotation");
                float angle = rot.get("angle").getAsFloat();
                String axis = rot.get("axis").getAsString();
                JsonArray origin = rot.getAsJsonArray("origin");
                pivotX = origin.get(0).getAsFloat();
                pivotY = origin.get(1).getAsFloat();
                pivotZ = origin.get(2).getAsFloat();
                if (axis.equals("x")) {
                    rotX = (float)Math.toRadians(angle);
                }
                if (axis.equals("y")) {
                    rotY = (float)Math.toRadians(angle);
                }
                if (axis.equals("z")) {
                    rotZ = (float)Math.toRadians(angle);
                }
            } else {
                pivotZ = 0.0f;
                pivotY = 0.0f;
                pivotX = 0.0f;
            }
            float offsetX = fromX - pivotX;
            float offsetY = fromY - pivotY;
            float offsetZ = fromZ - pivotZ;
            JsonObject faces = el.getAsJsonObject("faces");
            String textureKey = null;
            if (faces.has("north")) {
                textureKey = faces.getAsJsonObject("north").get("texture").getAsString();
            } else if (faces.size() > 0) {
                textureKey = ((JsonElement)((Map.Entry)faces.entrySet().iterator().next()).getValue()).getAsJsonObject().get("texture").getAsString();
            }
            int texV = 0;
            if (textureKey != null && textureLayerY.containsKey(textureKey)) {
                texV = textureLayerY.get(textureKey);
            }
            wheel.addOrReplaceChild("part" + i, CubeListBuilder.create().texOffs(0, texV).addBox(offsetX, offsetY - 15.0f, offsetZ, sizeX, sizeY, sizeZ), PartPose.rotation((float)rotX, (float)rotY, (float)rotZ));
        }
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private static JsonObject loadJsonModel(String namespace, String path) {
        try {
            ResourceManager manager = Minecraft.getInstance().getResourceManager();
            ResourceLocation loc = GazeMod.gazePath(path);
            return JsonParser.parseReader((Reader)new InputStreamReader(((Resource)manager.getResource(loc).orElseThrow()).open())).getAsJsonObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load model: " + namespace + ":" + path, e);
        }
    }

    public void setupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int i1, int i2) {
        this.wheel.render(poseStack, vertexConsumer, i, i1, i2);
    }
}

