/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.screens.codex.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.PlacedEntryAcceptor;
import com.sammy.malum.client.screen.codex.WidgetDesignType;
import com.sammy.malum.client.screen.codex.helper.CodexRenderHelper;
import com.sammy.malum.client.screen.codex.objects.progression.RiteEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.ScreenOpenerObject;
import com.sammy.malum.client.screen.codex.objects.progression.SubspaceEntryObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.pages.recipe.RuneworkingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SoulBindingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritRiteRecipePage;
import com.sammy.malum.client.screen.codex.pages.text.GeasInfoPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextItemPage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.text.SpiritRiteTextPage;
import com.sammy.malum.client.screen.codex.pages.text.TextPage;
import com.sammy.malum.client.screen.codex.pages.text.WeepingWellTextPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ArcanaProgressionScreen;
import com.sammy.malum.client.screen.codex.screens.progression.ProgressionScreenHolder;
import com.sammy.malum.client.screen.codex.screens.progression.VoidProgressionScreen;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.client.screen.codex.pages.MobSpiritPage;
import com.strawberry.gaze.registry.GazeGeasEffectTypeRegistry;
import com.strawberry.gaze.registry.GazeRiteRegistry;
import com.strawberry.gaze.registry.common.item.GazeItems;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;

public class GazeProgressionScreen
extends AbstractProgressionCodexScreen {
    public static final ResourceLocation FRAME_TEXTURE = GazeMod.gazePath("textures/gui/book/frame.png");
    public static final Color OUTLINE_COLOR = new Color(64, 12, 73);
    public static final ResourceLocation BACKGROUND_TEXTURE = GazeMod.gazePath("textures/gui/book/backdrop.png");
    public static ProgressionScreenHolder<GazeProgressionScreen> SCREEN;
    public static final List<PlacedBookEntry> GAZE_ENTRIES;

    protected GazeProgressionScreen() {
        super((Holder)MalumSoundEvents.ARCANA_SWEETENER_EVIL, 1120, 840);
    }

    public void renderBackground(PoseStack poseStack) {
        this.renderBackground(poseStack, BACKGROUND_TEXTURE, 0.2f, 0.2f);
    }

    public void renderBackground(PoseStack poseStack, ResourceLocation texture, float xModifier, float yModifier) {
        float X_SCROLL_SCALE = 0.7f;
        float Y_SCROLL_SCALE = 1.25f;
        float delta = this.minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        float x = Mth.lerp((float)delta, (float)this.oldBackgroundXOffset, (float)this.backgroundXOffset);
        float y = Mth.lerp((float)delta, (float)this.oldBackgroundYOffset, (float)this.backgroundYOffset);
        Vec2 offsets = this.clampOffsets(x, y, 0.8f, 0.0f, 1.0f);
        float xOffset = offsets.x;
        float yOffset = offsets.y;
        int insideLeft = this.getInsideLeft();
        int insideTop = this.getInsideTop();
        float uOffset = (float)this.backgroundImageWidth / 10.0f - (xOffset *= X_SCROLL_SCALE) * xModifier;
        float vOffset = (float)(this.backgroundImageHeight - 218) - (yOffset *= Y_SCROLL_SCALE) * yModifier;
        VFXBuilders.createScreen().setTexture(texture).setShader(GameRenderer::getPositionTexColorShader).setPositionWithWidth((float)insideLeft, (float)insideTop, 344.0f, 218.0f).setUVWithWidth(uOffset, vOffset, 344.0f, 218.0f, (float)this.backgroundImageWidth / 2.0f, (float)this.backgroundImageHeight / 2.0f).setZLevel(-100).multiplyColor(0.75f).blit(poseStack);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int guiLeft = this.getGuiLeft();
        int guiTop = this.getGuiTop();
        PoseStack poseStack = guiGraphics.pose();
        CodexRenderHelper.renderTexture((ResourceLocation)FRAME_TEXTURE, (PoseStack)poseStack, (float)guiLeft, (float)guiTop, (int)400, (float)0.0f, (float)0.0f, (int)378, (int)250);
    }

    public void setupEntries() {
        Item EMPTY = ItemStack.EMPTY.getItem();
        BookPage.isVoidThemed = true;
        this.addEntry("gaze.bestiary", 0, -1, b -> {
            b.configureWidget(w -> w.setIcon(Items.SKELETON_SKULL).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("gaze.bestiary", "gaze.bestiary.description"));
            if (Minecraft.getInstance().level == null) {
                return;
            }
            ArrayList<EntityType> mobTypes = new ArrayList<EntityType>();
            for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
                try {
                    if (!(type.create((Level)Minecraft.getInstance().level) instanceof LivingEntity)) continue;
                    mobTypes.add(type);
                }
                catch (Exception exception) {}
            }
            mobTypes.sort(Comparator.comparing(t -> t.getDescription().getString()));
            for (EntityType type : mobTypes) {
                LivingEntity entityInstance;
                try {
                    entityInstance = (LivingEntity)type.create((Level)Minecraft.getInstance().level);
                }
                catch (Exception e) {
                    continue;
                }
                if (entityInstance == null) continue;
                LivingEntity finalEnti = entityInstance;
                EntitySpiritDropData.getSpiritData((LivingEntity)finalEnti).ifPresent(data -> b.addPage((BookPage)new MobSpiritPage(finalEnti, data.getSpiritStacks())));
            }
        });
        this.addEntry("chronicles_of_the_void", 1, 0, b -> b.setWidgetSupplier((e, x, y) -> new ScreenOpenerObject(e, x, y, VoidProgressionScreen.SCREEN, MalumMod.malumPath((String)"textures/gui/book/icons/void_button.png"), 20, 20)).configureWidget(w -> w.setDesign(WidgetDesignType.GRAND, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK).setCondition(AbstractMalumCodexScreen::isVoidTouched)).withTitleStyle(s -> s.withColor(ChatFormatting.LIGHT_PURPLE)));
        this.addEntry("chronicles_of_the_soul", -1, 0, b -> b.setWidgetSupplier((e, x, y) -> new ScreenOpenerObject(e, x, y, ArcanaProgressionScreen.SCREEN, MalumMod.malumPath((String)"textures/gui/book/icons/arcana_button.png"), 20, 20)).configureWidget(w -> w.setDesign(WidgetDesignType.GRAND, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).withTitleStyle(s -> s.withColor(ChatFormatting.GOLD)));
        this.addEntry("gaze.soul_imbuement", 0, 1, b -> b.configureWidget(w -> w.setIcon(GazeMod.ENCYCLOPEDIA_UNVEILED).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER).setOrigin()).addPage((BookPage)new HeadlineTextPage("gaze.soul_imbuement", "gaze.soul_imbuement.1")).addPage((BookPage)new TextPage("gaze.soul_imbuement.2")).addPage((BookPage)new TextPage("gaze.soul_imbuement.3")).addPage((BookPage)new TextPage("gaze.soul_imbuement.4")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.ENCYCLOPEDIA_UNVEILED.get()))));
        this.addEntry("gaze.gift", 0, 2, b -> b.configureWidget(w -> w.setIcon(GazeMod.VEIL_DAGGER).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("gaze.gift", "gaze.gift.1")).addPage((BookPage)new TextPage("gaze.gift.2")).addPage((BookPage)new TextPage("gaze.gift.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.VEIL_DAGGER.get()))));
        this.addEntry("gaze.spirit_channel_pouch", 2, 3, b -> b.configureWidget(w -> w.setIcon(GazeMod.SPIRIT_CHANNEL_POUCH).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("gaze.spirit_channel_pouch", "gaze.spirit_channel_pouch.1")).addPage((BookPage)new TextPage("gaze.spirit_channel_pouch.2")).addPage((BookPage)new TextPage("gaze.spirit_channel_pouch.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SPIRIT_CHANNEL_POUCH.get()))));
        this.addEntry("gaze.veil_dagger_uses", 0, 3, b -> b.configureWidget(w -> w.setIcon((Supplier)MalumItems.UMBRAL_SPIRIT).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("gaze.veil_dagger_uses", "gaze.veil_dagger_uses.1")).addPage((BookPage)new TextPage("gaze.veil_dagger_uses.2")).addReference(new EntryReference(GazeMod.VEIL_DAGGER, BookEntry.create((String)"veil_dagger_uses.addendum").addPage((BookPage)new HeadlineTextPage("veil_dagger_uses.addendum", "veil_dagger_uses.addendum")))));
        this.addEntry("spirit_saber", -4, 10, b -> b.configureWidget(w -> w.setIcon(GazeMod.SPIRIT_SABER).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("spirit_saber", "spirit_saber.1")).addPage((BookPage)new TextPage("spirit_saber.2")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SPIRIT_SABER.get()))).addReference(new EntryReference((Supplier)MalumItems.INFERNAL_SPIRIT, BookEntry.create((String)"spirit_saber.scribbled_notes").addPage((BookPage)new HeadlineTextPage("spirit_saber.scribbled_notes", "spirit_saber.scribbled_notes.1")).addPage((BookPage)new TextPage("spirit_saber.scribbled_notes.2")).addPage((BookPage)new TextPage("spirit_saber.scribbled_notes.3")))).afterSomeTime().afterUmbralCrystal().afterSomeTime());
        this.addEntry("swift_spiral", -5, 4, b -> b.configureWidget(w -> w.setIcon(GazeMod.SWIFT_SPIRAL).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("swift_spiral", "swift_spiral.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SWIFT_SPIRAL.get()))).afterUmbralCrystal());
        this.addEntry("enchantment_workbench", 2, 12, b -> b.configureWidget(w -> w.setIcon(GazeItems.FUSION_ALTAR).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextItemPage("enchantment_workbench", "enchantment_workbench.1", (Item)GazeItems.FUSION_ALTAR.get())).addPage((BookPage)new TextPage("enchantment_workbench.2")).addPage((BookPage)new TextPage("enchantment_workbench.3")).addPage((BookPage)new TextPage("enchantment_workbench.4")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeItems.FUSION_ALTAR.get()))));
        SubspaceEntryObject.SubspaceWidgetSupplier umbralRuneSubspace = new SubspaceEntryObject.SubspaceWidgetSupplier().setSize(200);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_BEYOND_THE_VEIL, -6, 7);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_EIR, -6, 8);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_FAFNIR, -6, 5);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_GYMIR, -6, 4);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_YMIR, -5, 6);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_BLIGHTED_PRESENCE, -4, 6);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_OUT_OF_PHASE, -7, 6);
        GazeProgressionScreen.addRuneEntry((PlacedEntryAcceptor)umbralRuneSubspace, GazeMod.RUNE_OF_TOUCH_OF_VOID, -8, 6);
        this.addEntry("umbral.runes", -6, 6, b -> b.configureWidget(w -> w.setDesign(WidgetDesignType.SUBENTRY, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).setWidgetSupplier((PlacedBookEntry.WidgetSupplier)umbralRuneSubspace).setAssociatedSpirit((SpiritLike)MalumSpiritTypes.UMBRAL_SPIRIT).afterUmbralCrystal());
        this.addEntry("meditation_ring", -1, 11, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.MEDITATION_RING).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("meditation_ring", "meditation_ring.1")).addPage((BookPage)new TextPage("meditation_ring.2")).addReference(new EntryReference(GazeMod.MEDITATION_RING, BookEntry.create((String)"meditation_ring.reexamination").addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.MEDITATION_RING.get()))))).addReference(new EntryReference(GazeMod.COMPROMISE_RING, BookEntry.create((String)"compromise_ring.reexamination").addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.COMPROMISE_RING.get()))))).afterUmbralCrystal());
        this.addEntry("charge_necklace", 0, 10, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.CHARGE_NECKLACE).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("charge_necklace", "charge_necklace.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.CHARGE_NECKLACE.get()))).afterUmbralCrystal());
        this.addEntry("sluggish_brooch", -2, 3, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SLUGGISH_BROOCH).setDesign(WidgetDesignType.SMALL, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("sluggish_brooch", "sluggish_brooch.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SLUGGISH_BROOCH.get()))).afterUmbralCrystal());
        this.addEntry("seidhr", -5, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SEIDHR).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new WeepingWellTextPage("seidhr", "seidhr.1", (Item)GazeMod.SEIDHR.get())).addPage((BookPage)new TextPage("seidhr.2")).addPage((BookPage)new TextPage("seidhr.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SEIDHR.get()))).addPage((BookPage)new TextPage("seidhr.4")).afterUmbralCrystal());
        this.addEntry("splintered_world", -3, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.ASTRAL_SPLINTERED_WORLD).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new WeepingWellTextPage("splintered_world", "splintered_world.1", (Item)GazeMod.SPLINTERED_WORLD.get())).addPage((BookPage)new TextPage("splintered_world.2")).addPage((BookPage)new TextPage("splintered_world.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SPLINTERED_WORLD.get()))).afterUmbralCrystal());
        GazeProgressionScreen.addGeasEntry(this, GazeGeasEffectTypeRegistry.PACT_OF_ENCROACHING, 0, 6);
        GazeProgressionScreen.addGeasEntry(this, GazeGeasEffectTypeRegistry.DOMAIN_OF_SWORDS, -3, 12);
        this.addEntry("soul_rapier", -4, 4, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SOUL_RAPIER).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("soul_rapier", "soul_rapier.1")).addPage((BookPage)new TextPage("soul_rapier.2")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SOUL_RAPIER.get()))).afterUmbralCrystal());
        if (!Config.disableGazeRites) {
            this.addEntry("gaze_rites_lore", 5, 7, b -> b.configureWidget(w -> w.setIcon((Supplier)MalumItems.SPIRIT_JAR).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage("gaze_rites_lore", "gaze_rites_lore.1")).addPage((BookPage)new TextPage("gaze_rites_lore.2")).afterUmbralCrystal());
            this.addEntry("gaze_umbral_rite", 8, 7, b -> b.configureWidget(w -> w.setIcon((Supplier)MalumItems.UMBRAL_SPIRIT).setDesign(WidgetDesignType.GILDED, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new HeadlineTextPage("gaze_umbral_rite", "future_secret")).afterUmbralCrystal());
            this.addEntry("gaze_lesser_arcane_rite", 4, 7, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_ARCANE_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_ARCANE_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_ARCANE_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_ARCANE_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_sacred_rite", 4, 4, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_sacred_rite", 5, 4, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_CORRUPT_SACRED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_CORRUPT_SACRED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_CORRUPT_SACRED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_CORRUPT_SACRED_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_aerial_rite", 5, 5, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_aerial_rite", 6, 5, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AERIAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AERIAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AERIAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AERIAL_CORRUPT_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_aqueous_rite", 6, 6, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_aqueous_rite", 7, 6, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_CORRUPT_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_earthen_rite", 6, 8, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_earthen_rite", 7, 8, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_CORRUPT_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_infernal_rite", 5, 9, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_infernal_rite", 6, 9, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_CORRUPT_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_wicked_rite", 4, 10, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.RUNEWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_wicked_rite", 5, 10, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setDesign(WidgetDesignType.TOTEMIC, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.DARK)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_WICKED_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_WICKED_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_WICKED_CORRUPT_RITE)).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_WICKED_CORRUPT_RITE)).afterUmbralCrystal());
        }
        BookPage.isVoidThemed = false;
    }

    public Color getOutlineColor() {
        return OUTLINE_COLOR;
    }

    public static void addRuneEntry(PlacedEntryAcceptor acceptor, Holder<Item> rune, int x, int y) {
        String var10000 = BuiltInRegistries.ITEM.getKey((Object)((Item)rune.value())).getPath();
        String translationKey = var10000;
        acceptor.addEntry(translationKey, x, y, b -> b.configureWidget(w -> w.setIcon((Item)rune.value()).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.SOULWOOD, WidgetDesignType.FillingType.PAPER)).addPage((BookPage)new HeadlineTextPage(translationKey)).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)rune.value()))));
    }

    public static void addGeasEntry(AbstractProgressionCodexScreen screen, Holder<GeasEffectType> geas, int x, int y) {
        screen.addEntry(((GeasEffectType)geas.value()).getRegistryName().getPath(), x, y, b -> b.configureWidget(w -> w.setIcon(geas).setDesign(WidgetDesignType.DEFAULT, WidgetDesignType.FrameType.WITHERED, WidgetDesignType.FillingType.DARK)).addPage((BookPage)SoulBindingPage.fromGeas((Holder)geas)).addPage((BookPage)new GeasInfoPage(geas)));
    }

    public static ProgressionScreenHolder<GazeProgressionScreen> getScreen() {
        if (SCREEN == null) {
            SCREEN = new ProgressionScreenHolder(GazeProgressionScreen::new, (Holder)MalumSoundEvents.ARCANA_TRANSITION_NORMAL);
        }
        return SCREEN;
    }

    static {
        GAZE_ENTRIES = new ArrayList<PlacedBookEntry>();
        SCREEN = new ProgressionScreenHolder(GazeProgressionScreen::new, (Holder)MalumSoundEvents.ARCANA_TRANSITION_NORMAL);
    }
}

