/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.entity;

import com.sammy.malum.common.entity.bolt.AbstractBoltProjectileEntity;
import com.sammy.malum.core.systems.registry.SpiritHolder;
import com.sammy.malum.core.systems.spirit.EntitySpiritDropData;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.magic.MalumSpiritTypes;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.registry.GazeEntityRegistry;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.handlers.LodestoneRenderHandler;
import team.lodestar.lodestone.helpers.ColorHelper;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class SeidhrBoltEntity
extends AbstractBoltProjectileEntity {
    public SeidhrBoltEntity(Level level) {
        super((EntityType)GazeEntityRegistry.SEIDHR_BOLT.get(), level);
        this.noPhysics = true;
    }

    public SeidhrBoltEntity(Level level, double pX, double pY, double pZ) {
        this(level);
        this.setPos(pX, pY, pZ);
        this.noPhysics = true;
    }

    public int getMaxAge() {
        return 40;
    }

    public BoltImpactParticleEffect getImpactParticleEffect() {
        return MalumParticleEffectTypes.HEX_BOLT_IMPACT;
    }

    public MalumNetworkedParticleEffectColorData getImpactParticleColor() {
        return new MalumNetworkedParticleEffectColorData((SpiritLike[])new SpiritHolder[]{this.getRandomSpirit()});
    }

    protected Item getDefaultItem() {
        return (Item)GazeMod.SEIDHR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles() {
        Level level = this.level();
        Vec3 position = this.position();
        float scalar = this.getVisualEffectScalar();
        Vec3 norm = this.getDeltaMovement().normalize().scale((double)0.05f);
        ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)position, (SpiritLike)MalumSpiritTypes.INFERNAL_SPIRIT);
        lightSpecs.getBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.getBloomBuilder().setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).multiplyLifetime(1.25f).setMotion(norm);
        lightSpecs.spawnParticles();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)this.random, (float)RandomHelper.randomBetween((RandomSource)this.random, (float)0.25f, (float)0.5f)).randomSpinOffset(this.random).build();
        Consumer<LodestoneWorldParticle> behavior = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.95f));
        WorldParticleBuilder.create((Supplier)MalumParticles.THIN_SLASH).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)this.getDeltaMovement().normalize())).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.9f * scalar), (float)(0.4f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(1.0f * scalar), (float)(0.5f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setColorData((ColorParticleDataWrapper)MalumSpiritTypes.INFERNAL_SPIRIT.createColorData().build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setRenderTarget(LodestoneRenderHandler.LATE_DEFERRED_RENDER).setLifetime(Math.min(6 + this.age * 3, 30)).addTickActor(behavior).setSpinData((SpinParticleDataWrapper)spinData).enableForcedSpawn().enableNoClip().spawn(level, position.x, position.y, position.z).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.5f * scalar), (float)(0.3f * scalar)).setEasing(Easing.SINE_IN_OUT).build()).setTransparencyData((GenericParticleDataWrapper)GenericParticleData.create((float)(0.4f * scalar), (float)(0.2f * scalar), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).setColorData((ColorParticleDataWrapper)ColorParticleData.create((Color)ColorHelper.darker((Color)MalumSpiritTypes.INFERNAL_SPIRIT.getPrimaryColor(), (int)2)).build()).spawn(level, position.x, position.y, position.z);
    }

    private SpiritHolder<SpiritArcanaType> getRandomSpirit() {
        float value = this.random.nextFloat();
        if (value < 0.5f) {
            return MalumSpiritTypes.ARCANE_SPIRIT;
        }
        return MalumSpiritTypes.ELDRITCH_SPIRIT;
    }

    protected void onHitEntity(EntityHitResult result) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.fadingAway || this.spawnDelay > 0) {
            return;
        }
        Entity hitEntity = result.getEntity();
        Entity owner = this.getOwner();
        if (owner instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)owner;
            if (hitEntity instanceof LivingEntity) {
                float totalMagicDamage;
                LivingEntity target = (LivingEntity)hitEntity;
                float arcaneResonance = 1.0f;
                if (attacker.getAttribute((Holder)MalumAttributes.ARCANE_RESONANCE) != null) {
                    arcaneResonance = (float)attacker.getAttribute((Holder)MalumAttributes.ARCANE_RESONANCE).getValue();
                }
                float magicDamage = 1.0f;
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)hitEntity;
                    magicDamage = (float)EntitySpiritDropData.getSpiritData((LivingEntity)entity).map(d -> d.getTotalSpirits()).orElse(0).intValue() * arcaneResonance;
                }
                if (hitEntity instanceof Player) {
                    float armor = target.getArmorValue();
                    magicDamage = 2.0f * Math.max(1.0f, (1.0f + armor / 12.0f) * (1.0f + (1.0f - 1.0f / Math.max(1.0f, armor))) * arcaneResonance / 12.0f);
                }
                target.invulnerableTime = 0;
                DamageSource source = DamageTypeHelper.create((Level)this.level(), (ResourceKey)MalumDamageTypes.VOODOO, (Entity)this, (Entity)attacker);
                boolean success = target.hurt(source, totalMagicDamage = this.magicDamage + magicDamage);
                if (success) {
                    this.onDealDamage(target);
                    this.spawnEffect(serverLevel, 0.5f);
                    this.playSound((SoundEvent)MalumSoundEvents.STAFF_STRIKES.get(), 0.75f, Mth.nextFloat((RandomSource)this.random, (float)1.0f, (float)1.4f));
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.05));
                    this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
                }
            }
        }
        super.onHitEntity(result);
    }
}

