/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.curios.head;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.strawberry.gaze.GazeMod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class CurioAdaptiveResistanceWheel
extends MalumCurioItem
implements IMalumEventResponder {
    private static final int MAX_HISTORY_SIZE = 10;
    private static final ResourceLocation WHEEL_BOOST_ID = GazeMod.gazePath("adaptive_resistance_wheel");
    private final WeakHashMap<LivingEntity, List<ResourceLocation>> damageHistory = new WeakHashMap();

    public CurioAdaptiveResistanceWheel(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.VOID);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        this.damageHistory.remove(slotContext.entity());
    }

    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect((String)"wheel_of_adaptive_resistance", (Object[])new Object[0]));
    }

    @SubscribeEvent
    public void incomingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity attacked, ItemStack stack) {
        LivingEntity living = event.getEntity();
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)living).flatMap(inv -> inv.findFirstCurio(itemStack -> stack.getItem() instanceof CurioAdaptiveResistanceWheel));
        if (optional.isEmpty()) {
            return;
        }
        ResourceLocation type = ResourceLocation.tryParse((String)event.getSource().getMsgId());
        if (type == null) {
            return;
        }
        List history = this.damageHistory.computeIfAbsent(living, l -> new ArrayList());
        long matches = history.stream().filter(arg_0 -> ((ResourceLocation)type).equals(arg_0)).count();
        float reduction = (float)matches * 0.03f;
        if (reduction > 0.0f) {
            event.setNewDamage(event.getNewDamage() * (1.0f - reduction));
        }
        if (history.size() >= 10) {
            history.removeFirst();
        }
        history.add(type);
    }
}

