/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.compat.irons_spellbooks.entity.spells;

import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.strawberry.gaze.compat.irons_spellbooks.registry.IronsEntities;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.spells.shield.ShieldEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SoulwardShieldEntity
extends ShieldEntity {
    protected float spellPower;
    protected LivingEntity owner;

    public SoulwardShieldEntity(Level level, float health) {
        this((EntityType<SoulwardShieldEntity>)((EntityType)IronsEntities.SOULWARD_SHIELD.get()), level);
        this.setHealth(health);
    }

    public SoulwardShieldEntity(EntityType<SoulwardShieldEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public void setSpellPower(float spellPower) {
        this.spellPower = spellPower;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
        Object object = this.owner.getData(MalumAttachmentTypes.SOUL_WARD);
        if (object instanceof SoulWardData) {
            SoulWardData data = (SoulWardData)object;
            this.setHealth((float)data.getSoulWard());
        }
    }

    public void takeDamage(DamageSource source, float amount, @Nullable Vec3 location) {
        LivingEntity owner;
        if (this.isInvulnerableTo(source)) {
            return;
        }
        this.age -= 10;
        amount /= this.spellPower;
        Object object = this.owner;
        if (object instanceof LivingEntity && (object = (owner = object).getData(MalumAttachmentTypes.SOUL_WARD)) instanceof SoulWardData) {
            SoulWardData data = (SoulWardData)object;
            data.reduceSoulWard((double)amount);
            this.setHealth((float)data.getSoulWard());
        } else {
            super.takeDamage(source, amount, location);
        }
        if (!this.level().isClientSide && location != null) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, (double)location.x, (double)location.y, (double)location.z, (int)30, (double)0.1, (double)0.1, (double)0.1, (double)0.5, (boolean)false);
            this.level().playSound(null, location.x, location.y, location.z, (SoundEvent)SoundRegistry.FORCE_IMPACT.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
            this.level().playSound(null, location.x, location.y, location.z, (SoundEvent)MalumSoundEvents.SOUL_WARD_DEPLETE.get(), SoundSource.NEUTRAL, 0.8f, 1.0f);
        }
    }

    public void tick() {
        SoulWardData data;
        LivingEntity owner;
        this.hurtThisTick = false;
        Object object = this.owner;
        if (object instanceof LivingEntity && (object = (owner = object).getData(MalumAttachmentTypes.SOUL_WARD)) instanceof SoulWardData && (data = (SoulWardData)object).getSoulWard() <= 0.0) {
            this.destroy();
            return;
        }
        super.tick();
    }

    public void onAntiMagic(MagicData playerMagicData) {
    }

    protected void destroy() {
        super.destroy();
    }
}

