/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.compat.irons_spellbooks.spells.soulward_shield;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.strawberry.gaze.compat.irons_spellbooks.entity.spells.SoulwardShieldEntity;
import com.strawberry.gaze.compat.irons_spellbooks.spells.soulward_shield.SoulwardShieldModel;
import com.strawberry.gaze.compat.irons_spellbooks.spells.soulward_shield.SoulwardShieldTrimLayer;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.render.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SoulwardShieldRenderer
extends EntityRenderer<SoulwardShieldEntity>
implements RenderLayerParent<SoulwardShieldEntity, SoulwardShieldModel> {
    public static ResourceLocation SPECTRAL_OVERLAY_TEXTURE = IronsSpellbooks.id((String)"textures/entity/shield/shield_overlay.png");
    private static ResourceLocation SIGIL_TEXTURE = IronsSpellbooks.id((String)"textures/block/scroll_forge_sigil.png");
    private final SoulwardShieldModel model;
    protected final List<RenderLayer<SoulwardShieldEntity, SoulwardShieldModel>> layers = new ArrayList<RenderLayer<SoulwardShieldEntity, SoulwardShieldModel>>();

    public SoulwardShieldRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SoulwardShieldModel(context.bakeLayer(SoulwardShieldModel.LAYER_LOCATION));
        this.layers.add(new SoulwardShieldTrimLayer(this, context));
    }

    public void render(SoulwardShieldEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        PoseStack.Pose pose = poseStack.last();
        Matrix4f poseMatrix = pose.pose();
        Matrix3f normalMatrix = pose.normal();
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
        Vec2 offset = SoulwardShieldRenderer.getEnergySwirlOffset(entity, partialTicks);
        VertexConsumer consumer = bufferSource.getBuffer(RenderHelper.CustomerRenderType.magicSwirl((ResourceLocation)this.getTextureLocation(entity), (float)offset.x, (float)offset.y));
        float width = entity.getBbWidth() * 3.0f;
        poseStack.scale(width, width, width);
        RenderSystem.disableBlend();
        this.model.renderToBuffer(poseStack, consumer, 0xF000F0, OverlayTexture.NO_OVERLAY, RenderHelper.colorf((float)0.5f, (float)0.1f, (float)0.8f));
        for (RenderLayer<SoulwardShieldEntity, SoulwardShieldModel> layer : this.layers) {
            layer.render(poseStack, bufferSource, light, (Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        poseStack.popPose();
        super.render((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    private static float shittyNoise(float f) {
        return (float)(Math.sin(f / 4.0f) + 2.0 * Math.sin(f / 3.0f) + 3.0 * Math.sin(f / 2.0f) + 4.0 * Math.sin(f)) * 0.25f;
    }

    public static Vec2 getEnergySwirlOffset(SoulwardShieldEntity entity, float partialTicks, int offset) {
        float f = ((float)entity.tickCount + partialTicks) * 0.02f;
        return new Vec2(SoulwardShieldRenderer.shittyNoise(1.2f * f + (float)offset), SoulwardShieldRenderer.shittyNoise(f + 456.0f + (float)offset));
    }

    public static Vec2 getEnergySwirlOffset(SoulwardShieldEntity entity, float partialTicks) {
        return SoulwardShieldRenderer.getEnergySwirlOffset(entity, partialTicks, 0);
    }

    public SoulwardShieldModel getModel() {
        return this.model;
    }

    public ResourceLocation getTextureLocation(SoulwardShieldEntity soulwardShieldEntity) {
        return SPECTRAL_OVERLAY_TEXTURE;
    }
}

