/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.visual_effects;

import com.sammy.malum.common.block.curiosities.spirit_altar.AltarCraftingHelper;
import com.sammy.malum.common.block.curiosities.spirit_altar.IAltarAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_altar.SpiritAltarBlockEntity;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.type.SpiritArcanaType;
import com.sammy.malum.core.systems.spirit.type.SpiritLike;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.visual_effects.ItemCrumbleParticleEffects;
import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.strawberry.gaze.common.block.curiosities.fusion_altar.FusionAltarBlockEntity;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.SimpleParticleOptions;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataWrapper;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class FusionAltarParticleEffects {
    private FusionAltarParticleEffects() {
    }

    @Nullable
    public static SpiritLike getCentralSpiritType(FusionAltarBlockEntity altar) {
        SpiritShardItem s;
        LodestoneBlockEntityInventory spirits = altar.spiritInventory;
        Level level = altar.getLevel();
        if (spirits == null || level == null || spirits.getFilledSlotCount() == 0) {
            return null;
        }
        int filled = spirits.getFilledSlotCount();
        Item current = spirits.getStackInSlot(0).getItem();
        if (filled > 1) {
            float duration = 30.0f * (float)filled;
            float gameTime = (float)(level.getGameTime() % (long)duration) / 30.0f;
            current = spirits.getStackInSlot(Mth.floor((float)gameTime)).getItem();
        }
        return current instanceof SpiritShardItem ? (s = (SpiritShardItem)current) : null;
    }

    public static void passiveFusionAltarParticles(FusionAltarBlockEntity altar) {
        int i;
        boolean showActive;
        Level level = altar.getLevel();
        if (level == null) {
            return;
        }
        SpiritLike active = FusionAltarParticleEffects.getCentralSpiritType(altar);
        if (active == null) {
            return;
        }
        RandomSource random = level.random;
        Vec3 center = altar.getItemPos();
        LodestoneBlockEntityInventory spirits = altar.spiritInventory;
        boolean hasPrimeBook = !altar.inventory.getStackInSlot(0).isEmpty() && altar.inventory.getStackInSlot(0).is(Items.BOOK);
        boolean hasAnyPedestalItems = !AltarCraftingHelper.capturePedestals((Level)level, (BlockPos)altar.getBlockPos()).isEmpty();
        boolean bl = showActive = hasPrimeBook && hasAnyPedestalItems && spirits != null && spirits.getFilledSlotCount() > 0;
        if (!altar.accelerators.isEmpty()) {
            for (IAltarAccelerator accel : altar.accelerators) {
                if (accel == null || !accel.canAccelerate()) continue;
                accel.addParticles((SpiritAltarBlockEntity)altar, active.getSpirit());
            }
            if (showActive) {
                SpiritLightSpecs.rotatingLightSpecs((Level)level, (Vec3)center, (SpiritLike)active, (float)0.5f, (int)3, b -> b.multiplyLifetime(1.2f).modifyScaleData(d -> d.multiplyValue(1.2f)));
            }
        }
        if (spirits != null) {
            int visualIndex = 0;
            BlockPos bp = altar.getBlockPos();
            for (i = 0; i < spirits.getSlots(); ++i) {
                ItemStack stack = spirits.getStackInSlot(i);
                Item item = stack.getItem();
                if (!(item instanceof SpiritShardItem)) continue;
                SpiritShardItem shard = (SpiritShardItem)item;
                Vec3 offset = altar.getSpiritItemOffset(visualIndex++, 0.0f);
                Vec3 shardPos = offset.add((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
                SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)shardPos, (SpiritLike)shard).spawnParticles();
                if (!showActive) continue;
                Vec3 vel = center.subtract(shardPos).normalize().scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.03f, (float)0.06f));
                if (random.nextFloat() < 0.35f) {
                    ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks((Level)level, (Vec3)shardPos, (SpiritLike)shard);
                    sparks.getBuilder().setMotion(vel).modifyScaleData(d -> d.multiplyValue(1.2f));
                    sparks.getBloomBuilder().setMotion(vel);
                    sparks.spawnParticles();
                }
                if (!(random.nextFloat() < 0.35f)) continue;
                ParticleEffectSpawner light = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)shardPos, (SpiritLike)shard);
                light.getBuilder().multiplyLifetime(0.8f).setMotion(vel.scale(1.5)).modifyScaleData(d -> d.multiplyValue(1.6f));
                light.getBloomBuilder().setMotion(vel);
                light.spawnParticles();
            }
        }
        if (showActive) {
            for (int i2 = 0; i2 < 1; ++i2) {
                SpiritArcanaType cycling = active.getSpirit();
                float xo = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
                float yo = (float)i2 * 0.05f;
                float zo = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
                Vec3 p = center.add((double)xo, (double)yo, (double)zo);
                int delay = 3 + i2 * 2;
                ParticleEffectSpawner shine = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)p, (SpiritLike)cycling, (WorldParticleOptions)new WorldParticleOptions((Supplier)MalumParticles.SHINE));
                if (!(random.nextFloat() < 0.35f)) continue;
                shine.getBuilder().modifyTransparencyData(d -> d.multiplyValue(1.25f)).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).randomSpinOffset(random).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.25f).build()).multiplyLifetime(1.1f).setLifeDelay(delay).disableNoClip();
                shine.getBloomBuilder().modifyScaleData(d -> d.multiplyValue(2.2f)).modifyTransparencyData(d -> d.multiplyValue(1.1f)).multiplyLifetime(0.85f).setLifeDelay(delay).disableNoClip();
                shine.spawnParticles();
            }
            long gt = level.getGameTime();
            for (i = 0; i < spirits.getFilledSlotCount(); ++i) {
                Vec3 ring = VecHelper.rotatingRadialOffset((Vec3)center, (float)0.6f, (float)i, (float)6.0f, (float)gt, (float)160.0f);
                int finalI = i;
                Consumer<WorldParticleBuilder> act = b -> b.addTickActor(p -> {
                    if (level.getGameTime() > gt + (long)finalI * 4L && level.getGameTime() < gt + ((long)finalI + 4L) * 4L) {
                        p.setParticleSpeed(p.getParticleSpeed().add(0.0, 0.0125, 0.0));
                    }
                });
                int life = RandomHelper.randomBetween((RandomSource)random, (int)10, (int)18) + i * 2;
                ParticleEffectSpawner glow = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)ring, (SpiritLike)active);
                glow.getBuilder().act(act).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(life);
                glow.getBloomBuilder().act(act).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.3f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(life);
                glow.spawnParticles();
            }
            List pedestals = AltarCraftingHelper.capturePedestals((Level)level, (BlockPos)altar.getBlockPos());
            for (IMalumSpecialItemAccessPoint p : pedestals) {
                ItemStack stack = p.getSuppliedInventory().getStackInSlot(0);
                if (stack.isEmpty()) continue;
                Vec3 start = p.getItemPos();
                Vec3 dir = center.subtract(start).normalize();
                Vec3 vel = dir.scale((double)RandomHelper.randomBetween((RandomSource)random, (float)0.015f, (float)0.03f));
                long t0 = level.getGameTime();
                Consumer<LodestoneWorldParticle> pull = pw -> {
                    if (level.getGameTime() > t0 + 4L && level.getGameTime() < t0 + 28L) {
                        pw.setParticleSpeed(pw.getParticleSpeed().add(vel));
                    }
                };
                SpiritArcanaType color = active.getSpirit();
                ParticleEffectSpawner thread = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)start, (SpiritLike)color);
                thread.getBuilder().addTickActor(pull).setMotion(vel).multiplyLifetime(2.0f);
                thread.getBloomBuilder().addTickActor(pull).setMotion(vel).multiplyLifetime(1.6f);
                thread.spawnParticles();
                if (!(random.nextFloat() < 0.25f)) continue;
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks((Level)level, (Vec3)start, (SpiritLike)color);
                sparks.getBuilder().addTickActor(pull).setMotion(vel).multiplyLifetime(2.0f);
                sparks.getBloomBuilder().addTickActor(pull).setMotion(vel).multiplyLifetime(1.6f);
                sparks.spawnParticles();
            }
        }
    }

    public static void eatItemParticles(Level level, FusionAltarBlockEntity altar, IMalumSpecialItemAccessPoint holder, MalumNetworkedParticleEffectColorData colorData, ItemStack stack) {
        int i;
        SpiritLike active = FusionAltarParticleEffects.getCentralSpiritType(altar);
        if (active == null) {
            return;
        }
        long gt = level.getGameTime();
        RandomSource random = level.random;
        Vec3 target = altar.getItemPos();
        Vec3 origin = holder.getItemPos();
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing((Level)level, (Vec3)origin, (SpiritLike)active);
        }
        for (i = 0; i < 16; ++i) {
            SpiritArcanaType cycling = colorData.getSpirit();
            Vec3 vel = target.subtract(origin).normalize().scale(0.025);
            Vec3 ring = VecHelper.rotatingRadialOffset((Vec3)origin, (float)0.5f, (float)i, (float)16.0f, (float)gt, (float)160.0f);
            int finalI = i;
            Consumer<LodestoneWorldParticle> pull = p -> {
                if (level.getGameTime() > gt + (long)finalI * 2L && level.getGameTime() < gt + ((long)finalI + 4L) * 2L) {
                    p.setParticleSpeed(p.getParticleSpeed().add(vel));
                }
            };
            ParticleEffectSpawner light = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)ring, (SpiritLike)cycling);
            light.getBuilder().addTickActor(pull).multiplyLifetime(2.5f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)1.0f, (float)2.0f)));
            light.getBloomBuilder().addTickActor(pull).multiplyLifetime(2.0f).modifyScaleData(d -> d.multiplyValue(RandomHelper.randomBetween((RandomSource)random, (float)0.6f, (float)1.5f)));
            light.spawnParticles();
            ParticleEffectSpawner crumbs = ItemCrumbleParticleEffects.spawnItemCrumbs((Level)level, (Vec3)origin, (ItemStack)stack);
            crumbs.getBuilder().setLifeDelay(i).addTickActor(pull);
            crumbs.spawnParticles();
            crumbs.getBuilder().setRandomOffset(0.2);
            crumbs.spawnParticles();
        }
    }

    public static void craftItemParticles(Level level, FusionAltarBlockEntity altar, MalumNetworkedParticleEffectColorData colorData) {
        int i;
        SpiritLike active = FusionAltarParticleEffects.getCentralSpiritType(altar);
        if (active == null) {
            return;
        }
        long gt = level.getGameTime();
        RandomSource random = level.random;
        BlockPos bp = altar.getBlockPos();
        Vec3 center = altar.getCentralItemOffset().add((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
        for (i = 0; i < 2; ++i) {
            SpiritLightSpecs.coolLookingShinyThing((Level)level, (Vec3)center, (SpiritLike)active);
        }
        for (i = 0; i < 8; ++i) {
            SpiritArcanaType cycling = colorData.getSpirit();
            float xo = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
            float yo = (float)i * 0.08f;
            float zo = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)0.1f, (float)0.5f) * (float)(random.nextBoolean() ? -1 : 1);
            Vec3 p = center.add((double)xo, (double)yo, (double)zo);
            int delay = 5 + i * 3;
            ParticleEffectSpawner shine = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)p, (SpiritLike)cycling, (WorldParticleOptions)new WorldParticleOptions((Supplier)MalumParticles.SHINE));
            shine.getBuilder().modifyTransparencyData(d -> d.multiplyValue(1.25f)).setSpinData((SpinParticleDataWrapper)SpinParticleData.create((float)0.0f).randomSpinOffset(random).build()).setSpritePicker(SimpleParticleOptions.ParticleSpritePicker.WITH_AGE).setScaleData((GenericParticleDataWrapper)GenericParticleData.create((float)0.3f).build()).multiplyLifetime(1.25f).setLifeDelay(delay).disableNoClip();
            shine.getBloomBuilder().modifyScaleData(d -> d.multiplyValue(3.0f)).modifyTransparencyData(d -> d.multiplyValue(1.25f)).multiplyLifetime(0.85f).setLifeDelay(delay).disableNoClip();
            shine.spawnParticles();
        }
        for (i = 0; i < 12; ++i) {
            int delay = i / 4;
            SpiritArcanaType cycling = colorData.getSpirit();
            float xv = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float yv = RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.5f);
            float zv = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CUBIC_OUT, (float)-0.075f, (float)0.075f);
            float g = RandomHelper.randomBetween((RandomSource)random, (float)0.75f, (float)1.0f);
            if (random.nextFloat() < 0.85f) {
                ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks((Level)level, (Vec3)center, (SpiritLike)cycling);
                sparks.getBuilder().disableNoClip().setLifeDelay(delay).multiplyLifetime(1.5f).setGravity(g).setMotion((double)xv, (double)yv, (double)zv).modifyScaleData(d -> d.multiplyValue(2.0f));
                sparks.getBloomBuilder().disableNoClip().setLifeDelay(delay).multiplyLifetime(1.5f).setGravity(g).setMotion((double)xv, (double)yv, (double)zv).modifyTransparencyData(d -> d.multiplyValue(1.25f));
                sparks.spawnParticles();
            }
            if (!(random.nextFloat() < 0.85f)) continue;
            float xv2 = xv * 1.25f;
            float yv2 = yv * 0.75f;
            float zv2 = zv * 1.25f;
            ParticleEffectSpawner light = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)center, (SpiritLike)cycling);
            light.getBuilder().disableNoClip().setLifeDelay(delay).multiplyLifetime(2.0f).setGravity(g).setMotion((double)xv2, (double)yv2, (double)zv2).modifyScaleData(d -> d.multiplyValue(2.5f));
            light.getBloomBuilder().disableNoClip().setLifeDelay(delay).multiplyLifetime(1.5f).setGravity(g).setMotion((double)xv2, (double)yv2, (double)zv2).modifyTransparencyData(d -> d.multiplyValue(1.25f));
            light.spawnParticles();
        }
        for (i = 0; i < 8; ++i) {
            Vec3 ring = VecHelper.rotatingRadialOffset((Vec3)center, (float)0.6f, (float)i, (float)8.0f, (float)gt, (float)160.0f);
            int finalI = i;
            Consumer<WorldParticleBuilder> lift = b -> b.addTickActor(p -> {
                if (level.getGameTime() > gt + (long)finalI * 4L && level.getGameTime() < gt + ((long)finalI + 4L) * 4L) {
                    p.setParticleSpeed(p.getParticleSpeed().add(0.0, 0.015, 0.0));
                }
            });
            int life = RandomHelper.randomBetween((RandomSource)random, (int)10, (int)20) + i * 2;
            ParticleEffectSpawner glow = SpiritLightSpecs.spiritLightSpecs((Level)level, (Vec3)ring, (SpiritLike)active);
            glow.getBuilder().act(lift).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(2.0f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(life);
            glow.getBloomBuilder().act(lift).modifyColorData(d -> d.multiplyCoefficient(0.35f)).modifyScaleData(d -> d.multiplyValue(1.6f).multiplyCoefficient(0.9f)).modifyTransparencyData(d -> d.multiplyCoefficient(0.9f)).setLifetime(life);
            glow.spawnParticles();
        }
    }
}

