/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.attachment;

import com.mojang.serialization.Codec;
import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.TemporaryGenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.event.custom.GeneChangeEvent;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.SetGenesPacket;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttachmentTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B\u001d\b\u0016\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\n0\t\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData;", "", "genes", "Lnet/minecraft/core/HolderSet;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "<init>", "(Lnet/minecraft/core/HolderSet;)V", "()V", "set", "", "Lnet/minecraft/core/Holder;", "(Ljava/util/Set;)V", "getGenes", "()Lnet/minecraft/core/HolderSet;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
public final class GenesData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HolderSet<Gene> genes;
    @NotNull
    private static final Codec<GenesData> CODEC;

    public GenesData(@NotNull HolderSet<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        this.genes = genes;
    }

    @NotNull
    public final HolderSet<Gene> getGenes() {
        return this.genes;
    }

    public GenesData() {
        HolderSet holderSet = HolderSet.empty();
        Intrinsics.checkNotNullExpressionValue((Object)holderSet, (String)"empty(...)");
        this((HolderSet<Gene>)holderSet);
    }

    public GenesData(@NotNull Set<? extends Holder<Gene>> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        HolderSet.Direct direct = HolderSet.direct((List)CollectionsKt.toList((Iterable)set));
        Intrinsics.checkNotNullExpressionValue((Object)direct, (String)"direct(...)");
        this((HolderSet<Gene>)((HolderSet)direct));
    }

    @NotNull
    public final HolderSet<Gene> component1() {
        return this.genes;
    }

    @NotNull
    public final GenesData copy(@NotNull HolderSet<Gene> genes) {
        Intrinsics.checkNotNullParameter(genes, (String)"genes");
        return new GenesData(genes);
    }

    public static /* synthetic */ GenesData copy$default(GenesData genesData, HolderSet holderSet, int n, Object object) {
        if ((n & 1) != 0) {
            holderSet = genesData.genes;
        }
        return genesData.copy(holderSet);
    }

    @NotNull
    public String toString() {
        return "GenesData(genes=" + this.genes + ")";
    }

    public int hashCode() {
        return this.genes.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenesData)) {
            return false;
        }
        GenesData genesData = (GenesData)other;
        return Intrinsics.areEqual(this.genes, genesData.genes);
    }

    private static final GenesData CODEC$lambda$0(List it) {
        Intrinsics.checkNotNull((Object)it);
        return new GenesData(CollectionsKt.toSet((Iterable)it));
    }

    private static final GenesData CODEC$lambda$1(Function1 $tmp0, Object p0) {
        return (GenesData)$tmp0.invoke(p0);
    }

    private static final List CODEC$lambda$2(GenesData it) {
        return CollectionsKt.toList((Iterable)((Iterable)it.genes));
    }

    private static final List CODEC$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @NotNull
    public static final Set<Holder<Gene>> getPermanentGeneHolders(@NotNull LivingEntity $this$getPermanentGeneHolders) {
        return Companion.getPermanentGeneHolders($this$getPermanentGeneHolders);
    }

    private static final void setPermanentGeneHolders(LivingEntity $this$setPermanentGeneHolders, Set<? extends Holder<Gene>> value) {
        GenesData.Companion.setPermanentGeneHolders($this$setPermanentGeneHolders, value);
    }

    @JvmStatic
    @NotNull
    public static final Set<Holder<Gene>> getGenes(@NotNull LivingEntity $this$getGenes) {
        return Companion.getGenes($this$getGenes);
    }

    @JvmStatic
    public static final boolean addGene(@NotNull LivingEntity $this$addGene, @NotNull Holder<Gene> newGeneHolder) {
        return Companion.addGene($this$addGene, newGeneHolder);
    }

    @JvmStatic
    public static final boolean removeGene(@NotNull LivingEntity $this$removeGene, @NotNull Holder<Gene> removedGeneHolder) {
        return Companion.removeGene($this$removeGene, removedGeneHolder);
    }

    @JvmStatic
    public static final boolean hasPermanentGene(@NotNull Entity $this$hasPermanentGene, @NotNull Holder<Gene> gene) {
        return Companion.hasPermanentGene($this$hasPermanentGene, gene);
    }

    @JvmStatic
    public static final boolean hasGene(@NotNull Entity $this$hasGene, @NotNull Holder<Gene> gene) {
        return Companion.hasGene($this$hasGene, gene);
    }

    @JvmStatic
    public static final boolean hasGene(@NotNull Entity $this$hasGene, @NotNull ResourceKey<Gene> geneKey) {
        return Companion.hasGene($this$hasGene, geneKey);
    }

    @JvmStatic
    public static final void removeAllGenes(@NotNull LivingEntity $this$removeAllGenes) {
        Companion.removeAllGenes($this$removeAllGenes);
    }

    @JvmStatic
    public static final void addAllGenes(@NotNull LivingEntity $this$addAllGenes, @NotNull HolderLookup.Provider registries, boolean includeNegative) {
        Companion.addAllGenes($this$addAllGenes, registries, includeNegative);
    }

    static {
        Codec codec = Gene.Companion.getCODEC().listOf().xmap(arg_0 -> GenesData.CODEC$lambda$1(GenesData::CODEC$lambda$0, arg_0), arg_0 -> GenesData.CODEC$lambda$3(GenesData::CODEC$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"xmap(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e*\u00020\u0012H\u0007J\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u001a\u0010\u001d\u001a\u00020\u001b*\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J+\u0010\u001f\u001a\u00020\u001b*\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000J+\u0010\"\u001a\u00020\u001b*\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000J+\u0010\"\u001a\u00020\u001b*\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$H\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000J\f\u0010%\u001a\u00020\n*\u00020\u0012H\u0007J\u001e\u0010&\u001a\u00020\n*\u00020\u00122\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u001bH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRF\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e*\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e8F@BX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00f2\u0001\u0004\n\u00020\u0012\u00a8\u0006*"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/aaronhowser/mods/geneticsresequenced/attachment/GenesData;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "syncPlayer", "", "player", "Lnet/minecraft/world/entity/player/Player;", "value", "", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "permanentGeneHolders", "Lnet/minecraft/world/entity/LivingEntity;", "getPermanentGeneHolders$annotations", "(Lnet/minecraft/world/entity/LivingEntity;)V", "getPermanentGeneHolders", "(Lnet/minecraft/world/entity/LivingEntity;)Ljava/util/Set;", "setPermanentGeneHolders", "(Lnet/minecraft/world/entity/LivingEntity;Ljava/util/Set;)V", "getGenes", "addGene", "", "newGeneHolder", "removeGene", "removedGeneHolder", "hasPermanentGene", "Lnet/minecraft/world/entity/Entity;", "gene", "hasGene", "geneKey", "Lnet/minecraft/resources/ResourceKey;", "removeAllGenes", "addAllGenes", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "includeNegative", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nGenesData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenesData.kt\ndev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Forge.kt\nthedarkcolour/kotlinforforge/neoforge/forge/ForgeKt\n*L\n1#1,198:1\n1563#2:199\n1634#2,3:200\n774#2:203\n865#2,2:204\n17#3:206\n17#3:207\n17#3:208\n17#3:209\n*S KotlinDebug\n*F\n+ 1 GenesData.kt\ndev/aaronhowser/mods/geneticsresequenced/attachment/GenesData$Companion\n*L\n91#1:199\n91#1:200,3\n105#1:203\n105#1:204,2\n120#1:206\n128#1:207\n139#1:208\n148#1:209\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<GenesData> getCODEC() {
            return CODEC;
        }

        public final void syncPlayer(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            SetGenesPacket packet = new SetGenesPacket(((ServerPlayer)player).getId(), (Collection<? extends Holder<Gene>>)this.getPermanentGeneHolders((LivingEntity)player));
            packet.messagePlayer((ServerPlayer)player);
        }

        @NotNull
        public final Set<Holder<Gene>> getPermanentGeneHolders(@NotNull LivingEntity $this$permanentGeneHolders) {
            Intrinsics.checkNotNullParameter((Object)$this$permanentGeneHolders, (String)"<this>");
            return CollectionsKt.toSet((Iterable)((Iterable)((GenesData)$this$permanentGeneHolders.getData((Supplier)ModAttachmentTypes.INSTANCE.getGENE_CONTAINER())).getGenes()));
        }

        private final void setPermanentGeneHolders(LivingEntity $this$permanentGeneHolders, Set<? extends Holder<Gene>> value) {
            $this$permanentGeneHolders.setData((Supplier)ModAttachmentTypes.INSTANCE.getGENE_CONTAINER(), (Object)new GenesData(value));
        }

        @JvmStatic
        public static /* synthetic */ void getPermanentGeneHolders$annotations(LivingEntity livingEntity) {
        }

        @JvmStatic
        @NotNull
        public final Set<Holder<Gene>> getGenes(@NotNull LivingEntity $this$getGenes) {
            Intrinsics.checkNotNullParameter((Object)$this$getGenes, (String)"<this>");
            return SetsKt.plus(this.getPermanentGeneHolders($this$getGenes), (Iterable)TemporaryGenesData.Companion.getTemporaryGeneHolders($this$getGenes));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean addGene(@NotNull LivingEntity $this$addGene, @NotNull Holder<Gene> newGeneHolder) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$addGene, (String)"<this>");
            Intrinsics.checkNotNullParameter(newGeneHolder, (String)"newGeneHolder");
            if (this.hasGene((Entity)$this$addGene, newGeneHolder)) {
                return false;
            }
            if (Gene.Companion.isHelixOnly(newGeneHolder)) {
                GeneticsResequenced.Companion.getLOGGER().debug("Cannot add gene " + newGeneHolder + " to entities, as it has tag `#geneticsresequenced:helix_only`.");
                return false;
            }
            if ($this$addGene instanceof Player && Gene.Companion.isNegative(newGeneHolder) && ((Boolean)ServerConfig.Companion.getCONFIG().getDisableGivingPlayersNegativeGenes().get()).booleanValue() && !AaronExtensions.INSTANCE.isHolder(newGeneHolder, ModGenes.CRINGE)) {
                Logger logger = GeneticsResequenced.Companion.getLOGGER();
                StringBuilder stringBuilder = new StringBuilder().append("Tried to give negative gene ");
                Holder<Gene> holder = newGeneHolder.getKey();
                if (holder == null || (holder = holder.location()) == null) {
                    holder = newGeneHolder;
                }
                logger.debug(stringBuilder.append(holder).append(" to player ").append(((Player)$this$addGene).getName().getString()).append(", but \"disableGivingPlayersNegativeGenes\" is true in the server config.").toString());
                return false;
            }
            Iterable $this$map$iv = (Iterable)((Gene)newGeneHolder.value()).getAllowedEntities();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Holder holder = (Holder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((EntityType)p0.value());
            }
            List allowedTypes = (List)destination$iv$iv;
            if (!allowedTypes.contains($this$addGene.getType())) {
                Logger logger = GeneticsResequenced.Companion.getLOGGER();
                StringBuilder stringBuilder = new StringBuilder().append("Tried to give gene ");
                Holder<Gene> holder = newGeneHolder.getKey();
                if (holder == null || (holder = holder.location()) == null) {
                    holder = newGeneHolder;
                }
                logger.debug(stringBuilder.append(holder).append(" to entity ").append($this$addGene.getName().getString()).append(", but that entity type cannot have that gene!").toString());
                return false;
            }
            List<ResourceKey<Gene>> incompatibleGenes = ((Gene)newGeneHolder.value()).getIncompatibleGenes();
            Iterable $this$filter$iv = this.getPermanentGeneHolders($this$addGene);
            boolean $i$f$filter = false;
            Iterable $i$f$mapTo22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Holder it = (Holder)element$iv$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)incompatibleGenes, (Object)it.getKey())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List foundIncompatibleGenes = (List)destination$iv$iv2;
            if (!((Collection)foundIncompatibleGenes).isEmpty()) {
                Logger logger = GeneticsResequenced.Companion.getLOGGER();
                StringBuilder stringBuilder = new StringBuilder().append("Tried to give gene ");
                Holder<Gene> holder = newGeneHolder.getKey();
                if (holder == null || (holder = holder.location()) == null) {
                    holder = newGeneHolder;
                }
                logger.debug(stringBuilder.append(holder).append(" to entity ").append($this$addGene.getName().getString()).append(", but it is incompatible with the following genes the entity already has: ").append(CollectionsKt.joinToString$default((Iterable)foundIncompatibleGenes, null, null, null, (int)0, null, Companion::addGene$lambda$1, (int)31, null)).toString());
                return false;
            }
            GeneChangeEvent.Pre eventPre = new GeneChangeEvent.Pre($this$addGene, newGeneHolder, true);
            boolean $i$f$getFORGE_BUS = false;
            IEventBus iEventBus = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
            if (((GeneChangeEvent.Pre)iEventBus.post((Event)eventPre)).isCanceled()) {
                GeneticsResequenced.Companion.getLOGGER().debug("Event was canceled: " + eventPre);
                return false;
            }
            this.setPermanentGeneHolders($this$addGene, SetsKt.plus(this.getPermanentGeneHolders($this$addGene), newGeneHolder));
            GeneChangeEvent.Post eventPost = new GeneChangeEvent.Post($this$addGene, newGeneHolder, true);
            boolean $i$f$getFORGE_BUS2 = false;
            IEventBus iEventBus2 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
            iEventBus2.post((Event)eventPost);
            return true;
        }

        @JvmStatic
        public final boolean removeGene(@NotNull LivingEntity $this$removeGene, @NotNull Holder<Gene> removedGeneHolder) {
            Intrinsics.checkNotNullParameter((Object)$this$removeGene, (String)"<this>");
            Intrinsics.checkNotNullParameter(removedGeneHolder, (String)"removedGeneHolder");
            if (!this.hasGene((Entity)$this$removeGene, removedGeneHolder)) {
                return false;
            }
            GeneChangeEvent.Pre eventPre = new GeneChangeEvent.Pre($this$removeGene, removedGeneHolder, false);
            boolean $i$f$getFORGE_BUS = false;
            IEventBus iEventBus = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
            boolean wasCanceled = ((GeneChangeEvent.Pre)iEventBus.post((Event)eventPre)).isCanceled();
            if (wasCanceled) {
                GeneticsResequenced.Companion.getLOGGER().debug("Event was canceled: " + eventPre);
                return false;
            }
            this.setPermanentGeneHolders($this$removeGene, SetsKt.minus(this.getPermanentGeneHolders($this$removeGene), removedGeneHolder));
            GeneChangeEvent.Post eventPost = new GeneChangeEvent.Post($this$removeGene, removedGeneHolder, false);
            boolean $i$f$getFORGE_BUS2 = false;
            IEventBus iEventBus2 = NeoForge.EVENT_BUS;
            Intrinsics.checkNotNullExpressionValue((Object)iEventBus2, (String)"EVENT_BUS");
            iEventBus2.post((Event)eventPost);
            return true;
        }

        @JvmStatic
        public final boolean hasPermanentGene(@NotNull Entity $this$hasPermanentGene, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)$this$hasPermanentGene, (String)"<this>");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            if (Gene.Companion.isDisabled(gene) || !($this$hasPermanentGene instanceof LivingEntity)) {
                return false;
            }
            return this.getPermanentGeneHolders((LivingEntity)$this$hasPermanentGene).contains(gene);
        }

        @JvmStatic
        public final boolean hasGene(@NotNull Entity $this$hasGene, @NotNull Holder<Gene> gene) {
            Intrinsics.checkNotNullParameter((Object)$this$hasGene, (String)"<this>");
            Intrinsics.checkNotNullParameter(gene, (String)"gene");
            if (Gene.Companion.isDisabled(gene) || !($this$hasGene instanceof LivingEntity)) {
                return false;
            }
            return this.getPermanentGeneHolders((LivingEntity)$this$hasGene).contains(gene) || TemporaryGenesData.Companion.getTemporaryGeneHolders((LivingEntity)$this$hasGene).contains(gene);
        }

        @JvmStatic
        public final boolean hasGene(@NotNull Entity $this$hasGene, @NotNull ResourceKey<Gene> geneKey) {
            Intrinsics.checkNotNullParameter((Object)$this$hasGene, (String)"<this>");
            Intrinsics.checkNotNullParameter(geneKey, (String)"geneKey");
            RegistryAccess registryAccess = $this$hasGene.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Holder.Reference<Gene> reference = ModGenes.fromResourceKey((HolderLookup.Provider)registryAccess, geneKey);
            if (reference == null) {
                return false;
            }
            Holder.Reference<Gene> holder = reference;
            return this.hasGene($this$hasGene, (Holder<Gene>)((Holder)holder));
        }

        @JvmStatic
        public final void removeAllGenes(@NotNull LivingEntity $this$removeAllGenes) {
            Intrinsics.checkNotNullParameter((Object)$this$removeAllGenes, (String)"<this>");
            for (Holder<Gene> gene : this.getPermanentGeneHolders($this$removeAllGenes)) {
                this.removeGene($this$removeAllGenes, gene);
            }
        }

        @JvmStatic
        public final void addAllGenes(@NotNull LivingEntity $this$addAllGenes, @NotNull HolderLookup.Provider registries, boolean includeNegative) {
            Intrinsics.checkNotNullParameter((Object)$this$addAllGenes, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            Stream<Object> genesToAdd = ModGenes.getAllGeneHolders(registries).filter(arg_0 -> Companion.addAllGenes$lambda$3(arg_0 -> Companion.addAllGenes$lambda$2(includeNegative, arg_0), arg_0));
            Iterator iterator = genesToAdd.iterator();
            while (iterator.hasNext()) {
                Holder.Reference gene = (Holder.Reference)iterator.next();
                Intrinsics.checkNotNull((Object)gene);
                this.addGene($this$addAllGenes, (Holder<Gene>)((Holder)gene));
            }
        }

        public static /* synthetic */ void addAllGenes$default(Companion companion, LivingEntity livingEntity, HolderLookup.Provider provider, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.addAllGenes(livingEntity, provider, bl);
        }

        private static final CharSequence addGene$lambda$1(Holder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ResourceKey resourceKey = it.getKey();
            return String.valueOf(resourceKey != null ? resourceKey.location() : null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean addAllGenes$lambda$2(boolean $includeNegative, Holder.Reference it) {
            if ($includeNegative) return true;
            Intrinsics.checkNotNull((Object)it);
            if (Gene.Companion.isNegative((Holder<Gene>)((Holder)it))) return false;
            return true;
        }

        private static final boolean addAllGenes$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

