/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0014J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/WebDefenseBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "onPlace", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "oldState", "movedByPiston", "", "tick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "entityInside", "entity", "Lnet/minecraft/world/entity/Entity;", "geneticsresequenced-1.21.1"})
public final class WebDefenseBlock
extends Block {
    public WebDefenseBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.COBWEB)));
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Block block = this;
        Object object = ServerConfig.Companion.getCONFIG().getWebDefenseDuration().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        level.scheduleTick(pos, block, ((Number)object).intValue());
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        level.removeBlock(pos, false);
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 motionMultiplier = new Vec3(0.25, 0.05, 0.25);
        if (entity instanceof LivingEntity) {
            if (((LivingEntity)entity).hasEffect(MobEffects.WEAVING)) {
                motionMultiplier = new Vec3(0.5, 0.25, 0.5);
            } else {
                RegistryAccess registryAccess = level.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
                Holder.Reference<Gene> webWalker = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.WEB_WALKER, (HolderLookup.Provider)registryAccess);
                RegistryAccess registryAccess2 = level.registryAccess();
                Intrinsics.checkNotNullExpressionValue((Object)registryAccess2, (String)"registryAccess(...)");
                Holder.Reference<Gene> webDefense = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.WEB_DEFENSE, (HolderLookup.Provider)registryAccess2);
                if (GenesData.Companion.hasGene(entity, (Holder<Gene>)((Holder)webWalker)) || GenesData.Companion.hasGene(entity, (Holder<Gene>)((Holder)webDefense))) {
                    return;
                }
            }
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.WEAVING)) {
            motionMultiplier = new Vec3(0.5, 0.25, 0.5);
        }
        entity.makeStuckInBlock(state, motionMultiplier);
    }
}

