/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.base;

import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.MachineBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.base.MachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.container_data.CraftingContainerData;
import java.util.function.IntSupplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 C2\u00020\u0001:\u0001CB#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0004J\b\u0010\u0017\u001a\u00020\u0016H\u0004J\b\u0010'\u001a\u00020\u0016H$J\b\u0010(\u001a\u00020)H$J\b\u0010*\u001a\u00020)H\u0014J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-H\u0004J\u0014\u00109\u001a\u0004\u0018\u00010:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0018\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014J\u0018\u0010B\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001b\u0010!\u001a\u00020\"8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u001b\u0010.\u001a\u00020/8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010&\u001a\u0004\b0\u00101R\u001b\u00103\u001a\u00020/8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010&\u001a\u0004\b4\u00101R\u001b\u00106\u001a\u00020/8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010&\u001a\u0004\b7\u00101\u00a8\u0006D"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/MachineBlockEntity;", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getEnergyCostPerTick", "", "getAmountOfOverclocks", "hasEnoughEnergy", "", "drainEnergy", "value", "currentProgress", "getCurrentProgress", "()I", "setCurrentProgress", "(I)V", "maxProgress", "getMaxProgress", "setMaxProgress", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "getContainerData", "()Lnet/minecraft/world/inventory/ContainerData;", "containerData$delegate", "Lkotlin/Lazy;", "hasRecipe", "craftItem", "", "serverTick", "outputSlotHasRoom", "potentialOutput", "Lnet/minecraft/world/item/ItemStack;", "inputHandler", "Lnet/neoforged/neoforge/items/wrapper/RangedWrapper;", "getInputHandler", "()Lnet/neoforged/neoforge/items/wrapper/RangedWrapper;", "inputHandler$delegate", "outputHandler", "getOutputHandler", "outputHandler$delegate", "overclockHandler", "getOverclockHandler", "overclockHandler$delegate", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "direction", "Lnet/minecraft/core/Direction;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Companion", "geneticsresequenced-1.21.1"})
public abstract class CraftingMachineBlockEntity
extends MachineBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImprovedSimpleContainer container;
    private int currentProgress;
    private int maxProgress;
    @NotNull
    private final Lazy containerData$delegate;
    @NotNull
    private final Lazy inputHandler$delegate;
    @NotNull
    private final Lazy outputHandler$delegate;
    @NotNull
    private final Lazy overclockHandler$delegate;
    @NotNull
    public static final String CURRENT_PROGRESS_NBT = "CurrentProgress";
    @NotNull
    public static final String MAX_PROGRESS_NBT = "MaxProgress";
    public static final int DEFAULT_MAX_PROGRESS = 80;
    public static final int DEFAULT_INVENTORY_SIZE = 3;
    public static final int INPUT_SLOT_INDEX = 0;
    public static final int OUTPUT_SLOT_INDEX = 1;
    public static final int OVERCLOCK_SLOT_INDEX = 2;

    public CraftingMachineBlockEntity(@NotNull BlockEntityType<?> blockEntityType, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        super(blockEntityType, pos, blockState);
        this.container = new ImprovedSimpleContainer((BlockEntity)this, 3);
        this.maxProgress = 80;
        this.containerData$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.containerData_delegate$lambda$2(this));
        this.inputHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.inputHandler_delegate$lambda$3(this));
        this.outputHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.outputHandler_delegate$lambda$4(this));
        this.overclockHandler$delegate = LazyKt.lazy(() -> CraftingMachineBlockEntity.overclockHandler_delegate$lambda$5(this));
    }

    @NotNull
    public abstract IntSupplier getBaseEnergyCostPerTick();

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    public int getEnergyCostPerTick() {
        int extraPerOverclocker = Mth.ceil((float)((float)this.getBaseEnergyCostPerTick().getAsInt() * 0.25f));
        int totalExtraCost = extraPerOverclocker * this.getAmountOfOverclocks();
        return this.getBaseEnergyCostPerTick().getAsInt() + totalExtraCost;
    }

    public int getAmountOfOverclocks() {
        return this.getContainer().getItem(2).getCount();
    }

    protected final boolean hasEnoughEnergy() {
        return this.getEnergyStorage().getEnergyStored() >= this.getEnergyCostPerTick();
    }

    protected final boolean drainEnergy() {
        int cost = this.getEnergyCostPerTick();
        if (this.getEnergyStorage().getEnergyStored() < cost) {
            return false;
        }
        this.getEnergyStorage().extractEnergy(cost, false);
        return true;
    }

    protected final int getCurrentProgress() {
        return this.currentProgress;
    }

    protected final void setCurrentProgress(int value) {
        if (this.currentProgress != value) {
            this.currentProgress = value;
            this.setChanged();
        }
    }

    protected final int getMaxProgress() {
        return this.maxProgress;
    }

    protected final void setMaxProgress(int value) {
        if (this.maxProgress != value) {
            this.maxProgress = value;
            this.setChanged();
        }
    }

    @Override
    @NotNull
    protected ContainerData getContainerData() {
        Lazy lazy = this.containerData$delegate;
        return (ContainerData)lazy.getValue();
    }

    protected abstract boolean hasRecipe();

    protected abstract void craftItem();

    @Override
    protected void serverTick() {
        if (!this.hasEnoughEnergy()) {
            return;
        }
        if (!this.hasRecipe()) {
            this.setCurrentProgress(0);
            return;
        }
        this.drainEnergy();
        this.setCurrentProgress(this.currentProgress + (1 + this.getAmountOfOverclocks()));
        while (this.currentProgress >= this.maxProgress) {
            this.setCurrentProgress(this.currentProgress - Math.max(1, this.maxProgress));
            this.craftItem();
        }
    }

    protected final boolean outputSlotHasRoom(@NotNull ItemStack potentialOutput) {
        Intrinsics.checkNotNullParameter((Object)potentialOutput, (String)"potentialOutput");
        ItemStack currentOutput = this.getItemHandler().getStackInSlot(1);
        if (currentOutput.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)potentialOutput, (ItemStack)currentOutput)) {
            return false;
        }
        int combinedCount = currentOutput.getCount() + potentialOutput.getCount();
        return combinedCount <= currentOutput.getMaxStackSize();
    }

    @NotNull
    protected RangedWrapper getInputHandler() {
        Lazy lazy = this.inputHandler$delegate;
        return (RangedWrapper)lazy.getValue();
    }

    @NotNull
    protected RangedWrapper getOutputHandler() {
        Lazy lazy = this.outputHandler$delegate;
        return (RangedWrapper)lazy.getValue();
    }

    @NotNull
    protected RangedWrapper getOverclockHandler() {
        Lazy lazy = this.overclockHandler$delegate;
        return (RangedWrapper)lazy.getValue();
    }

    @Override
    @Nullable
    public IItemHandler getItemHandler(@Nullable Direction direction) {
        Direction direction2 = direction;
        Direction blockFacing = (Direction)this.getBlockState().getValue((Property)MachineBlock.Companion.getH_FACING());
        return direction2 == blockFacing.getOpposite() ? (IItemHandler)this.getOverclockHandler() : (direction2 == Direction.DOWN ? (IItemHandler)this.getOutputHandler() : (IItemHandler)this.getInputHandler());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt(CURRENT_PROGRESS_NBT, this.currentProgress);
        tag.putInt(MAX_PROGRESS_NBT, this.maxProgress);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        if (tag.contains(CURRENT_PROGRESS_NBT)) {
            this.setCurrentProgress(tag.getInt(CURRENT_PROGRESS_NBT));
        }
        if (tag.contains(MAX_PROGRESS_NBT)) {
            this.setMaxProgress(tag.getInt(MAX_PROGRESS_NBT));
        }
    }

    private static final int containerData_delegate$lambda$2$lambda$0(CraftingMachineBlockEntity this$0) {
        return this$0.currentProgress;
    }

    private static final int containerData_delegate$lambda$2$lambda$1(CraftingMachineBlockEntity this$0) {
        return this$0.maxProgress;
    }

    private static final CraftingContainerData containerData_delegate$lambda$2(CraftingMachineBlockEntity this$0) {
        return new CraftingContainerData(this$0.getEnergyStorage(), () -> CraftingMachineBlockEntity.containerData_delegate$lambda$2$lambda$0(this$0), () -> CraftingMachineBlockEntity.containerData_delegate$lambda$2$lambda$1(this$0));
    }

    private static final RangedWrapper inputHandler_delegate$lambda$3(CraftingMachineBlockEntity this$0) {
        return new RangedWrapper(this$0.getItemHandler(), 0, 1);
    }

    private static final RangedWrapper outputHandler_delegate$lambda$4(CraftingMachineBlockEntity this$0) {
        return new RangedWrapper(this$0.getItemHandler(), 1, 2);
    }

    private static final RangedWrapper overclockHandler_delegate$lambda$5(CraftingMachineBlockEntity this$0) {
        return new RangedWrapper(this$0.getItemHandler(), 2, 3);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity$Companion;", "", "<init>", "()V", "CURRENT_PROGRESS_NBT", "", "MAX_PROGRESS_NBT", "DEFAULT_MAX_PROGRESS", "", "DEFAULT_INVENTORY_SIZE", "INPUT_SLOT_INDEX", "OUTPUT_SLOT_INDEX", "OVERCLOCK_SLOT_INDEX", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

