/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.blood_purifier.BloodPurifierMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/BloodPurifierBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "hasRecipe", "", "craftItem", "", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21.1"})
public final class BloodPurifierBlockEntity
extends CraftingMachineBlockEntity {
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    @NotNull
    private final ImprovedSimpleContainer container;

    public BloodPurifierBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getBLOOD_PURIFIER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.maxEnergy = 60000;
        this.energyTransferRate = 256;
        this.baseEnergyCostPerTick = BloodPurifierBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.container = new ImprovedSimpleContainer(this){

            public boolean canPlaceItem(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> SyringeItem.Companion.hasBlood(stack);
                    case 2 -> AaronExtensions.INSTANCE.isItem(stack, (Holder)ModItems.INSTANCE.getOVERCLOCKER());
                    case 1 -> true;
                    default -> false;
                };
            }
        };
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Override
    protected boolean hasRecipe() {
        ItemStack outputStack = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNull((Object)outputStack);
        if (AaronExtensions.INSTANCE.isNotEmpty(outputStack)) {
            return false;
        }
        ItemStack inputStack = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNull((Object)inputStack);
        return AaronExtensions.INSTANCE.isNotEmpty(inputStack) && SyringeItem.Companion.isContaminated(inputStack);
    }

    @Override
    protected void craftItem() {
        if (!this.hasRecipe()) {
            return;
        }
        ItemStack syringeStack = this.getItemHandler().getStackInSlot(0);
        Intrinsics.checkNotNull((Object)syringeStack);
        SyringeItem.Companion.setContaminated(syringeStack, false);
        this.getItemHandler().insertItem(1, syringeStack.copy(), false);
        this.getItemHandler().extractItem(0, 1, false);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new BloodPurifierMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 32;
    }
}

