/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.CoalGeneratorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.base.MachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.block.base.container_data.CraftingContainerData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.menu.coal_generator.CoalGeneratorMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/CoalGeneratorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/MachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "value", "burnTimeRemaining", "setBurnTimeRemaining", "(I)V", "maxBurnTime", "setMaxBurnTime", "containerData", "Lnet/minecraft/world/inventory/ContainerData;", "getContainerData", "()Lnet/minecraft/world/inventory/ContainerData;", "serverTick", "", "tryStartBurning", "generateEnergy", "hasRoomForEnergy", "", "exportEnergy", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Companion", "geneticsresequenced-1.21.1"})
public final class CoalGeneratorBlockEntity
extends MachineBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final ImprovedSimpleContainer container;
    private int burnTimeRemaining;
    private int maxBurnTime;
    @NotNull
    private final ContainerData containerData;
    @NotNull
    public static final String BURN_TIME_REMAINING_NBT = "BurnTimeRemaining";
    @NotNull
    public static final String MAX_BURN_TIME_NBT = "MaxBurnTime";
    public static final int CONTAINER_SIZE = 1;
    public static final int INPUT_SLOT_INDEX = 0;
    public static final int CONTAINER_DATA_SIZE = 2;
    public static final int REMAINING_TICKS_INDEX = 0;
    public static final int MAX_BURN_TIME_INDEX = 1;

    public CoalGeneratorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getCOAL_GENERATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        Object object2 = ServerConfig.Companion.getCONFIG().getCoalGeneratorEnergyCapacity().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.maxEnergy = ((Number)object2).intValue();
        Object object3 = ServerConfig.Companion.getCONFIG().getCoalGeneratorEnergyTransferRate().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.energyTransferRate = ((Number)object3).intValue();
        this.container = new ImprovedSimpleContainer((BlockEntity)this, 1);
        this.containerData = new CraftingContainerData(this.getEnergyStorage(), () -> CoalGeneratorBlockEntity.containerData$lambda$0(this), () -> CoalGeneratorBlockEntity.containerData$lambda$1(this));
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    private final void setBurnTimeRemaining(int value) {
        this.burnTimeRemaining = RangesKt.coerceAtLeast((int)value, (int)0);
        this.setChanged();
    }

    private final void setMaxBurnTime(int value) {
        this.maxBurnTime = RangesKt.coerceAtLeast((int)value, (int)0);
        this.setChanged();
    }

    @Override
    @NotNull
    protected ContainerData getContainerData() {
        return this.containerData;
    }

    @Override
    protected void serverTick() {
        this.exportEnergy();
        if (this.hasRoomForEnergy()) {
            if (this.burnTimeRemaining > 0) {
                this.generateEnergy();
            } else {
                this.tryStartBurning();
            }
        }
    }

    private final void tryStartBurning() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        ItemStack inputItem = this.getContainer().getItem(0);
        int fuelTime = inputItem.getBurnTime(RecipeType.SMELTING);
        if (fuelTime <= 0) {
            return;
        }
        BlockState newState = (BlockState)this.getBlockState().setValue((Property)CoalGeneratorBlock.Companion.getBURNING(), (Comparable)Boolean.valueOf(true));
        level2.setBlockAndUpdate(this.getBlockPos(), newState);
        ItemStack fuelReplacedItem = inputItem.getCraftingRemainingItem();
        this.setMaxBurnTime(fuelTime);
        this.setBurnTimeRemaining(fuelTime);
        this.getItemHandler().extractItem(0, 1, false);
        Intrinsics.checkNotNull((Object)fuelReplacedItem);
        if (AaronExtensions.INSTANCE.isNotEmpty(fuelReplacedItem) && this.getItemHandler().getStackInSlot(0).isEmpty()) {
            this.getItemHandler().insertItem(0, fuelReplacedItem, false);
        }
    }

    private final void generateEnergy() {
        this.getEnergyStorage().receiveEnergy(Companion.getEnergyPerTick(), false);
        int n = this.burnTimeRemaining;
        this.setBurnTimeRemaining(n + -1);
    }

    private final boolean hasRoomForEnergy() {
        return this.getEnergyStorage().getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored();
    }

    private final void exportEnergy() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        if (this.getEnergyStorage().getEnergyStored() <= 0) {
            return;
        }
        for (Direction direction : EntriesMappings.entries$0) {
            IEnergyStorage neighborEnergy;
            BlockPos neighborPos = this.getBlockPos().relative(direction);
            if ((IEnergyStorage)level2.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)direction.getOpposite()) == null || !neighborEnergy.canReceive()) continue;
            int maxEnergyToSend = Math.min(this.getEnergyTransferRate(), this.getEnergyStorage().getEnergyStored());
            int energyToTransfer = neighborEnergy.receiveEnergy(maxEnergyToSend, false);
            this.getEnergyStorage().extractEnergy(energyToTransfer, false);
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        return (AbstractContainerMenu)new CoalGeneratorMenu(pContainerId, pPlayerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putInt(BURN_TIME_REMAINING_NBT, this.burnTimeRemaining);
        tag.putInt(MAX_BURN_TIME_NBT, this.maxBurnTime);
    }

    @Override
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.setBurnTimeRemaining(tag.getInt(BURN_TIME_REMAINING_NBT));
        this.setMaxBurnTime(tag.getInt(MAX_BURN_TIME_NBT));
    }

    private static final int containerData$lambda$0(CoalGeneratorBlockEntity this$0) {
        return this$0.burnTimeRemaining;
    }

    private static final int containerData$lambda$1(CoalGeneratorBlockEntity this$0) {
        return this$0.maxBurnTime;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/CoalGeneratorBlockEntity$Companion;", "", "<init>", "()V", "BURN_TIME_REMAINING_NBT", "", "MAX_BURN_TIME_NBT", "CONTAINER_SIZE", "", "INPUT_SLOT_INDEX", "CONTAINER_DATA_SIZE", "REMAINING_TICKS_INDEX", "MAX_BURN_TIME_INDEX", "getEnergyPerTick", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final int getEnergyPerTick() {
            Object object = ServerConfig.Companion.getCONFIG().getCoalGeneratorEnergyPerTick().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

