/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.dna_decryptor.DnaDecryptorMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001b\u001a\u00020\u0017H\u0014J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J$\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020%H\u0014J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/DnaDecryptorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "isNextGeneSet", "", "nextGeneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "hasRecipe", "getOutputFromInput", "Lnet/minecraft/world/item/ItemStack;", "inputStack", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getPossibleGenes", "", "input", "craftItem", "", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDnaDecryptorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnaDecryptorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/DnaDecryptorBlockEntity\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n126#2:119\n153#2,3:120\n827#3:123\n855#3,2:124\n*S KotlinDebug\n*F\n+ 1 DnaDecryptorBlockEntity.kt\ndev/aaronhowser/mods/geneticsresequenced/block/block_entity/DnaDecryptorBlockEntity\n*L\n98#1:119\n98#1:120,3\n99#1:123\n99#1:124,2\n*E\n"})
public final class DnaDecryptorBlockEntity
extends CraftingMachineBlockEntity {
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final ImprovedSimpleContainer container;
    private boolean isNextGeneSet;
    @Nullable
    private Holder<Gene> nextGeneHolder;

    public DnaDecryptorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getDNA_DECRYPTOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.baseEnergyCostPerTick = DnaDecryptorBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.maxEnergy = 60000;
        this.energyTransferRate = 256;
        this.container = new ImprovedSimpleContainer(this){

            public boolean canPlaceItem(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> AaronExtensions.INSTANCE.isItem(stack, (Holder)ModItems.INSTANCE.getDNA_HELIX());
                    case 2 -> AaronExtensions.INSTANCE.isItem(stack, (Holder)ModItems.INSTANCE.getOVERCLOCKER());
                    case 1 -> true;
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Override
    protected boolean hasRecipe() {
        Level level = this.level;
        if (level == null) {
            return false;
        }
        Level level2 = level;
        ItemStack inputStack = this.getContainer().getItem(0);
        Intrinsics.checkNotNull((Object)inputStack);
        if (!AaronExtensions.INSTANCE.isItem(inputStack, (Holder)ModItems.INSTANCE.getDNA_HELIX())) {
            return false;
        }
        if (inputStack.has((Supplier)ModDataComponents.INSTANCE.getGENE())) {
            return false;
        }
        RegistryAccess registryAccess = level2.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ItemStack itemStack = this.getOutputFromInput(inputStack, (HolderLookup.Provider)registryAccess);
        if (itemStack == null) {
            return false;
        }
        ItemStack outputItem = itemStack;
        return this.outputSlotHasRoom(outputItem);
    }

    private final ItemStack getOutputFromInput(ItemStack inputStack, HolderLookup.Provider registries) {
        Level level = this.level;
        if (level == null) {
            return null;
        }
        Level level2 = level;
        List<Holder<Gene>> possibleGenes = this.getPossibleGenes(inputStack, registries);
        Holder<Gene> geneHolder = null;
        if (!this.isNextGeneSet) {
            int index = level2.random.nextInt(possibleGenes.size());
            geneHolder = possibleGenes.get(index);
            this.nextGeneHolder = geneHolder;
            this.isNextGeneSet = true;
        } else {
            if (!CollectionsKt.contains((Iterable)possibleGenes, this.nextGeneHolder)) {
                this.isNextGeneSet = false;
                return null;
            }
            if (this.nextGeneHolder != null) {
                Holder<Gene> holder = this.nextGeneHolder;
                Intrinsics.checkNotNull(holder);
                geneHolder = holder;
            } else {
                return null;
            }
        }
        ItemStack helixStack = DnaHelixItem.Companion.getHelixStack(geneHolder);
        return helixStack;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Holder<Gene>> getPossibleGenes(ItemStack input, HolderLookup.Provider registries) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Holder it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map<Holder<Gene>, Integer> genesFromMob;
        Holder.Reference<Gene> basic = ModGenes.INSTANCE.getHolderOrThrow(ModGenes.INSTANCE.getBASIC(), registries);
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(input);
        if (entityType == null) {
            return CollectionsKt.listOf(basic);
        }
        EntityType<?> mobType = entityType;
        Map<Holder<Gene>, Integer> map = genesFromMob = EntityGenes.Companion.getGeneHolderWeights(mobType, registries);
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Holder)it.getKey());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Map.Entry element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Holder)element$iv$iv;
            boolean bl = false;
            if (Gene.Companion.isDisabled((Holder<Gene>)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void craftItem() {
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        ItemStack inputStack = this.getContainer().getItem(0);
        Intrinsics.checkNotNull((Object)inputStack);
        RegistryAccess registryAccess = level2.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        ItemStack itemStack = this.getOutputFromInput(inputStack, (HolderLookup.Provider)registryAccess);
        if (itemStack == null) {
            return;
        }
        ItemStack outputStack = itemStack;
        this.getItemHandler().extractItem(0, 1, false);
        this.getItemHandler().insertItem(1, outputStack, false);
        this.isNextGeneSet = false;
        this.nextGeneHolder = null;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new DnaDecryptorMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 32;
    }
}

