/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.block.block_entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.ImprovedSimpleContainer;
import dev.aaronhowser.mods.geneticsresequenced.block.base.CraftingMachineBlockEntity;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.item.SyringeItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.plasmid_injector.PlasmidInjectorMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlockEntityTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/block/block_entity/PlasmidInjectorBlockEntity;", "Ldev/aaronhowser/mods/geneticsresequenced/block/base/CraftingMachineBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "baseEnergyCostPerTick", "Ljava/util/function/IntSupplier;", "getBaseEnergyCostPerTick", "()Ljava/util/function/IntSupplier;", "maxEnergy", "", "getMaxEnergy", "()I", "energyTransferRate", "getEnergyTransferRate", "container", "Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/aaron/ImprovedSimpleContainer;", "hasRecipe", "", "craftItem", "", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "geneticsresequenced-1.21.1"})
public final class PlasmidInjectorBlockEntity
extends CraftingMachineBlockEntity {
    @NotNull
    private final IntSupplier baseEnergyCostPerTick;
    private final int maxEnergy;
    private final int energyTransferRate;
    @NotNull
    private final ImprovedSimpleContainer container;

    public PlasmidInjectorBlockEntity(@NotNull BlockPos pos, @NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Object object = ModBlockEntityTypes.INSTANCE.getPLASMID_INJECTOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((BlockEntityType)object, pos, blockState);
        this.baseEnergyCostPerTick = PlasmidInjectorBlockEntity::baseEnergyCostPerTick$lambda$0;
        this.maxEnergy = 60000;
        this.energyTransferRate = 256;
        this.container = new ImprovedSimpleContainer(this){

            public boolean canPlaceItem(int slot, ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return switch (slot) {
                    case 0 -> {
                        boolean isIncompletePlasmid;
                        boolean v0 = isIncompletePlasmid = AaronExtensions.INSTANCE.isItem(stack, (Holder)ModItems.INSTANCE.getPLASMID()) && PlasmidItem.Companion.isComplete(stack);
                        if (isIncompletePlasmid || AaronExtensions.INSTANCE.isItem(stack, (Holder)ModItems.INSTANCE.getANTI_PLASMID())) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (SyringeItem.Companion.hasBlood(stack) && !SyringeItem.Companion.isContaminated(stack)) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getOVERCLOCKER().get());
                    default -> false;
                };
            }
        };
    }

    @Override
    @NotNull
    public IntSupplier getBaseEnergyCostPerTick() {
        return this.baseEnergyCostPerTick;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public int getEnergyTransferRate() {
        return this.energyTransferRate;
    }

    @Override
    @NotNull
    public ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    @Override
    protected boolean hasRecipe() {
        ItemStack plasmidStack = this.getItemHandler().getStackInSlot(0);
        ItemStack syringeStack = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNull((Object)syringeStack);
        if (!SyringeItem.Companion.isSyringe(syringeStack)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)plasmidStack);
        if (AaronExtensions.INSTANCE.isItem(plasmidStack, (Holder)ModItems.INSTANCE.getPLASMID())) {
            Holder<Gene> holder = PlasmidItem.Companion.getGene(plasmidStack);
            if (holder == null) {
                return false;
            }
            Holder<Gene> plasmidGene = holder;
            if (!PlasmidItem.Companion.isComplete(plasmidStack)) {
                return false;
            }
            return SyringeItem.Companion.canAddGene(syringeStack, plasmidGene);
        }
        if (AaronExtensions.INSTANCE.isItem(plasmidStack, (Holder)ModItems.INSTANCE.getANTI_PLASMID())) {
            Holder<Gene> holder = PlasmidItem.Companion.getGene(plasmidStack);
            if (holder == null) {
                return false;
            }
            Holder<Gene> antiPlasmidAntigene = holder;
            return SyringeItem.Companion.canAddAntigene(syringeStack, antiPlasmidAntigene);
        }
        return false;
    }

    @Override
    protected void craftItem() {
        ItemStack plasmidStack = this.getItemHandler().getStackInSlot(0);
        ItemStack syringeStack = this.getItemHandler().getStackInSlot(1);
        Intrinsics.checkNotNull((Object)plasmidStack);
        Holder<Gene> holder = PlasmidItem.Companion.getGene(plasmidStack);
        if (holder == null) {
            return;
        }
        Holder<Gene> plasmidGene = holder;
        if (AaronExtensions.INSTANCE.isItem(plasmidStack, (Holder)ModItems.INSTANCE.getPLASMID())) {
            Intrinsics.checkNotNull((Object)syringeStack);
            SyringeItem.Companion.addGene(syringeStack, plasmidGene);
        } else if (AaronExtensions.INSTANCE.isItem(plasmidStack, (Holder)ModItems.INSTANCE.getANTI_PLASMID())) {
            Intrinsics.checkNotNull((Object)syringeStack);
            SyringeItem.Companion.addAntigene(syringeStack, plasmidGene);
        }
        this.getItemHandler().extractItem(0, 1, false);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new PlasmidInjectorMenu(containerId, playerInventory, (Container)this.getContainer(), this.getContainerData());
    }

    private static final int baseEnergyCostPerTick$lambda$0() {
        return 32;
    }
}

