/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.OtherGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.SimplexNoise;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u0016\u0010\b\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tJ\u0016\u0010\n\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/client/renderer/GeneRenderChanges;", "", "<init>", "()V", "shakeFromCringe", "", "event", "Lnet/neoforged/neoforge/client/event/RenderLivingEvent$Pre;", "shakeFromCringePost", "Lnet/neoforged/neoforge/client/event/RenderLivingEvent$Post;", "spiderClimbFlip", "spiderClimbFlipPost", "geneticsresequenced-1.21.1"})
public final class GeneRenderChanges {
    @NotNull
    public static final GeneRenderChanges INSTANCE = new GeneRenderChanges();

    private GeneRenderChanges() {
    }

    public final void shakeFromCringe(@NotNull RenderLivingEvent.Pre<?, ?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.CRINGE)) {
            return;
        }
        Double shakeAmplitude = (Double)ClientConfig.Companion.getCONFIG().getCringeShakeAmplitude().get();
        float shakeSpeed = (float)((Number)ClientConfig.Companion.getCONFIG().getCringeShakeSpeed().get()).doubleValue();
        float time = (float)entity.tickCount + event.getPartialTick();
        float shake = time * shakeSpeed;
        double d = SimplexNoise.noise((float)0.0f, (float)shake);
        Intrinsics.checkNotNull((Object)shakeAmplitude);
        double dx = d * shakeAmplitude;
        double dy = (double)SimplexNoise.noise((float)10.0f, (float)shake) * shakeAmplitude;
        double dz = (double)SimplexNoise.noise((float)20.0f, (float)shake) * shakeAmplitude;
        event.getPoseStack().pushPose();
        event.getPoseStack().translate(dx, dy, dz);
    }

    public final void shakeFromCringePost(@NotNull RenderLivingEvent.Post<?, ?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.CRINGE)) {
            return;
        }
        event.getPoseStack().popPose();
    }

    public final void spiderClimbFlip(@NotNull RenderLivingEvent.Pre<?, ?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (OtherGenes.INSTANCE.shouldClingToCeiling(entity)) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate(0.0, (double)entity.getBbHeight(), 0.0);
            poseStack.scale(1.0f, -1.0f, 1.0f);
        }
    }

    public final void spiderClimbFlipPost(@NotNull RenderLivingEvent.Post<?, ?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (OtherGenes.INSTANCE.shouldClingToCeiling(entity)) {
            event.getPoseStack().popPose();
        }
    }
}

