/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.entity.SupportSlime;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0002J8\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0011H\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/client/renderer/entity/SupportSlimeRenderer;", "Lnet/minecraft/client/renderer/entity/MobRenderer;", "Ldev/aaronhowser/mods/geneticsresequenced/entity/SupportSlime;", "Lnet/minecraft/client/model/SlimeModel;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "headStack", "Lnet/minecraft/world/item/ItemStack;", "getHead", "pEntity", "render", "", "pEntityYaw", "", "pPartialTicks", "pPoseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "pBuffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "pPackedLight", "", "scale", "pLivingEntity", "pMatrixStack", "pPartialTickTime", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSupportSlimeRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupportSlimeRenderer.kt\ndev/aaronhowser/mods/geneticsresequenced/client/renderer/entity/SupportSlimeRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class SupportSlimeRenderer
extends MobRenderer<SupportSlime, SlimeModel<SupportSlime>> {
    @NotNull
    private final ItemRenderer itemRenderer;
    @Nullable
    private ItemStack headStack;

    public SupportSlimeRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, (EntityModel)new SlimeModel(context.bakeLayer(ModelLayers.SLIME)), 0.25f);
        this.addLayer((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, context.getModelSet()));
        ItemRenderer itemRenderer = context.getItemRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
    }

    private final ItemStack getHead(SupportSlime pEntity) {
        Player owner;
        UUID ownerUuid;
        if (this.headStack != null) {
            ItemStack itemStack = this.headStack;
            Intrinsics.checkNotNull((Object)itemStack);
            return itemStack;
        }
        UUID uUID = ownerUuid = pEntity.getOwnerUuid();
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            v2 = pEntity.level().getPlayerByUUID(it);
        } else {
            v2 = owner = null;
        }
        if (owner == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        GameProfile ownerProfile = owner.getGameProfile();
        ResolvableProfile ownerProfileComponent = new ResolvableProfile(ownerProfile);
        Item item = Items.PLAYER_HEAD;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"PLAYER_HEAD");
        ItemStack newHeadStack = OtherUtil.INSTANCE.getItemStack((ItemLike)item);
        newHeadStack.set(DataComponents.PROFILE, (Object)ownerProfileComponent);
        this.headStack = newHeadStack;
        return newHeadStack;
    }

    public void render(@NotNull SupportSlime pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)pEntity), (String)"pEntity");
        Intrinsics.checkNotNullParameter((Object)pPoseStack, (String)"pPoseStack");
        Intrinsics.checkNotNullParameter((Object)pBuffer, (String)"pBuffer");
        if (((Boolean)ClientConfig.Companion.getCONFIG().getSupportSlimeRenderDebug().get()).booleanValue()) {
            super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        }
        pPoseStack.translate(0.0, (double)pEntity.getSize() / (double)4, 0.0);
        pPoseStack.scale((float)pEntity.getSize(), (float)pEntity.getSize(), (float)pEntity.getSize());
        float lerpedRotY = Mth.lerp((float)pPartialTicks, (float)pEntity.yRotO, (float)pEntity.getYRot());
        Vector3f vectorPositiveY = new Vector3f(0.0f, 1.0f, 0.0f);
        float rotationAngleDegrees = lerpedRotY * ((float)Math.PI / 180);
        float thing = (float)Math.sin(rotationAngleDegrees / 2.0f);
        Quaternionf quaternion = new Quaternionf(vectorPositiveY.x * thing, vectorPositiveY.y * thing, vectorPositiveY.z * thing, (float)Math.cos(rotationAngleDegrees / 2.0f));
        pPoseStack.mulPose(quaternion);
        this.itemRenderer.renderStatic(this.getHead(pEntity), ItemDisplayContext.FIXED, pPackedLight, OverlayTexture.NO_OVERLAY, pPoseStack, pBuffer, pEntity.level(), pEntity.getId());
    }

    protected void scale(@NotNull SupportSlime pLivingEntity, @NotNull PoseStack pMatrixStack, float pPartialTickTime) {
        Intrinsics.checkNotNullParameter((Object)((Object)pLivingEntity), (String)"pLivingEntity");
        Intrinsics.checkNotNullParameter((Object)pMatrixStack, (String)"pMatrixStack");
        pMatrixStack.scale(0.999f, 0.999f, 0.999f);
        pMatrixStack.translate(0.0, 0.001, 0.0);
        float sizeFactor = pLivingEntity.getSize();
        float squishFactor = Mth.lerp((float)pPartialTickTime, (float)pLivingEntity.oSquish, (float)pLivingEntity.squish) / (sizeFactor * 0.5f + 1.0f);
        float inverseSquish = 1.0f / (squishFactor + 1.0f);
        pMatrixStack.scale(inverseSquish * sizeFactor, 1.0f / inverseSquish * sizeFactor, inverseSquish * sizeFactor);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SupportSlime pEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)pEntity), (String)"pEntity");
        ResourceLocation resourceLocation = SlimeRenderer.SLIME_LOCATION;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"SLIME_LOCATION");
        return resourceLocation;
    }
}

