/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.command.gene;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.command.ModCommands;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\bJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J,\u0010\u001a\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand;", "", "<init>", "()V", "GENE_ARGUMENT", "", "TARGET_ARGUMENT", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "addGene", "", "source", "geneRl", "Lnet/minecraft/resources/ResourceLocation;", "entities", "", "Lnet/minecraft/world/entity/Entity;", "geneToAdd", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "handleSingleTarget", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "geneHolder", "handleMultipleTargets", "targets", "", "addGeneToTarget", "", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGiveGeneCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GiveGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1617#2,9:172\n1869#2:181\n1870#2:183\n1626#2:184\n1#3:182\n*S KotlinDebug\n*F\n+ 1 GiveGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveGeneCommand\n*L\n73#1:172,9\n73#1:181\n73#1:183\n73#1:184\n73#1:182\n*E\n"})
public final class GiveGeneCommand {
    @NotNull
    public static final GiveGeneCommand INSTANCE = new GiveGeneCommand();
    @NotNull
    private static final String GENE_ARGUMENT = "gene";
    @NotNull
    private static final String TARGET_ARGUMENT = "targets";

    private GiveGeneCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"give-gene").requires(GiveGeneCommand::register$lambda$0)).then(((RequiredArgumentBuilder)Commands.argument((String)GENE_ARGUMENT, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_GENE_RLS()).executes(GiveGeneCommand::register$lambda$1)).then(Commands.argument((String)TARGET_ARGUMENT, (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(GiveGeneCommand::register$lambda$2)));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final int addGene(CommandSourceStack source, ResourceLocation geneRl, Collection<? extends Entity> entities) {
        RegistryAccess registryAccess = source.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> reference = ModGenes.fromResourceLocation((HolderLookup.Provider)registryAccess, geneRl);
        if (reference == null) {
            throw new IllegalArgumentException("Gene with id " + geneRl + " does not exist!");
        }
        Holder.Reference<Gene> gene = reference;
        return this.addGene(source, (Holder<Gene>)((Holder)gene), entities);
    }

    /*
     * WARNING - void declaration
     */
    private final int addGene(CommandSourceStack source, Holder<Gene> geneToAdd, Collection<? extends Entity> entities) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = entities;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LivingEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Entity it = (Entity)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof LivingEntity ? (LivingEntity)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List targets = (List)destination$iv$iv;
        if (targets.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No valid living entity targets found!"));
            return 0;
        }
        if (targets.size() == 1) {
            this.handleSingleTarget(source, (LivingEntity)CollectionsKt.first((List)targets), geneToAdd);
        } else {
            this.handleMultipleTargets(source, targets, geneToAdd);
        }
        return 1;
    }

    private final void handleSingleTarget(CommandSourceStack source, LivingEntity target, Holder<Gene> geneHolder) {
        boolean success = this.addGeneToTarget(target, geneHolder);
        if (success) {
            source.sendSuccess(() -> GiveGeneCommand.handleSingleTarget$lambda$4(geneHolder, target), false);
        } else {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), target.getName()};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.fail", objectArray));
        }
    }

    private final void handleMultipleTargets(CommandSourceStack source, List<? extends LivingEntity> targets, Holder<Gene> geneHolder) {
        Ref.IntRef amountSuccess = new Ref.IntRef();
        int amountFail = 0;
        for (LivingEntity livingEntity : targets) {
            boolean success = this.addGeneToTarget(livingEntity, geneHolder);
            if (success) {
                int n = amountSuccess.element;
                amountSuccess.element = n + 1;
                continue;
            }
            ++amountFail;
        }
        if (amountSuccess.element != 0) {
            source.sendSuccess(() -> GiveGeneCommand.handleMultipleTargets$lambda$5(geneHolder, amountSuccess), false);
        }
        if (amountFail != 0) {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), amountFail};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.fail", objectArray));
        }
    }

    private final boolean addGeneToTarget(LivingEntity target, Holder<Gene> geneHolder) {
        boolean alreadyHasGene = GenesData.Companion.hasGene((Entity)target, geneHolder);
        if (alreadyHasGene) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add gene " + resourceKey.location() + " to " + target.getName().getString() + ", but they already have it!");
            return false;
        }
        if (!((Gene)geneHolder.value()).canEntityHave((Entity)target)) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add gene " + resourceKey.location() + " to " + target.getName().getString() + ", but they can't have it!");
            return false;
        }
        boolean success = GenesData.Companion.addGene(target, geneHolder);
        return success;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext cmd) {
        Object object = cmd.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        return INSTANCE.addGene(commandSourceStack, resourceLocation, (Collection<? extends Entity>)CollectionsKt.listOf((Object)((CommandSourceStack)cmd.getSource()).getPlayerOrException()));
    }

    private static final int register$lambda$2(CommandContext cmd) {
        Object object = cmd.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        ResourceLocation resourceLocation = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getId(...)");
        Collection collection = EntityArgument.getEntities((CommandContext)cmd, (String)TARGET_ARGUMENT);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntities(...)");
        return INSTANCE.addGene(commandSourceStack, resourceLocation, (Collection<? extends Entity>)collection);
    }

    private static final Component handleSingleTarget$lambda$4(Holder $geneHolder, LivingEntity $target) {
        Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)$geneHolder), $target.getName()};
        return (Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.single_target.success", objectArray);
    }

    private static final Component handleMultipleTargets$lambda$5(Holder $geneHolder, Ref.IntRef $amountSuccess) {
        Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)$geneHolder), $amountSuccess.element};
        return (Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.add_gene.multiple_targets.success", objectArray);
    }
}

