/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.command.gene;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.attachment.TemporaryGenesData;
import dev.aaronhowser.mods.geneticsresequenced.command.ModCommands;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0002J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\fH\u0002J4\u0010\u001b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\fH\u0002J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/command/gene/GiveTemporaryGeneCommand;", "", "<init>", "()V", "GENE", "", "TARGETS", "DURATION", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "addGene", "", "source", "geneRl", "Lnet/minecraft/resources/ResourceLocation;", "entities", "", "Lnet/minecraft/world/entity/Entity;", "duration", "handleSingleTarget", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "handleMultipleTargets", "targets", "", "addGeneToTarget", "", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGiveTemporaryGeneCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GiveTemporaryGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveTemporaryGeneCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1617#2,9:183\n1869#2:192\n1870#2:194\n1626#2:195\n1#3:193\n*S KotlinDebug\n*F\n+ 1 GiveTemporaryGeneCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/GiveTemporaryGeneCommand\n*L\n76#1:183,9\n76#1:192\n76#1:194\n76#1:195\n76#1:193\n*E\n"})
public final class GiveTemporaryGeneCommand {
    @NotNull
    public static final GiveTemporaryGeneCommand INSTANCE = new GiveTemporaryGeneCommand();
    @NotNull
    private static final String GENE = "gene";
    @NotNull
    private static final String TARGETS = "targets";
    @NotNull
    private static final String DURATION = "duration";

    private GiveTemporaryGeneCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)Commands.literal((String)"give-temporary-gene").requires(GiveTemporaryGeneCommand::register$lambda$0)).then(((RequiredArgumentBuilder)Commands.argument((String)GENE, (ArgumentType)((ArgumentType)ResourceLocationArgument.id())).suggests(ModCommands.INSTANCE.getSUGGEST_GENE_RLS()).executes(GiveTemporaryGeneCommand::register$lambda$1)).then(((RequiredArgumentBuilder)Commands.argument((String)DURATION, (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(GiveTemporaryGeneCommand::register$lambda$2)).then(Commands.argument((String)TARGETS, (ArgumentType)((ArgumentType)EntityArgument.entities())).executes(GiveTemporaryGeneCommand::register$lambda$3))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private final int addGene(CommandSourceStack source, ResourceLocation geneRl, Collection<? extends Entity> entities, int duration) {
        void $this$mapNotNullTo$iv$iv;
        RegistryAccess registryAccess = source.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Holder.Reference<Gene> reference = ModGenes.fromResourceLocation((HolderLookup.Provider)registryAccess, geneRl);
        if (reference == null) {
            throw new IllegalArgumentException("Gene with id " + geneRl + " does not exist!");
        }
        Holder.Reference<Gene> geneHolder = reference;
        Iterable $this$mapNotNull$iv = entities;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LivingEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Entity it = (Entity)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof LivingEntity ? (LivingEntity)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List targets = (List)destination$iv$iv;
        if (targets.isEmpty()) {
            source.sendFailure((Component)Component.literal((String)"No valid living entity targets found!"));
            return 0;
        }
        if (targets.size() == 1) {
            this.handleSingleTarget(source, (LivingEntity)CollectionsKt.first((List)targets), (Holder<Gene>)((Holder)geneHolder), duration);
        } else {
            this.handleMultipleTargets(source, targets, (Holder<Gene>)((Holder)geneHolder), duration);
        }
        return 1;
    }

    private final void handleSingleTarget(CommandSourceStack source, LivingEntity target, Holder<Gene> geneHolder, int duration) {
        boolean success = this.addGeneToTarget(target, geneHolder, duration);
        if (success) {
            source.sendSuccess(() -> GiveTemporaryGeneCommand.handleSingleTarget$lambda$5(geneHolder, target, duration), false);
        } else {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), target.getName(), duration};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.temporary_add_gene.single_target.fail", objectArray));
        }
    }

    private final void handleMultipleTargets(CommandSourceStack source, List<? extends LivingEntity> targets, Holder<Gene> geneHolder, int duration) {
        Ref.IntRef amountSuccess = new Ref.IntRef();
        int amountFail = 0;
        for (LivingEntity livingEntity : targets) {
            boolean success = this.addGeneToTarget(livingEntity, geneHolder, duration);
            if (success) {
                int n = amountSuccess.element;
                amountSuccess.element = n + 1;
                continue;
            }
            ++amountFail;
        }
        if (amountSuccess.element != 0) {
            source.sendSuccess(() -> GiveTemporaryGeneCommand.handleMultipleTargets$lambda$6(geneHolder, amountSuccess, duration), false);
        }
        if (amountFail != 0) {
            Object[] objectArray = new Object[]{Gene.Companion.getName(geneHolder), amountFail, duration};
            source.sendFailure((Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.temporary_add_gene.multiple_targets.fail", objectArray));
        }
    }

    private final boolean addGeneToTarget(LivingEntity target, Holder<Gene> geneHolder, int duration) {
        boolean alreadyHasGene = GenesData.Companion.hasPermanentGene((Entity)target, geneHolder);
        if (alreadyHasGene) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add temporary gene " + resourceKey.location() + " to " + target.getName().getString() + ", but they already have it as a permanent Gene!");
            return false;
        }
        if (!((Gene)geneHolder.value()).canEntityHave((Entity)target)) {
            Logger logger = GeneticsResequenced.Companion.getLOGGER();
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            logger.info("Tried to add temporary gene " + resourceKey.location() + " to " + target.getName().getString() + ", but that entity type cannot have that gene!");
            return false;
        }
        boolean success = TemporaryGenesData.Companion.addTemporaryGene(target, geneHolder, duration);
        return success;
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext cmd) {
        ResourceLocation gene = ResourceLocationArgument.getId((CommandContext)cmd, (String)GENE);
        int duration = 6000;
        List targets = CollectionsKt.listOf((Object)((CommandSourceStack)cmd.getSource()).getPlayerOrException());
        Object object = cmd.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)gene);
        return INSTANCE.addGene(commandSourceStack, gene, targets, duration);
    }

    private static final int register$lambda$2(CommandContext it) {
        ResourceLocation gene = ResourceLocationArgument.getId((CommandContext)it, (String)GENE);
        int duration = IntegerArgumentType.getInteger((CommandContext)it, (String)DURATION);
        List targets = CollectionsKt.listOf((Object)((CommandSourceStack)it.getSource()).getPlayerOrException());
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)gene);
        return INSTANCE.addGene(commandSourceStack, gene, targets, duration);
    }

    private static final int register$lambda$3(CommandContext it) {
        ResourceLocation gene = ResourceLocationArgument.getId((CommandContext)it, (String)GENE);
        int duration = IntegerArgumentType.getInteger((CommandContext)it, (String)DURATION);
        Collection targets = EntityArgument.getEntities((CommandContext)it, (String)TARGETS);
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)gene);
        Intrinsics.checkNotNull((Object)targets);
        return INSTANCE.addGene(commandSourceStack, gene, targets, duration);
    }

    private static final Component handleSingleTarget$lambda$5(Holder $geneHolder, LivingEntity $target, int $duration) {
        Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)$geneHolder), $target.getName(), $duration};
        return (Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.temporary_add_gene.single_target.success", objectArray);
    }

    private static final Component handleMultipleTargets$lambda$6(Holder $geneHolder, Ref.IntRef $amountSuccess, int $duration) {
        Object[] objectArray = new Object[]{Gene.Companion.getName((Holder<Gene>)$geneHolder), $amountSuccess.element, $duration};
        return (Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.temporary_add_gene.multiple_targets.success", objectArray);
    }
}

