/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.command.gene;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.attachment.TemporaryGenesData;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/command/gene/ListGenesCommand;", "", "<init>", "()V", "TARGET_ARGUMENT", "", "register", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lnet/minecraft/commands/CommandSourceStack;", "listGenes", "", "source", "target", "Lnet/minecraft/world/entity/Entity;", "listPermanentGenes", "", "Lnet/minecraft/world/entity/LivingEntity;", "listTemporaryGenes", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nListGenesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListGenesCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/ListGenesCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1563#2:109\n1634#2,3:110\n1563#2:113\n1634#2,3:114\n*S KotlinDebug\n*F\n+ 1 ListGenesCommand.kt\ndev/aaronhowser/mods/geneticsresequenced/command/gene/ListGenesCommand\n*L\n76#1:109\n76#1:110,3\n100#1:113\n100#1:114,3\n*E\n"})
public final class ListGenesCommand {
    @NotNull
    public static final ListGenesCommand INSTANCE = new ListGenesCommand();
    @NotNull
    private static final String TARGET_ARGUMENT = "target";

    private ListGenesCommand() {
    }

    @NotNull
    public final ArgumentBuilder<CommandSourceStack, ?> register() {
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list-genes").requires(ListGenesCommand::register$lambda$0)).executes(ListGenesCommand::register$lambda$1)).then(Commands.argument((String)TARGET_ARGUMENT, (ArgumentType)((ArgumentType)EntityArgument.entity())).executes(ListGenesCommand::register$lambda$2));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        return argumentBuilder;
    }

    private final int listGenes(CommandSourceStack source, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return 0;
        }
        this.listPermanentGenes(source, (LivingEntity)target);
        this.listTemporaryGenes(source, (LivingEntity)target);
        return 1;
    }

    private final void listPermanentGenes(CommandSourceStack source, LivingEntity target) {
        Set<Holder<Gene>> targetGenesList = GenesData.Companion.getPermanentGeneHolders(target);
        if (targetGenesList.isEmpty()) {
            source.sendSuccess(ListGenesCommand::listPermanentGenes$lambda$3, false);
            return;
        }
        source.sendSuccess(() -> ListGenesCommand.listPermanentGenes$lambda$4(target, targetGenesList), false);
    }

    private final void listTemporaryGenes(CommandSourceStack source, LivingEntity target) {
        List<TemporaryGenesData.TemporaryGene> tempGenes = TemporaryGenesData.Companion.getTemporaryGenes(target);
        if (tempGenes.isEmpty()) {
            return;
        }
        source.sendSuccess(() -> ListGenesCommand.listTemporaryGenes$lambda$6(target, tempGenes), false);
    }

    private static final boolean register$lambda$0(CommandSourceStack it) {
        return it.hasPermission(2);
    }

    private static final int register$lambda$1(CommandContext it) {
        Entity target = ((CommandSourceStack)it.getSource()).getEntityOrException();
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)target);
        return INSTANCE.listGenes(commandSourceStack, target);
    }

    private static final int register$lambda$2(CommandContext it) {
        Entity target = EntityArgument.getEntity((CommandContext)it, (String)TARGET_ARGUMENT);
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        CommandSourceStack commandSourceStack = (CommandSourceStack)object;
        Intrinsics.checkNotNull((Object)target);
        return INSTANCE.listGenes(commandSourceStack, target);
    }

    private static final Component listPermanentGenes$lambda$3() {
        return (Component)ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.list.no_genes", new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final Component listPermanentGenes$lambda$4(LivingEntity $target, Set $targetGenesList) {
        Collection<MutableComponent> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Object[]{$target.getDisplayName()};
        MutableComponent messageComponent = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.list.genes", object);
        object = $targetGenesList;
        Gene.Companion companion = Gene.Companion;
        OtherUtil otherUtil = OtherUtil.INSTANCE;
        MutableComponent mutableComponent = messageComponent;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Holder holder = (Holder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.getNameComponent((Holder<Gene>)p0));
        }
        collection = (List)destination$iv$iv;
        return (Component)mutableComponent.append((Component)otherUtil.componentList((List<? extends Component>)collection));
    }

    /*
     * WARNING - void declaration
     */
    private static final Component listTemporaryGenes$lambda$6(LivingEntity $target, List $tempGenes) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new Object[]{$target.getDisplayName()};
        MutableComponent messageComponent = ModLanguageProvider.Companion.toComponent("command.geneticsresequenced.list.temporary_genes", objectArray);
        Iterable $this$map$iv = $tempGenes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TemporaryGenesData.TemporaryGene temporaryGene = (TemporaryGenesData.TemporaryGene)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getComponent());
        }
        List componentList = (List)destination$iv$iv;
        return (Component)messageComponent.append((Component)OtherUtil.INSTANCE.componentList(componentList));
    }
}

