/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.data.EntityGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/DecryptHelixEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "chance", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/core/Holder;F)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getGeneHolder", "()Lnet/minecraft/core/Holder;", "getChance", "()F", "encryptedHelix", "Ldev/emi/emi/api/stack/EmiIngredient;", "decryptedHelix", "Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "getInputs", "", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "Companion", "geneticsresequenced-1.21.1"})
public final class DecryptHelixEmiRecipe
implements EmiRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final Holder<Gene> geneHolder;
    private final float chance;
    @NotNull
    private final EmiIngredient encryptedHelix;
    @NotNull
    private final EmiStack decryptedHelix;

    public DecryptHelixEmiRecipe(@NotNull EntityType<?> entityType, @NotNull Holder<Gene> geneHolder, float chance) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        this.entityType = entityType;
        this.geneHolder = geneHolder;
        this.chance = chance;
        ItemStack helixStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNull((Object)helixStack);
        EntityDnaItem.Companion.setEntityType(helixStack, this.entityType);
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)DataComponentIngredient.of((boolean)true, (ItemStack)helixStack));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.encryptedHelix = emiIngredient;
        ItemStack decryptedHelixStack = DnaHelixItem.Companion.getHelixStack(this.geneHolder);
        EmiStack emiStack = EmiStack.of((ItemStack)decryptedHelixStack);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.decryptedHelix = emiStack;
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final Holder<Gene> getGeneHolder() {
        return this.geneHolder;
    }

    public final float getChance() {
        return this.chance;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getDNA_DECRYPTOR_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        ResourceLocation entityTypeRl = resourceLocation;
        String string = entityTypeRl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String entityString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        ResourceKey resourceKey = this.geneHolder.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        String string2 = resourceKey.location().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        return OtherUtil.INSTANCE.modResource("/dna_extractor/" + entityString + "/to/" + geneString);
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        return CollectionsKt.listOf((Object)this.encryptedHelix);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        return CollectionsKt.listOf((Object)this.decryptedHelix);
    }

    public int getDisplayWidth() {
        return 76;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        String string = "%.2f%%";
        Object[] objectArray = new Object[]{Float.valueOf(this.chance * (float)100)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        widgets.addText((Component)Component.literal((String)string2), -40, 4, 0x3E3E3E, false);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 26, 1);
        widgets.addSlot(this.encryptedHelix, 0, 0);
        widgets.addSlot((EmiIngredient)this.decryptedHelix, 58, 0).recipeContext((EmiRecipe)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/DecryptHelixEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/DecryptHelixEmiRecipe;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nDecryptHelixEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptHelixEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/DecryptHelixEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1669#2,8:102\n*S KotlinDebug\n*F\n+ 1 DecryptHelixEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/DecryptHelixEmiRecipe$Companion\n*L\n44#1:102,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DecryptHelixEmiRecipe> getAllRecipes() {
            List recipes = new ArrayList();
            RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
            Intrinsics.checkNotNull((Object)registryAccess);
            for (Map.Entry<EntityType<?>, Map<Holder<Gene>, Integer>> entry2 : EntityGenes.Companion.getEntityGeneHolderMap((HolderLookup.Provider)registryAccess).entrySet()) {
                EntityType<?> entityType = entry2.getKey();
                Map<Holder<Gene>, Integer> map = entry2.getValue();
                int totalWeight = CollectionsKt.sumOfInt((Iterable)map.values());
                for (Map.Entry<Holder<Gene>, Integer> entry3 : map.entrySet()) {
                    Holder<Gene> geneHolder = entry3.getKey();
                    int weight = ((Number)entry3.getValue()).intValue();
                    float chance = (float)weight / (float)totalWeight;
                    recipes.add(new DecryptHelixEmiRecipe(entityType, geneHolder, chance));
                }
            }
            Iterable $this$distinctBy$iv = recipes;
            boolean $i$f$distinctBy = false;
            HashSet<ResourceLocation> set$iv = new HashSet<ResourceLocation>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                DecryptHelixEmiRecipe it = (DecryptHelixEmiRecipe)e$iv;
                boolean bl = false;
                ResourceLocation key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            return list$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

