/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine.incubator;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine.incubator.AbstractEmiIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.item.GmoCell;
import dev.aaronhowser.mods.geneticsresequenced.recipe.BrewingRecipes;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/CellDupeEmiRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/AbstractEmiIncubatorRecipe;", "cellStack", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Lnet/minecraft/world/item/ItemStack;)V", "getCellStack", "()Lnet/minecraft/world/item/ItemStack;", "ingredient", "Ldev/emi/emi/api/stack/EmiIngredient;", "getIngredient", "()Ldev/emi/emi/api/stack/EmiIngredient;", "input", "getInput", "output", "Ldev/emi/emi/api/stack/EmiStack;", "getOutput", "()Ldev/emi/emi/api/stack/EmiStack;", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "getTooltips", "()Ljava/util/List;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "Companion", "geneticsresequenced-1.21.1"})
public final class CellDupeEmiRecipe
extends AbstractEmiIncubatorRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack cellStack;
    @NotNull
    private final EmiIngredient ingredient;
    @NotNull
    private final EmiIngredient input;
    @NotNull
    private final EmiStack output;
    @NotNull
    private final List<Component> tooltips;

    public CellDupeEmiRecipe(@NotNull ItemStack cellStack) {
        Intrinsics.checkNotNullParameter((Object)cellStack, (String)"cellStack");
        this.cellStack = cellStack;
        ItemStack[] itemStackArray = new ItemStack[]{this.cellStack};
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.ingredient = emiIngredient;
        itemStackArray = new ItemStack[]{BrewingRecipes.INSTANCE.getSubstratePotionStack()};
        EmiIngredient emiIngredient2 = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient2, (String)"of(...)");
        this.input = emiIngredient2;
        EmiStack emiStack = EmiStack.of((ItemStack)this.cellStack.copy());
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.output = emiStack;
        this.tooltips = CollectionsKt.listOf((Object)ModLanguageProvider.Companion.toComponent("recipe.geneticsresequenced.substrate", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public final ItemStack getCellStack() {
        return this.cellStack;
    }

    @Override
    @NotNull
    public EmiIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    @NotNull
    public EmiIngredient getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public EmiStack getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getCELL_DUPE_CATEGORY();
    }

    @Override
    @NotNull
    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @NotNull
    public ResourceLocation getId() {
        Object string = "/substrate_dupe/";
        EntityType<?> entityType = EntityDnaItem.Companion.getEntityType(this.cellStack);
        if (entityType == null) {
            throw new IllegalStateException("Cell stack has no entity type!".toString());
        }
        EntityType<?> entityType2 = entityType;
        String string2 = EntityType.getKey(entityType2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String entityTypeString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        string = (String)string + entityTypeString;
        if (Intrinsics.areEqual((Object)this.cellStack.getItem(), (Object)ModItems.INSTANCE.getGMO_CELL().get())) {
            Holder<Gene> holder = DnaHelixItem.Companion.getGeneHolder(this.cellStack);
            if (holder == null) {
                throw new IllegalStateException("GMO Cell stack has no gene!".toString());
            }
            Holder<Gene> geneHolder = holder;
            ResourceKey resourceKey = geneHolder.getKey();
            Intrinsics.checkNotNull((Object)resourceKey);
            String string3 = resourceKey.location().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String geneString = StringsKt.replace$default((String)string3, (char)':', (char)'/', (boolean)false, (int)4, null);
            string = (String)string + "/" + geneString;
        }
        return OtherUtil.INSTANCE.modResource((String)string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/CellDupeEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/CellDupeEmiRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<CellDupeEmiRecipe> getAllRecipes(@NotNull RecipeManager recipeManager) {
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List recipes = new ArrayList();
            Set<EntityType<?>> allEntityTypes = EntityDnaItem.VALID_ENTITY_TYPES;
            for (EntityType<?> entityType : allEntityTypes) {
                ItemStack cellStack = ModItems.INSTANCE.getCELL().toStack();
                Intrinsics.checkNotNull((Object)cellStack);
                EntityDnaItem.Companion.setEntityType(cellStack, entityType);
                recipes.add(new CellDupeEmiRecipe(cellStack));
            }
            List<RecipeHolder<GmoRecipe>> allGmoRecipes = GmoRecipe.Companion.getGmoRecipes(recipeManager);
            for (RecipeHolder<GmoRecipe> recipe : allGmoRecipes) {
                EntityType<?> entityType = ((GmoRecipe)recipe.value()).getEntityType();
                ResourceKey<Gene> goodGene = ((GmoRecipe)recipe.value()).getIdealGeneRk();
                ItemStack gmoCellStack = ModItems.INSTANCE.getGMO_CELL().toStack();
                Intrinsics.checkNotNull((Object)gmoCellStack);
                RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
                Intrinsics.checkNotNull((Object)registryAccess);
                GmoCell.Companion.setDetails(gmoCellStack, entityType, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(goodGene, (HolderLookup.Provider)registryAccess)));
                recipes.add(new CellDupeEmiRecipe(gmoCellStack));
            }
            return recipes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

