/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.recipe.machine.incubator;

import dev.aaronhowser.mods.geneticsresequenced.compatibility.recipe.emi.ModEmiPlugin;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0001*B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\u001dH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/GmoEmiRecipe;", "Ldev/emi/emi/api/recipe/EmiRecipe;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "idealResourceKey", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "geneChance", "", "isMutation", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/resources/ResourceKey;FZ)V", "getEntityType", "()Lnet/minecraft/world/entity/EntityType;", "getIdealResourceKey", "()Lnet/minecraft/resources/ResourceKey;", "getGeneChance", "()F", "Ldev/emi/emi/api/stack/EmiIngredient;", "input", "goodOutput", "Ldev/emi/emi/api/stack/EmiStack;", "badOutput", "getCategory", "Ldev/emi/emi/api/recipe/EmiRecipeCategory;", "tooltips", "", "Lnet/minecraft/network/chat/Component;", "getId", "Lnet/minecraft/resources/ResourceLocation;", "addWidgets", "", "widgets", "Ldev/emi/emi/api/widget/WidgetHolder;", "getInputs", "getOutputs", "getDisplayWidth", "", "getDisplayHeight", "Companion", "geneticsresequenced-1.21.1"})
public final class GmoEmiRecipe
implements EmiRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityType<?> entityType;
    @NotNull
    private final ResourceKey<Gene> idealResourceKey;
    private final float geneChance;
    @NotNull
    private final EmiIngredient ingredient;
    @NotNull
    private final EmiIngredient input;
    @NotNull
    private final EmiStack goodOutput;
    @NotNull
    private final EmiStack badOutput;
    @NotNull
    private final List<Component> tooltips;

    public GmoEmiRecipe(@NotNull EntityType<?> entityType, @NotNull Ingredient ingredient, @NotNull ResourceKey<Gene> idealResourceKey, float geneChance, boolean isMutation) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        Intrinsics.checkNotNullParameter(idealResourceKey, (String)"idealResourceKey");
        this.entityType = entityType;
        this.idealResourceKey = idealResourceKey;
        this.geneChance = geneChance;
        EmiIngredient emiIngredient = EmiIngredient.of((Ingredient)ingredient);
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient, (String)"of(...)");
        this.ingredient = emiIngredient;
        DeferredHolder<Potion, Potion> requiredPotion = isMutation ? ModPotions.INSTANCE.getMUTATION() : ModPotions.INSTANCE.getCELL_GROWTH();
        ItemStack potionStack = OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)requiredPotion));
        EntityDnaItem.Companion.setEntityType(potionStack, this.entityType);
        ItemStack[] itemStackArray = new ItemStack[]{potionStack};
        EmiIngredient emiIngredient2 = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])itemStackArray));
        Intrinsics.checkNotNullExpressionValue((Object)emiIngredient2, (String)"of(...)");
        this.input = emiIngredient2;
        ItemStack gmoStack = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)gmoStack);
        EntityDnaItem.Companion.setEntityType(gmoStack, this.entityType);
        RegistryAccess registryAccess = ClientUtil.INSTANCE.getLocalRegistryAccess();
        Intrinsics.checkNotNull((Object)registryAccess);
        DnaHelixItem.Companion.setGeneHolder(gmoStack, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(this.idealResourceKey, (HolderLookup.Provider)registryAccess)));
        EmiStack emiStack = EmiStack.of((ItemStack)gmoStack);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack, (String)"of(...)");
        this.goodOutput = emiStack;
        ItemStack failCell = ModItems.INSTANCE.getGMO_CELL().toStack();
        Intrinsics.checkNotNull((Object)failCell);
        EntityDnaItem.Companion.setEntityType(failCell, this.entityType);
        ResourceKey<Gene> resourceKey = ModGenes.INSTANCE.getBASIC();
        RegistryAccess registryAccess2 = ClientUtil.INSTANCE.getLocalRegistryAccess();
        Intrinsics.checkNotNull((Object)registryAccess2);
        DnaHelixItem.Companion.setGeneHolder(failCell, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(resourceKey, (HolderLookup.Provider)registryAccess2)));
        EmiStack emiStack2 = EmiStack.of((ItemStack)failCell);
        Intrinsics.checkNotNullExpressionValue((Object)emiStack2, (String)"of(...)");
        this.badOutput = emiStack2;
        Object[] objectArray = new Component[]{ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_temperature_requirement", new Object[0]).withStyle(ChatFormatting.GRAY), CommonComponents.EMPTY, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.line3", new Object[0]).withStyle(ChatFormatting.GRAY)};
        this.tooltips = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final EntityType<?> getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final ResourceKey<Gene> getIdealResourceKey() {
        return this.idealResourceKey;
    }

    public final float getGeneChance() {
        return this.geneChance;
    }

    @NotNull
    public EmiRecipeCategory getCategory() {
        return ModEmiPlugin.Companion.getGMO_CATEGORY();
    }

    @NotNull
    public ResourceLocation getId() {
        String string = EntityType.getKey(this.entityType).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String entityTypeString = StringsKt.replace$default((String)string, (char)':', (char)'/', (boolean)false, (int)4, null);
        String string2 = this.idealResourceKey.location().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String geneString = StringsKt.replace$default((String)string2, (char)':', (char)'/', (boolean)false, (int)4, null);
        return OtherUtil.INSTANCE.modResource("/gmo/" + entityTypeString + "/" + geneString);
    }

    public void addWidgets(@NotNull WidgetHolder widgets) {
        Intrinsics.checkNotNullParameter((Object)widgets, (String)"widgets");
        int buffer = 5;
        int slotSize = 18;
        int x = 0;
        widgets.addSlot(this.input, x += 5, this.getDisplayHeight() / 4);
        widgets.addSlot(this.ingredient, x += slotSize + buffer, this.getDisplayHeight() / 4);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, x += slotSize + buffer / 2, this.getDisplayHeight() / 3 - 4);
        widgets.addSlot((EmiIngredient)this.goodOutput, x += EmiTexture.EMPTY_ARROW.width + buffer / 2, 2).recipeContext((EmiRecipe)this).appendTooltip((Component)ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.success", new Object[0]).withStyle(ChatFormatting.GREEN));
        widgets.addSlot((EmiIngredient)this.badOutput, x, 22).recipeContext((EmiRecipe)this).appendTooltip((Component)ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo_recipe.failure", new Object[0]).withStyle(ChatFormatting.RED));
        int successChance = (int)(this.geneChance * (float)100);
        widgets.addText((Component)Component.literal((String)("Success: " + successChance + "%")).withStyle(ChatFormatting.GREEN), x += slotSize + buffer, 6, 0, true);
        int failureChance = 100 - successChance;
        widgets.addText((Component)Component.literal((String)("Failure: " + failureChance + "%")).withStyle(ChatFormatting.RED), x, 26, 0, true);
        widgets.addTooltipText(this.tooltips, 0, 0, this.getDisplayWidth(), this.getDisplayHeight());
    }

    @NotNull
    public List<EmiIngredient> getInputs() {
        Object[] objectArray = new EmiIngredient[]{this.input, this.ingredient};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<EmiStack> getOutputs() {
        Object[] objectArray = new EmiStack[]{this.goodOutput, this.badOutput};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public int getDisplayWidth() {
        int leftSide = 48;
        int rightSide = 46;
        int textWidth = 50;
        return leftSide + EmiTexture.EMPTY_ARROW.width + rightSide + textWidth;
    }

    public int getDisplayHeight() {
        return 42;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/GmoEmiRecipe$Companion;", "", "<init>", "()V", "getAllRecipes", "", "Ldev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/GmoEmiRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nGmoEmiRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GmoEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/GmoEmiRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1563#2:179\n1634#2,3:180\n*S KotlinDebug\n*F\n+ 1 GmoEmiRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/compatibility/recipe/emi/recipe/machine/incubator/GmoEmiRecipe$Companion\n*L\n43#1:179\n43#1:180,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<GmoEmiRecipe> getAllRecipes(@NotNull RecipeManager recipeManager) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List<RecipeHolder<GmoRecipe>> allRegularGmoRecipes = GmoRecipe.Companion.getGmoRecipes(recipeManager);
            Iterable $this$map$iv = allRegularGmoRecipes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RecipeHolder recipeHolder = (RecipeHolder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new GmoEmiRecipe(((GmoRecipe)it.value()).getEntityType(), ((GmoRecipe)it.value()).getTopIngredient(), ((GmoRecipe)it.value()).getIdealGeneRk(), ((GmoRecipe)it.value()).getGeneChance(), ((GmoRecipe)it.value()).getNeedsMutationPotion()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

