/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.model;

import dev.aaronhowser.mods.geneticsresequenced.block.AntiFieldBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.BioluminescenceBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.CoalGeneratorBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.WebDefenseBlock;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J(\u0010\r\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/model/ModBlockStateProvider;", "Lnet/neoforged/neoforge/client/model/generators/BlockStateProvider;", "output", "Lnet/minecraft/data/PackOutput;", "existingFileHelper", "Lnet/neoforged/neoforge/common/data/ExistingFileHelper;", "<init>", "(Lnet/minecraft/data/PackOutput;Lnet/neoforged/neoforge/common/data/ExistingFileHelper;)V", "registerStatesAndModels", "", "antiFieldBlock", "webDefense", "bioluminescence", "frontFacingBlock", "deferredBlock", "Lnet/neoforged/neoforge/registries/DeferredBlock;", "Lnet/minecraft/world/level/block/Block;", "name", "", "frontTexture", "coalGenerator", "geneticsresequenced-1.21.1"})
public final class ModBlockStateProvider
extends BlockStateProvider {
    @NotNull
    private final ExistingFileHelper existingFileHelper;

    public ModBlockStateProvider(@NotNull PackOutput output, @NotNull ExistingFileHelper existingFileHelper) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)existingFileHelper, (String)"existingFileHelper");
        super(output, "geneticsresequenced", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        this.antiFieldBlock();
        this.bioluminescence();
        this.webDefense();
        this.coalGenerator();
        this.frontFacingBlock(ModBlocks.INSTANCE.getCELL_ANALYZER(), "cell_analyzer", "block/cell_analyzer_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getDNA_EXTRACTOR(), "dna_extractor", "block/dna_extractor_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getDNA_DECRYPTOR(), "dna_decryptor", "block/dna_decryptor_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getBLOOD_PURIFIER(), "blood_purifier", "block/blood_purifier_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getPLASMID_INFUSER(), "plasmid_infuser", "block/plasmid_infuser_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getPLASMID_INJECTOR(), "plasmid_injector", "block/plasmid_injector_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getINCUBATOR(), "incubator", "block/incubator_front");
        this.frontFacingBlock(ModBlocks.INSTANCE.getADVANCED_INCUBATOR(), "advanced_incubator", "block/incubator_front");
    }

    private final void antiFieldBlock() {
        DeferredBlock<AntiFieldBlock> deferredAntiFieldBlock = ModBlocks.INSTANCE.getANTI_FIELD_BLOCK();
        this.getVariantBuilder((Block)deferredAntiFieldBlock.get()).forAllStates(arg_0 -> ModBlockStateProvider.antiFieldBlock$lambda$0(this, arg_0));
        this.simpleBlockItem((Block)deferredAntiFieldBlock.get(), (ModelFile)new ItemModelBuilder(this.modLoc("block/anti_field_block_enabled"), this.existingFileHelper));
    }

    private final void webDefense() {
        DeferredBlock<WebDefenseBlock> block = ModBlocks.INSTANCE.getWEB_DEFENSE_BLOCK();
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("web_defense_block", this.mcLoc("block/cobweb"))).renderType(RenderType.cutout().name);
        this.simpleBlock((Block)block.get(), (ModelFile)model);
    }

    private final void bioluminescence() {
        DeferredBlock<BioluminescenceBlock> deferredBioluminescence = ModBlocks.INSTANCE.getBIOLUMINESCENCE_BLOCK();
        this.getVariantBuilder((Block)deferredBioluminescence.get()).forAllStates(arg_0 -> ModBlockStateProvider.bioluminescence$lambda$1(this, deferredBioluminescence, arg_0));
        int lightLevel = 10;
        this.simpleBlockItem((Block)deferredBioluminescence.get(), (ModelFile)new ItemModelBuilder(this.mcLoc("item/light_" + lightLevel), this.existingFileHelper));
    }

    private final void frontFacingBlock(DeferredBlock<? extends Block> deferredBlock, String name, String frontTexture) {
        String top = "block/machine_top";
        String bottom = "block/machine_bottom";
        String side = "block/machine_side";
        this.getVariantBuilder((Block)deferredBlock.get()).forAllStates(arg_0 -> ModBlockStateProvider.frontFacingBlock$lambda$2(this, name, bottom, top, frontTexture, side, arg_0));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ItemModelBuilder(this.modLoc("block/" + name), this.existingFileHelper));
    }

    private final void coalGenerator() {
        DeferredBlock<CoalGeneratorBlock> deferredBlock = ModBlocks.INSTANCE.getCOAL_GENERATOR();
        String top = "block/machine_top";
        String bottom = "block/machine_bottom";
        String side = "block/machine_side";
        this.getVariantBuilder((Block)deferredBlock.get()).forAllStates(arg_0 -> ModBlockStateProvider.coalGenerator$lambda$3(this, bottom, top, side, arg_0));
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ItemModelBuilder(this.modLoc("block/coal_generator_off"), this.existingFileHelper));
    }

    private static final ConfiguredModel[] antiFieldBlock$lambda$0(ModBlockStateProvider this$0, BlockState state) {
        Boolean disabled = (Boolean)state.getValue((Property)AntiFieldBlock.Companion.getDISABLED());
        String modelVariantName = disabled != false ? "anti_field_block_disabled" : "anti_field_block_enabled";
        String textureVariantName = disabled != false ? "block/machine_bottom" : "block/machine_top";
        return ConfiguredModel.builder().modelFile((ModelFile)this$0.models().cubeAll(modelVariantName, this$0.modLoc(textureVariantName))).build();
    }

    private static final ConfiguredModel[] bioluminescence$lambda$1(ModBlockStateProvider this$0, DeferredBlock $deferredBioluminescence, BlockState it) {
        return ConfiguredModel.builder().modelFile((ModelFile)this$0.models().withExistingParent($deferredBioluminescence.getId().getPath(), this$0.mcLoc("block/air"))).build();
    }

    private static final ConfiguredModel[] frontFacingBlock$lambda$2(ModBlockStateProvider this$0, String $name, String $bottom, String $top, String $frontTexture, String $side, BlockState state) {
        Direction facing;
        Direction direction = facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        int yRotation = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> 0;
            case 2 -> 90;
            case 3 -> 180;
            case 4 -> 270;
            default -> throw new IllegalStateException("Invalid facing direction");
        };
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this$0.models().cube($name, this$0.modLoc($bottom), this$0.modLoc($top), this$0.modLoc($frontTexture), this$0.modLoc($side), this$0.modLoc($side), this$0.modLoc($side))).texture("particle", this$0.modLoc($top))).rotationY(yRotation).build();
    }

    private static final ConfiguredModel[] coalGenerator$lambda$3(ModBlockStateProvider this$0, String $bottom, String $top, String $side, BlockState state) {
        Boolean burning = (Boolean)state.getValue((Property)CoalGeneratorBlock.Companion.getBURNING());
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        String burningString = burning != false ? "on" : "off";
        Direction direction = facing;
        int yRotation = switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> 0;
            case 2 -> 90;
            case 3 -> 180;
            case 4 -> 270;
            default -> throw new IllegalStateException("Invalid facing direction");
        };
        String modelName = "coal_generator_" + burningString;
        String frontTexture = burning != false ? "block/coal_generator_front_on" : "block/coal_generator_front_off";
        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this$0.models().cube(modelName, this$0.modLoc($bottom), this$0.modLoc($top), this$0.modLoc(frontTexture), this$0.modLoc($side), this$0.modLoc($side), this$0.modLoc($side))).texture("particle", this$0.modLoc($top))).rotationY(yRotation).build();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

