/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.datagen.recipe_builder;

import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00072\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0012\u0010\u0016\u001a\u00020\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/SingletonRecipeBuilder;", "Lnet/minecraft/data/recipes/RecipeBuilder;", "recipe", "Lnet/minecraft/world/item/crafting/Recipe;", "resultItem", "Lnet/minecraft/world/item/Item;", "idString", "", "<init>", "(Lnet/minecraft/world/item/crafting/Recipe;Lnet/minecraft/world/item/Item;Ljava/lang/String;)V", "getRecipe", "()Lnet/minecraft/world/item/crafting/Recipe;", "getResultItem", "()Lnet/minecraft/world/item/Item;", "getIdString", "()Ljava/lang/String;", "criteria", "", "Lnet/minecraft/advancements/Criterion;", "unlockedBy", "name", "criterion", "group", "p0", "getResult", "save", "", "output", "Lnet/minecraft/data/recipes/RecipeOutput;", "defaultId", "Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSingletonRecipeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingletonRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/SingletonRecipeBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,46:1\n216#2,2:47\n*S KotlinDebug\n*F\n+ 1 SingletonRecipeBuilder.kt\ndev/aaronhowser/mods/geneticsresequenced/datagen/recipe_builder/SingletonRecipeBuilder\n*L\n42#1:47,2\n*E\n"})
public final class SingletonRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final Recipe<?> recipe;
    @NotNull
    private final Item resultItem;
    @NotNull
    private final String idString;
    @NotNull
    private final Map<String, Criterion<?>> criteria;

    public SingletonRecipeBuilder(@NotNull Recipe<?> recipe, @NotNull Item resultItem, @NotNull String idString) {
        Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
        Intrinsics.checkNotNullParameter((Object)resultItem, (String)"resultItem");
        Intrinsics.checkNotNullParameter((Object)idString, (String)"idString");
        this.recipe = recipe;
        this.resultItem = resultItem;
        this.idString = idString;
        this.criteria = new LinkedHashMap();
    }

    @NotNull
    public final Recipe<?> getRecipe() {
        return this.recipe;
    }

    @NotNull
    public final Item getResultItem() {
        return this.resultItem;
    }

    @NotNull
    public final String getIdString() {
        return this.idString;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criterion, (String)"criterion");
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String p0) {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public Item getResult() {
        return this.resultItem;
    }

    public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation defaultId) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)defaultId, (String)"defaultId");
        ResourceLocation id = OtherUtil.INSTANCE.modResource(this.idString);
        Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        Map<String, Criterion<?>> $this$forEach$iv = this.criteria;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Criterion<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Criterion<?>> element$iv;
            Map.Entry<String, Criterion<?>> entry2 = element$iv = iterator.next();
            boolean bl = false;
            String name = entry2.getKey();
            Criterion<?> criterion = entry2.getValue();
            advancement.addCriterion(name, criterion);
        }
        output.accept(id, this.recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

