/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.entity.goals;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/goals/FrenzyMeleeAttackGoal;", "Lnet/minecraft/world/entity/ai/goal/MeleeAttackGoal;", "mob", "Lnet/minecraft/world/entity/PathfinderMob;", "speedModifier", "", "followingTargetEvenIfNotSeen", "", "<init>", "(Lnet/minecraft/world/entity/PathfinderMob;DZ)V", "canUse", "canContinueToUse", "checkAndPerformAttack", "", "target", "Lnet/minecraft/world/entity/LivingEntity;", "Companion", "geneticsresequenced-1.21.1"})
public final class FrenzyMeleeAttackGoal
extends MeleeAttackGoal {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public FrenzyMeleeAttackGoal(@NotNull PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        super(mob, speedModifier, followingTargetEvenIfNotSeen);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUse() {
        if (!super.canUse()) return false;
        PathfinderMob pathfinderMob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)pathfinderMob, (String)"mob");
        if (!GenesData.Companion.hasGene((Entity)pathfinderMob, ModGenes.FRENZIED)) return false;
        return true;
    }

    public boolean canContinueToUse() {
        PathfinderMob pathfinderMob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)pathfinderMob, (String)"mob");
        if (!GenesData.Companion.hasGene((Entity)pathfinderMob, ModGenes.FRENZIED)) {
            this.stop();
            return false;
        }
        return super.canContinueToUse();
    }

    protected void checkAndPerformAttack(@NotNull LivingEntity target) {
        boolean hasAttackDamageAttribute;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = hasAttackDamageAttribute = this.mob.getAttribute(Attributes.ATTACK_DAMAGE) != null;
        if (hasAttackDamageAttribute) {
            super.checkAndPerformAttack(target);
            return;
        }
        if (this.canPerformAttack(target)) {
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            PathfinderMob pathfinderMob = this.mob;
            Intrinsics.checkNotNullExpressionValue((Object)pathfinderMob, (String)"mob");
            FrenzyMeleeAttackGoal.Companion.attackWithoutAttribute(pathfinderMob, target);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/goals/FrenzyMeleeAttackGoal$Companion;", "", "<init>", "()V", "attackWithoutAttribute", "", "attacker", "Lnet/minecraft/world/entity/PathfinderMob;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final void attackWithoutAttribute(PathfinderMob attacker, LivingEntity target) {
            boolean flag;
            float damage = 3.0f;
            Level level = attacker.level();
            DamageSource damageSource = level.damageSources().mobAttack((LivingEntity)attacker);
            if (level instanceof ServerLevel) {
                damage = EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)level), (ItemStack)attacker.getWeaponItem(), (Entity)((Entity)target), (DamageSource)damageSource, (float)damage);
            }
            if (flag = target.hurt(damageSource, damage)) {
                float knockback2 = attacker.getKnockback((Entity)target, damageSource);
                if (knockback2 > 0.0f) {
                    target.knockback((double)(knockback2 * 0.5f), (double)((float)Math.sin(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-((float)Math.cos(attacker.getYRot() * ((float)Math.PI / 180)))));
                    attacker.setDeltaMovement(attacker.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                }
                if (level instanceof ServerLevel) {
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)level), (Entity)((Entity)target), (DamageSource)damageSource);
                }
                attacker.setLastHurtMob((Entity)target);
                attacker.playAttackSound();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

