/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.entity.goals;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/entity/goals/FrenzyTargetGoal;", "T", "Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/world/entity/ai/goal/target/NearestAttackableTargetGoal;", "goalOwner", "Lnet/minecraft/world/entity/Mob;", "targetClass", "Ljava/lang/Class;", "<init>", "(Lnet/minecraft/world/entity/Mob;Ljava/lang/Class;)V", "canUse", "", "canContinueToUse", "geneticsresequenced-1.21.1"})
public final class FrenzyTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    public FrenzyTargetGoal(@NotNull Mob goalOwner, @NotNull Class<T> targetClass) {
        Intrinsics.checkNotNullParameter((Object)goalOwner, (String)"goalOwner");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        super(goalOwner, targetClass, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUse() {
        if (!super.canUse()) return false;
        Mob mob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        if (!GenesData.Companion.hasGene((Entity)mob, ModGenes.FRENZIED)) return false;
        return true;
    }

    public boolean canContinueToUse() {
        Mob mob = this.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        if (!GenesData.Companion.hasGene((Entity)mob, ModGenes.FRENZIED)) {
            this.stop();
            return false;
        }
        return super.canContinueToUse();
    }
}

