/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.entity;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.attachment.TemporaryGenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.DamageGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.DeathGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.MobGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.MobDespawnEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001cH\u0007\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/entity/EntityEvents;", "", "<init>", "()V", "onLivingDeath", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "onDetonate", "Lnet/neoforged/neoforge/event/level/ExplosionEvent$Detonate;", "onEntityInvulnerabilityCheck", "Lnet/neoforged/neoforge/event/entity/EntityInvulnerabilityCheckEvent;", "onLivingDamagePre", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "onLivingHurtPost", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "onEntityTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Pre;", "afterEntityTick", "Lnet/neoforged/neoforge/event/tick/EntityTickEvent$Post;", "onEntitySpawn", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "onBabySpawn", "Lnet/neoforged/neoforge/event/entity/living/BabyEntitySpawnEvent;", "inheritGenes", "onMobDespawn", "Lnet/neoforged/neoforge/event/entity/living/MobDespawnEvent;", "onLivingDropExperience", "Lnet/neoforged/neoforge/event/entity/living/LivingExperienceDropEvent;", "geneticsresequenced-1.21.1"})
public final class EntityEvents {
    @NotNull
    public static final EntityEvents INSTANCE = new EntityEvents();

    private EntityEvents() {
    }

    @SubscribeEvent
    public final void onLivingDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathGenes.INSTANCE.handleEmeraldHeart(event);
        DeathGenes.INSTANCE.handleExplosiveExit(event);
        DeathGenes.INSTANCE.handleSlimyDeath(event);
    }

    @SubscribeEvent
    public final void onDetonate(@NotNull ExplosionEvent.Detonate event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathGenes.INSTANCE.explosiveExitDetonation(event);
    }

    @SubscribeEvent
    public final void onEntityInvulnerabilityCheck(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageGenes.INSTANCE.handleNoFallDamage(event);
        DamageGenes.INSTANCE.handleWitherProof(event);
        DamageGenes.INSTANCE.handleFireProof(event);
        DamageGenes.INSTANCE.handleLavaProof(event);
        DamageGenes.INSTANCE.handlePoisonProof(event);
    }

    @SubscribeEvent
    public final void onLivingDamagePre(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageGenes.INSTANCE.handleDragonHealth(event);
        DamageGenes.INSTANCE.handleJohnny(event);
        DamageGenes.INSTANCE.handleClawsDamageBonus(event);
    }

    @SubscribeEvent
    public final void onLivingHurtPost(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getNewDamage() <= 0.0f) {
            return;
        }
        DamageGenes.INSTANCE.handleThorns(event);
        DamageGenes.INSTANCE.handleClawsBleeding(event);
        DamageGenes.INSTANCE.handleWitherHit(event);
        DamageGenes.INSTANCE.handleChilling(event);
        DamageGenes.INSTANCE.handleWebDefense(event);
    }

    @SubscribeEvent
    public final void onEntityTick(@NotNull EntityTickEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        TickGenes.INSTANCE.handleBioluminescence(entity2);
        TickGenes.INSTANCE.handlePhotosynthesis(entity2);
        TickGenes.INSTANCE.handleTickingGenes(entity2);
    }

    @SubscribeEvent
    public final void afterEntityTick(@NotNull EntityTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        TemporaryGenesData.Companion.tickTemporaryGenes(entity2);
    }

    @SubscribeEvent
    public final void onEntitySpawn(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            MobGenes.INSTANCE.attachScareGoals((PathfinderMob)entity);
            MobGenes.INSTANCE.giveFrenzyGoals((Mob)entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onBabySpawn(@NotNull BabyEntitySpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        this.inheritGenes(event);
        MobGenes.INSTANCE.handleFertile(event);
    }

    private final void inheritGenes(BabyEntitySpawnEvent event) {
        Mob parentA = event.getParentA();
        Mob parentB = event.getParentB();
        AgeableMob ageableMob = event.getChild();
        if (ageableMob == null) {
            return;
        }
        AgeableMob child = ageableMob;
        Intrinsics.checkNotNull((Object)parentA);
        Set<Holder<Gene>> aGenes = GenesData.Companion.getPermanentGeneHolders((LivingEntity)parentA);
        Intrinsics.checkNotNull((Object)parentB);
        Set<Holder<Gene>> bGenes = GenesData.Companion.getPermanentGeneHolders((LivingEntity)parentB);
        if (aGenes.isEmpty() && bGenes.isEmpty()) {
            return;
        }
        Set commonGenes = CollectionsKt.intersect((Iterable)aGenes, (Iterable)bGenes);
        Set uniqueGenes = SetsKt.minus((Set)CollectionsKt.union((Iterable)aGenes, (Iterable)bGenes), (Iterable)commonGenes);
        for (Holder gene : commonGenes) {
            GenesData.Companion.addGene((LivingEntity)child, (Holder<Gene>)gene);
        }
        for (Holder gene : uniqueGenes) {
            if (!parentA.getRandom().nextBoolean()) continue;
            GenesData.Companion.addGene((LivingEntity)child, (Holder<Gene>)gene);
        }
    }

    @SubscribeEvent
    public final void onMobDespawn(@NotNull MobDespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Mob mob = event.getEntity();
        Intrinsics.checkNotNull((Object)mob);
        if (!((Collection)GenesData.Companion.getPermanentGeneHolders((LivingEntity)mob)).isEmpty()) {
            event.setResult(MobDespawnEvent.Result.DENY);
        }
    }

    @SubscribeEvent
    public final void onLivingDropExperience(@NotNull LivingExperienceDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DeathGenes.INSTANCE.handleExperienced(event);
    }
}

