/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.scheduler.SchedulerExtensions;
import dev.aaronhowser.mods.geneticsresequenced.GeneticsResequenced;
import dev.aaronhowser.mods.geneticsresequenced.advancement.AdvancementTriggers;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.data.GeneRequirements;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.event.custom.GeneChangeEvent;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.TickGenes;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.GeneChangedPacket;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents;", "", "<init>", "()V", "afterGeneChanged", "", "event", "Ldev/aaronhowser/mods/geneticsresequenced/event/custom/GeneChangeEvent$Post;", "checkForMissingRequirements", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "tellAllPlayersGeneChanged", "changedGene", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "wasAdded", "", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nGeneEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n774#2:105\n865#2,2:106\n774#2:108\n865#2,2:109\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 GeneEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/entity/GeneEvents\n*L\n59#1:105\n59#1:106,2\n71#1:108\n71#1:109,2\n75#1:111\n75#1:112,3\n*E\n"})
public final class GeneEvents {
    @NotNull
    public static final GeneEvents INSTANCE = new GeneEvents();

    private GeneEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void afterGeneChanged(@NotNull GeneChangeEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        LivingEntity livingEntity = event.component1();
        Holder<Gene> geneHolder = event.component2();
        boolean wasAdded = event.component3();
        this.tellAllPlayersGeneChanged(livingEntity, geneHolder, wasAdded);
        ((Gene)geneHolder.value()).setAttributeModifiers(livingEntity, wasAdded);
        if (!wasAdded && !((Collection)((Gene)geneHolder.value()).getPotions()).isEmpty()) {
            TickGenes.INSTANCE.handlePotionGeneRemoved(livingEntity, geneHolder);
        }
        if (livingEntity instanceof ServerPlayer) {
            AdvancementTriggers.INSTANCE.geneAdvancements((ServerPlayer)livingEntity, geneHolder, wasAdded);
        }
        Level level = livingEntity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        SchedulerExtensions.INSTANCE.scheduleTaskInTicks(level, 1, () -> GeneEvents.afterGeneChanged$lambda$0(livingEntity));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForMissingRequirements(LivingEntity entity) {
        Set<Holder<Gene>> entityGeneHolders = GenesData.Companion.getPermanentGeneHolders(entity);
        for (Holder<Gene> geneHolder : entityGeneHolders) {
            Collection<MutableComponent> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            RegistryAccess registryAccess = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            Iterable iterable = GeneRequirements.Companion.getGeneRequiredGeneHolders(geneHolder, (HolderLookup.Provider)registryAccess);
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Holder it = (Holder)element$iv$iv;
                boolean bl = false;
                if (!(!entityGeneHolders.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List genesWithMissingRequirements = (List)destination$iv$iv;
            if (genesWithMissingRequirements.isEmpty()) continue;
            GenesData.Companion.removeGene(entity, geneHolder);
            MutableComponent requiredGenesComponent = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_missing_requirements.list", new Object[0]);
            RegistryAccess registryAccess2 = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess2, (String)"registryAccess(...)");
            $this$filterTo$iv$iv2 = GeneRequirements.Companion.getGeneRequiredGeneHolders(geneHolder, (HolderLookup.Provider)registryAccess2);
            boolean $i$f$filter2 = false;
            void $i$f$filterTo22 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Holder it = (Holder)element$iv$iv;
                boolean bl = false;
                if (!(!entityGeneHolders.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List missingGenes = (List)destination$iv$iv2;
            $this$filter$iv = missingGenes;
            Gene.Companion companion = Gene.Companion;
            OtherUtil otherUtil = OtherUtil.INSTANCE;
            MutableComponent mutableComponent = requiredGenesComponent;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Holder bl = (Holder)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(companion.getNameComponent((Holder<Gene>)p0));
            }
            collection = (List)destination$iv$iv3;
            mutableComponent.append((Component)otherUtil.componentList((List<? extends Component>)collection));
            if (entity.level().isClientSide) continue;
            objectArray = new Object[]{Gene.Companion.getName(geneHolder)};
            MutableComponent mutableComponent2 = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.gene_missing_requirements", objectArray);
            Style style = Style.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"EMPTY");
            entity.sendSystemMessage((Component)mutableComponent2.withStyle(AaronExtensions.INSTANCE.withHoverText(style, (Component)requiredGenesComponent)));
        }
    }

    private final void tellAllPlayersGeneChanged(LivingEntity entity, Holder<Gene> changedGene, boolean wasAdded) {
        if (entity.level().isClientSide) {
            return;
        }
        MinecraftServer server = entity.getServer();
        if (server == null) {
            GeneticsResequenced.Companion.getLOGGER().error("Server is null when trying to tell all players about gene change");
            return;
        }
        GeneChangedPacket packet = new GeneChangedPacket(entity.getId(), changedGene, wasAdded);
        packet.messageAllPlayers();
    }

    private static final void afterGeneChanged$lambda$0(LivingEntity $livingEntity) {
        INSTANCE.checkForMissingRequirements($livingEntity);
    }
}

