/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.event.player;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.AttributeGenes;
import dev.aaronhowser.mods.geneticsresequenced.gene.behavior.DeathGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="geneticsresequenced")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/event/player/DeathEvents;", "", "<init>", "()V", "keepInventory", "", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "keepInventoryFailsafe", "onPlayerRespawn", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "handleKeepGenesOnDeath", "removeNegativeGenesOnDeath", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDeathEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeathEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/player/DeathEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n774#2:94\n865#2,2:95\n*S KotlinDebug\n*F\n+ 1 DeathEvents.kt\ndev/aaronhowser/mods/geneticsresequenced/event/player/DeathEvents\n*L\n79#1:94\n79#1:95,2\n*E\n"})
public final class DeathEvents {
    @NotNull
    public static final DeathEvents INSTANCE = new DeathEvents();

    private DeathEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void keepInventory(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            DeathGenes.INSTANCE.saveInventory((Player)entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void keepInventoryFailsafe(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Player player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (event.isCanceled()) {
            DeathGenes.INSTANCE.returnInventory(player2);
        }
    }

    @SubscribeEvent
    public final void onPlayerRespawn(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        DeathGenes.INSTANCE.returnInventory(player);
        this.handleKeepGenesOnDeath(event);
        this.removeNegativeGenesOnDeath(event);
        AttributeGenes.INSTANCE.returnModifiersOnDeath(event);
        AttributeGenes.INSTANCE.respawnWithMaxHealth(event);
    }

    private final void handleKeepGenesOnDeath(PlayerEvent.PlayerRespawnEvent event) {
        if (((Boolean)ServerConfig.Companion.getCONFIG().getKeepGenesOnDeath().get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        Set<Holder<Gene>> playerGenes = GenesData.Companion.getPermanentGeneHolders((LivingEntity)player);
        if (playerGenes.isEmpty()) {
            return;
        }
        MutableComponent component = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.death_gene_removal", new Object[0]).withStyle(ChatFormatting.GRAY);
        player.sendSystemMessage((Component)component);
        GenesData.Companion.removeAllGenes((LivingEntity)player);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeNegativeGenesOnDeath(PlayerEvent.PlayerRespawnEvent event) {
        void $this$filterTo$iv$iv;
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        Set<Holder<Gene>> playerGeneHolders = GenesData.Companion.getPermanentGeneHolders((LivingEntity)player);
        if (playerGeneHolders.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = playerGeneHolders;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Holder it = (Holder)element$iv$iv;
            boolean bl = false;
            if (!Gene.Companion.isNegative((Holder<Gene>)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List negativeGenes = (List)destination$iv$iv;
        if (negativeGenes.isEmpty()) {
            return;
        }
        MutableComponent component = ModLanguageProvider.Companion.toComponent("message.geneticsresequenced.death_negative_gene_removal", new Object[0]).withStyle(ChatFormatting.GRAY);
        player.sendSystemMessage((Component)component);
        for (Holder gene : negativeGenes) {
            GenesData.Companion.removeGene((LivingEntity)player, (Holder<Gene>)gene);
        }
    }
}

