/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/AttributeGenes;", "", "<init>", "()V", "handleEfficiency", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$BreakSpeed;", "returnModifiersOnDeath", "Lnet/neoforged/neoforge/event/entity/player/PlayerEvent$PlayerRespawnEvent;", "respawnWithMaxHealth", "geneticsresequenced-1.21.1"})
public final class AttributeGenes {
    @NotNull
    public static final AttributeGenes INSTANCE = new AttributeGenes();

    private AttributeGenes() {
    }

    public final void handleEfficiency(@NotNull PlayerEvent.BreakSpeed event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AttributeInstance attributeInstance = event.getEntity().getAttributes().getInstance((Holder)ModAttributes.INSTANCE.getEFFICIENCY());
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance efficiencyAttribute = attributeInstance;
        if (efficiencyAttribute.getValue() <= 0.0) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() + (float)(1.0 + efficiencyAttribute.getValue() * efficiencyAttribute.getValue()));
    }

    public final void returnModifiersOnDeath(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player);
        for (Holder<Gene> geneHolder : GenesData.Companion.getPermanentGeneHolders((LivingEntity)player)) {
            ((Gene)geneHolder.value()).setAttributeModifiers((LivingEntity)player, true);
        }
    }

    public final void respawnWithMaxHealth(@NotNull PlayerEvent.PlayerRespawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        player.setHealth(player.getMaxHealth());
    }
}

