/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.block.WebDefenseBlock;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.item.DragonHealthCrystal;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModEffects;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/DamageGenes;", "", "<init>", "()V", "handleNoFallDamage", "", "event", "Lnet/neoforged/neoforge/event/entity/EntityInvulnerabilityCheckEvent;", "handleWitherProof", "handleFireProof", "handleLavaProof", "handlePoisonProof", "handleDragonHealth", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Pre;", "handleJohnny", "handleClawsDamageBonus", "handleWebDefense", "Lnet/neoforged/neoforge/event/entity/living/LivingDamageEvent$Post;", "handleWitherHit", "handleThorns", "handleClawsBleeding", "handleChilling", "geneticsresequenced-1.21.1"})
public final class DamageGenes {
    @NotNull
    public static final DamageGenes INSTANCE = new DamageGenes();

    private DamageGenes() {
    }

    public final void handleNoFallDamage(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getSource().is(DamageTypes.FALL)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.NO_FALL_DAMAGE)) {
            event.setInvulnerable(true);
        }
    }

    public final void handleWitherProof(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        ResourceKey resourceKey = DamageTypes.WITHER;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"WITHER");
        if (!AaronExtensions.INSTANCE.isDamageSource(damageSource, resourceKey)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.WITHER_PROOF)) {
            ((LivingEntity)entity).removeEffect(MobEffects.WITHER);
            event.setInvulnerable(true);
        }
    }

    public final void handleFireProof(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        ResourceKey resourceKey = DamageTypes.IN_FIRE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"IN_FIRE");
        if (!AaronExtensions.INSTANCE.isDamageSource(damageSource, resourceKey)) {
            DamageSource damageSource2 = event.getSource();
            Intrinsics.checkNotNullExpressionValue((Object)damageSource2, (String)"getSource(...)");
            ResourceKey resourceKey2 = DamageTypes.ON_FIRE;
            Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"ON_FIRE");
            if (!AaronExtensions.INSTANCE.isDamageSource(damageSource2, resourceKey2)) {
                return;
            }
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.FIRE_PROOF)) {
            ((LivingEntity)entity).clearFire();
            event.setInvulnerable(true);
        }
    }

    public final void handleLavaProof(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        ResourceKey resourceKey = DamageTypes.LAVA;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"LAVA");
        if (!AaronExtensions.INSTANCE.isDamageSource(damageSource, resourceKey)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.LAVA_PROOF)) {
            event.setInvulnerable(true);
        }
    }

    public final void handlePoisonProof(@NotNull EntityInvulnerabilityCheckEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        ResourceKey resourceKey = NeoForgeMod.POISON_DAMAGE;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"POISON_DAMAGE");
        if (!AaronExtensions.INSTANCE.isDamageSource(damageSource, resourceKey)) {
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (GenesData.Companion.hasGene(entity, ModGenes.POISON_IMMUNITY)) {
            ((LivingEntity)entity).removeEffect(MobEffects.POISON);
            event.setInvulnerable(true);
        }
    }

    public final void handleDragonHealth(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DragonHealthCrystal.Companion.handleIncomingDamage(event);
    }

    public final void handleJohnny(@NotNull LivingDamageEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getContainer().getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!GenesData.Companion.hasGene((Entity)attacker, ModGenes.JOHNNY)) {
            return;
        }
        boolean weaponIsAxe = attacker.getMainHandItem().getItem().canPerformAction(attacker.getMainHandItem(), ItemAbilities.AXE_DIG);
        if (!weaponIsAxe) {
            return;
        }
        entity = event.getContainer();
        entity.setNewDamage(entity.getNewDamage() * (float)((Number)ServerConfig.Companion.getCONFIG().getJohnnyAttackMultiplier().get()).doubleValue());
    }

    public final void handleClawsDamageBonus(@NotNull LivingDamageEvent.Pre event) {
        int n;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getContainer().getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        ItemStack itemStack = attacker.getMainHandItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
        if (AaronExtensions.INSTANCE.isNotEmpty(itemStack)) {
            return;
        }
        if (GenesData.Companion.hasGene((Entity)attacker, ModGenes.CLAWS_TWO)) {
            n = 2;
        } else if (GenesData.Companion.hasGene((Entity)attacker, ModGenes.CLAWS)) {
            n = 1;
        } else {
            return;
        }
        int clawsLevel = n;
        double additionalDamage = ((Number)ServerConfig.Companion.getCONFIG().getClawsDamage().get()).doubleValue() * (double)clawsLevel;
        DamageContainer damageContainer = event.getContainer();
        damageContainer.setNewDamage(damageContainer.getNewDamage() + (float)additionalDamage);
    }

    public final void handleWebDefense(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity victim = event.getEntity();
        Intrinsics.checkNotNull((Object)victim);
        if (!GenesData.Companion.hasGene((Entity)victim, ModGenes.WEB_DEFENSE)) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        Level level = attacker.level();
        RandomSource randomSource = level.random;
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
        Object object = ServerConfig.Companion.getCONFIG().getWebDefenseChance().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!AaronExtensions.INSTANCE.chance(randomSource, (Number)object)) {
            return;
        }
        BlockPos webPos = attacker.blockPosition();
        if (level.getBlockState(webPos).canBeReplaced()) {
            level.setBlockAndUpdate(webPos, ((WebDefenseBlock)((Object)ModBlocks.INSTANCE.getWEB_DEFENSE_BLOCK().get())).defaultBlockState());
        }
    }

    public final void handleWitherHit(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getSource().isDirect()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (Intrinsics.areEqual((Object)attacker, (Object)victim)) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)attacker, ModGenes.WITHER_HIT)) {
            return;
        }
        MobEffectInstance witherEffect = new MobEffectInstance(MobEffects.WITHER, 100);
        victim.addEffect(witherEffect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void handleThorns(@NotNull LivingDamageEvent.Post event) {
        LivingEntity livingEntity;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof LivingEntity)) return;
        LivingEntity livingEntity2 = (LivingEntity)entity;
        if (livingEntity2 == null) {
            return;
        }
        LivingEntity attacker = livingEntity2;
        LivingEntity livingEntity3 = event.getEntity();
        Mob mob = livingEntity3 instanceof Mob ? (Mob)livingEntity3 : null;
        if (mob != null) {
            livingEntity = (LivingEntity)mob;
        } else {
            LivingEntity livingEntity4 = event.getEntity();
            if (!(livingEntity4 instanceof Player)) return;
            Player player = (Player)livingEntity4;
            if (player == null) return;
            livingEntity = (LivingEntity)player;
        }
        LivingEntity target = livingEntity;
        if (Intrinsics.areEqual((Object)target, (Object)attacker)) {
            return;
        }
        ItemStack chestPlate = target.getItemBySlot(EquipmentSlot.CHEST);
        if (!chestPlate.isEmpty()) {
            Intrinsics.checkNotNull((Object)chestPlate);
            Item item = Items.LEATHER_CHESTPLATE;
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"LEATHER_CHESTPLATE");
            if (!AaronExtensions.INSTANCE.isItem(chestPlate, item)) return;
        }
        boolean bl = true;
        boolean targetChestplateMissingOrLeather = bl;
        if (!targetChestplateMissingOrLeather) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)target, ModGenes.THORNS)) {
            return;
        }
        RandomSource randomSource = target.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        Object object = ServerConfig.Companion.getCONFIG().getThornsChance().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!AaronExtensions.INSTANCE.chance(randomSource, (Number)object)) {
            return;
        }
        DamageSource thornsDamageSource = target.level().damageSources().thorns((Entity)target);
        attacker.hurt(thornsDamageSource, (float)((Number)ServerConfig.Companion.getCONFIG().getThornsDamage().get()).doubleValue());
        if (!(target instanceof Player)) return;
        ((Player)target).causeFoodExhaustion((float)((Number)ServerConfig.Companion.getCONFIG().getThornsHungerDrain().get()).doubleValue());
    }

    public final void handleClawsBleeding(@NotNull LivingDamageEvent.Post event) {
        int n;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        ItemStack itemStack = attacker.getMainHandItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
        if (AaronExtensions.INSTANCE.isNotEmpty(itemStack)) {
            return;
        }
        if (GenesData.Companion.hasGene((Entity)attacker, ModGenes.CLAWS_TWO)) {
            n = 2;
        } else if (GenesData.Companion.hasGene((Entity)attacker, ModGenes.CLAWS)) {
            n = 1;
        } else {
            return;
        }
        int clawsLevel = n;
        double chanceOfHappening = ((Number)ServerConfig.Companion.getCONFIG().getClawsChance().get()).doubleValue() * (double)clawsLevel;
        RandomSource randomSource = attacker.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        if (!AaronExtensions.INSTANCE.chance(randomSource, (Number)chanceOfHappening)) {
            return;
        }
        event.getEntity().addEffect(new MobEffectInstance((Holder)ModEffects.INSTANCE.getBLEED(), 100, 0, false, true, true), (Entity)attacker);
    }

    public final void handleChilling(@NotNull LivingDamageEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getSource().isDirect()) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity attacker = livingEntity;
        if (!GenesData.Companion.hasGene((Entity)attacker, ModGenes.CHILLING)) {
            return;
        }
        RandomSource randomSource = attacker.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        Object object = ServerConfig.Companion.getCONFIG().getChillChance().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (!AaronExtensions.INSTANCE.chance(randomSource, (Number)object)) {
            return;
        }
        LivingEntity target = event.getEntity();
        Object object2 = ServerConfig.Companion.getCONFIG().getChillDuration().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        target.setTicksFrozen(((Number)object2).intValue());
    }
}

