/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.advancement.AdvancementTriggers;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.attachment.KeptInventory;
import dev.aaronhowser.mods.geneticsresequenced.compatibility.curios.KeepCurioInventory;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.entity.SupportSlime;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttributes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u001bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/DeathGenes;", "", "<init>", "()V", "saveInventory", "", "player", "Lnet/minecraft/world/entity/player/Player;", "returnInventory", "EMERALD_HEART_COOLDOWN", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "handleEmeraldHeart", "event", "Lnet/neoforged/neoforge/event/entity/living/LivingDeathEvent;", "RECENTLY_EXPLODED_ENTITIES", "", "Ljava/util/UUID;", "GUNPOWDER_REQUIRED", "", "EXPLOSION_STRENGTH", "", "handleExplosiveExit", "explosiveExitDetonation", "Lnet/neoforged/neoforge/event/level/ExplosionEvent$Detonate;", "SLIMY_DEATH_COOLDOWN", "handleSlimyDeath", "handleExperienced", "Lnet/neoforged/neoforge/event/entity/living/LivingExperienceDropEvent;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDeathGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeathGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/DeathGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n774#2:192\n865#2,2:193\n1869#2,2:195\n1#3:197\n*S KotlinDebug\n*F\n+ 1 DeathGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/DeathGenes\n*L\n44#1:192\n44#1:193,2\n60#1:195,2\n*E\n"})
public final class DeathGenes {
    @NotNull
    public static final DeathGenes INSTANCE = new DeathGenes();
    @NotNull
    private static final GeneCooldown EMERALD_HEART_COOLDOWN;
    @NotNull
    private static final Set<UUID> RECENTLY_EXPLODED_ENTITIES;
    private static final int GUNPOWDER_REQUIRED = 5;
    private static final float EXPLOSION_STRENGTH = 3.0f;
    @NotNull
    private static final GeneCooldown SLIMY_DEATH_COOLDOWN;

    private DeathGenes() {
    }

    /*
     * WARNING - void declaration
     */
    public final void saveInventory(@NotNull Player player) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Level level = player.level();
        if (level.isClientSide || level.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || level.getLevelData().isHardcore()) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.KEEP_INVENTORY)) {
            return;
        }
        NonNullList nonNullList = player.getInventory().items;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
        Collection collection = (Collection)nonNullList;
        NonNullList nonNullList2 = player.getInventory().armor;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"armor");
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)nonNullList2));
        NonNullList nonNullList3 = player.getInventory().offhand;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList3, (String)"offhand");
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)nonNullList3));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemStack it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List playerItems = (List)destination$iv$iv;
        KeptInventory.Companion.saveInventory(player, playerItems);
        boolean curiosIsLoaded = ModList.get().isLoaded("curios");
        if (curiosIsLoaded) {
            KeepCurioInventory.INSTANCE.saveCurios(player);
        }
        player.getInventory().clearContent();
    }

    public final void returnInventory(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<ItemStack> items = KeptInventory.Companion.getSavedInventory(player);
        if (items.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack itemStack = (ItemStack)element$iv;
            boolean bl = false;
            if (player.getInventory().add(itemStack)) continue;
            ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), itemStack);
            player.level().addFreshEntity((Entity)itemEntity);
        }
        KeptInventory.Companion.clearSavedInventory(player);
    }

    public final void handleEmeraldHeart(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.EMERALD_HEART)) {
            return;
        }
        if (!(entity instanceof Player)) {
            ItemEntity itemEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.EMERALD, 1));
            entity.level().addFreshEntity((Entity)itemEntity);
            return;
        }
        boolean wasNotOnCooldown = EMERALD_HEART_COOLDOWN.add(entity);
        if (!wasNotOnCooldown) {
            return;
        }
        ((Player)entity).getInventory().add(new ItemStack((ItemLike)Items.EMERALD, 1));
    }

    /*
     * WARNING - void declaration
     */
    public final void handleExplosiveExit(@NotNull LivingDeathEvent event) {
        boolean shouldExplode;
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.EXPLOSIVE_EXIT)) {
            return;
        }
        if (!(entity instanceof Player)) {
            v0 = true;
        } else {
            NonNullList nonNullList = ((Player)entity).getInventory().items;
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
            object = (Iterable)nonNullList;
            int n = 0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = iterator.next();
                ItemStack itemStack = (ItemStack)t;
                int n2 = n;
                boolean bl = false;
                int n3 = Intrinsics.areEqual((Object)it.getItem(), (Object)Items.GUNPOWDER) ? it.getCount() : 0;
                n = n2 + n3;
            }
            int amountGunpowder = n;
            v0 = shouldExplode = amountGunpowder >= 5;
        }
        if (!shouldExplode) {
            return;
        }
        UUID uUID = entity.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        RECENTLY_EXPLODED_ENTITIES.add(uUID);
        entity.level().explode((Entity)entity, entity.getX(), entity.getY(), entity.getZ(), 3.0f, Level.ExplosionInteraction.NONE);
        RECENTLY_EXPLODED_ENTITIES.remove(entity.getUUID());
        if (entity instanceof Player) {
            int amountGunpowderRemoved = 0;
            Iterator iterator = ((Player)entity).getInventory().items.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                ItemStack stack = (ItemStack)object.next();
                if (!Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.GUNPOWDER)) continue;
                while (stack.getCount() > 0 && amountGunpowderRemoved < 5) {
                    stack.shrink(1);
                    ++amountGunpowderRemoved;
                }
                if (amountGunpowderRemoved < 5) continue;
                break;
            }
        }
    }

    public final void explosiveExitDetonation(@NotNull ExplosionEvent.Detonate event) {
        UUID exploderUuid;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getExplosion().getDirectSourceEntity();
        UUID uUID = exploderUuid = entity != null ? entity.getUUID() : null;
        if (!CollectionsKt.contains((Iterable)RECENTLY_EXPLODED_ENTITIES, (Object)exploderUuid)) {
            return;
        }
        List list = event.getAffectedEntities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAffectedEntities(...)");
        CollectionsKt.removeAll((List)list, DeathGenes::explosiveExitDetonation$lambda$3);
        event.getAffectedBlocks().clear();
    }

    public final void handleSlimyDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Intrinsics.checkNotNull((Object)entity);
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.SLIMY_DEATH)) {
            return;
        }
        boolean newlyUsed = SLIMY_DEATH_COOLDOWN.add(entity);
        if (!newlyUsed) {
            return;
        }
        RandomSource randomSource = entity.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        int amount = AaronExtensions.INSTANCE.nextRange(randomSource, 3, 6);
        int n = 0;
        while (n < amount) {
            int it = n++;
            boolean bl = false;
            Level level = entity.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            UUID uUID = entity.getUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
            SupportSlime supportSlime = new SupportSlime(level, uUID);
            Vec3 vec3 = entity.position();
            RandomSource randomSource2 = entity.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource2, (String)"getRandom(...)");
            double d = AaronExtensions.INSTANCE.nextRange(randomSource2, -1.0, 1.0);
            RandomSource randomSource3 = entity.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource3, (String)"getRandom(...)");
            Vec3 randomNearbyPosition = vec3.add(d, 0.0, AaronExtensions.INSTANCE.nextRange(randomSource3, -1.0, 1.0));
            supportSlime.moveTo(randomNearbyPosition.x, randomNearbyPosition.y, randomNearbyPosition.z);
            entity.level().addFreshEntity((Entity)supportSlime);
        }
        event.setCanceled(true);
        entity.setHealth(entity.getMaxHealth() * (float)((Number)ServerConfig.Companion.getCONFIG().getSlimyDeathHealthMultiplier().get()).doubleValue());
        if (entity instanceof ServerPlayer) {
            AdvancementTriggers.INSTANCE.slimyDeathAdvancement((ServerPlayer)entity);
        }
    }

    public final void handleExperienced(@NotNull LivingExperienceDropEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegistryAccess registryAccess = event.getEntity().registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        if (Gene.Companion.isDisabled(ModGenes.EXPERIENCED, (HolderLookup.Provider)registryAccess)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        double multiplier = entity.getAttributeValue((Holder)ModAttributes.INSTANCE.getXP_DROP_MULTIPLIER());
        event.setDroppedExperience(Mth.ceil((double)((double)event.getDroppedExperience() * multiplier)));
    }

    private static final boolean explosiveExitDetonation$lambda$3(Entity it) {
        return !(it instanceof LivingEntity);
    }

    static {
        Object object = ServerConfig.Companion.getCONFIG().getEmeraldHeartCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EMERALD_HEART_COOLDOWN = new GeneCooldown(ModGenes.EMERALD_HEART, ((Number)object).intValue(), false, 4, null);
        RECENTLY_EXPLODED_ENTITIES = new LinkedHashSet();
        Object object2 = ServerConfig.Companion.getCONFIG().getSlimyDeathCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        SLIMY_DEATH_COOLDOWN = new GeneCooldown(ModGenes.SLIMY_DEATH, ((Number)object2).intValue(), false, 4, null);
    }
}

