/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.entity.goals.FrenzyMeleeAttackGoal;
import dev.aaronhowser.mods.geneticsresequenced.entity.goals.FrenzyTargetGoal;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/MobGenes;", "", "<init>", "()V", "isFertileCloning", "", "handleFertile", "", "event", "Lnet/neoforged/neoforge/event/entity/living/BabyEntitySpawnEvent;", "shouldPlacidCancelTargetGoal", "goal", "Lnet/minecraft/world/entity/ai/goal/target/TargetGoal;", "giveFrenzyGoals", "mob", "Lnet/minecraft/world/entity/Mob;", "beeRequiredPollinationTime", "", "bee", "Lnet/minecraft/world/entity/animal/Bee;", "attachScareGoals", "entity", "Lnet/minecraft/world/entity/PathfinderMob;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nMobGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/MobGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1761#2,3:109\n1761#2,3:112\n*S KotlinDebug\n*F\n+ 1 MobGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/MobGenes\n*L\n54#1:109,3\n62#1:112,3\n*E\n"})
public final class MobGenes {
    @NotNull
    public static final MobGenes INSTANCE = new MobGenes();
    private static boolean isFertileCloning;

    private MobGenes() {
    }

    public final void handleFertile(@NotNull BabyEntitySpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (isFertileCloning) {
            return;
        }
        Mob mob = event.getParentA();
        Animal animal = mob instanceof Animal ? (Animal)mob : null;
        if (animal == null) {
            return;
        }
        Animal parentA = animal;
        Mob mob2 = event.getParentB();
        Animal animal2 = mob2 instanceof Animal ? (Animal)mob2 : null;
        if (animal2 == null) {
            return;
        }
        Animal parentB = animal2;
        Level level = parentA.level();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        int extraBabies = 0;
        if (GenesData.Companion.hasGene((Entity)parentA, ModGenes.FERTILE)) {
            ++extraBabies;
        }
        if (GenesData.Companion.hasGene((Entity)parentB, ModGenes.FERTILE)) {
            ++extraBabies;
        }
        if (extraBabies == 0) {
            return;
        }
        isFertileCloning = true;
        int n = extraBabies;
        for (int i = 0; i < n; ++i) {
            parentA.spawnChildFromBreeding(level2, parentB);
        }
        isFertileCloning = false;
    }

    @JvmStatic
    public static final boolean shouldPlacidCancelTargetGoal(@NotNull TargetGoal goal) {
        Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
        Mob mob = goal.mob;
        Intrinsics.checkNotNullExpressionValue((Object)mob, (String)"mob");
        return GenesData.Companion.hasGene((Entity)mob, ModGenes.PLACID);
    }

    public final void giveFrenzyGoals(@NotNull Mob mob) {
        boolean alreadyCanAttack;
        block10: {
            boolean alreadyHasFrenzyTargetGoal;
            block9: {
                Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
                if (!(mob instanceof PathfinderMob)) {
                    return;
                }
                Set set = mob.targetSelector.getAvailableGoals();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAvailableGoals(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WrappedGoal it = (WrappedGoal)element$iv;
                        boolean bl = false;
                        if (!(it.getGoal() instanceof FrenzyTargetGoal)) continue;
                        v1 = true;
                        break block9;
                    }
                    v1 = alreadyHasFrenzyTargetGoal = false;
                }
            }
            if (!alreadyHasFrenzyTargetGoal) {
                mob.targetSelector.addGoal(1, (Goal)new FrenzyTargetGoal<LivingEntity>(mob, LivingEntity.class));
            }
            Set set = mob.goalSelector.getAvailableGoals();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAvailableGoals(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WrappedGoal it = (WrappedGoal)element$iv;
                    boolean bl = false;
                    if (!(it.getGoal() instanceof MeleeAttackGoal)) continue;
                    v3 = true;
                    break block10;
                }
                v3 = alreadyCanAttack = false;
            }
        }
        if (!alreadyCanAttack) {
            mob.goalSelector.addGoal(4, (Goal)new FrenzyMeleeAttackGoal((PathfinderMob)mob, 1.0, false));
        }
    }

    @JvmStatic
    public static final int beeRequiredPollinationTime(@NotNull Bee bee) {
        Intrinsics.checkNotNullParameter((Object)bee, (String)"bee");
        if (GenesData.Companion.hasGene((Entity)bee, ModGenes.BOUNTIFUL_TWO)) {
            return 100;
        }
        if (GenesData.Companion.hasGene((Entity)bee, ModGenes.BOUNTIFUL)) {
            return 200;
        }
        return 400;
    }

    public final void attachScareGoals(@NotNull PathfinderMob entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        RegistryAccess registryAccess = entity.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        Stream<Holder.Reference<Gene>> allGenes = ModGenes.getAllGeneHolders((HolderLookup.Provider)registryAccess);
        Iterator iterator = allGenes.iterator();
        while (iterator.hasNext()) {
            TagKey cowardTag;
            Holder.Reference gene = (Holder.Reference)iterator.next();
            Intrinsics.checkNotNull((Object)gene);
            if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)gene)) || (TagKey)OptionalsKt.getOrNull(((Gene)gene.value()).getScaresEntitiesWithTag()) == null || !AaronExtensions.INSTANCE.isEntity((Entity)entity, cowardTag)) continue;
            entity.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal(entity, LivingEntity.class, arg_0 -> MobGenes.attachScareGoals$lambda$2(gene, arg_0), 12.0f, 1.2, 1.6, EntitySelector.NO_SPECTATORS::test));
        }
    }

    private static final boolean attachScareGoals$lambda$2(Holder.Reference $gene, LivingEntity otherEntity) {
        Intrinsics.checkNotNullParameter((Object)otherEntity, (String)"otherEntity");
        Entity entity = (Entity)otherEntity;
        Intrinsics.checkNotNull((Object)$gene);
        return GenesData.Companion.hasGene(entity, (Holder<Gene>)((Holder)$gene));
    }
}

