/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.gene.behavior;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.block.AntiFieldBlock;
import dev.aaronhowser.mods.geneticsresequenced.block.BioluminescenceBlock;
import dev.aaronhowser.mods.geneticsresequenced.config.ClientConfig;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.datagen.tag.ModItemTagsProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.gene.GeneCooldown;
import dev.aaronhowser.mods.geneticsresequenced.item.AntiFieldOrbItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModBlocks;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u001eH\u0002J\u001c\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\nJ\u000e\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\nR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0019\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0017\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00170\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes;", "", "<init>", "()V", "handleBioluminescence", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "handlePhotosynthesis", "handleNoHunger", "Lnet/minecraft/world/entity/player/Player;", "isDeathGene", "", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "handleTickingGenes", "handleDeathGenes", "virusDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "level", "Lnet/minecraft/world/level/Level;", "VIRUS_DAMAGE_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "GENE_INFERIORITY_MAP", "", "", "handlePotionGenes", "genesWithPotions", "", "handlePotionGeneRemoved", "removedGene", "RECENTLY_MEATED_TWO", "Ldev/aaronhowser/mods/geneticsresequenced/gene/GeneCooldown;", "handleMeatyTwo", "RECENTLY_LAID_EGGS", "handleLayEgg", "handleItemMagnet", "player", "itemMagnetBlacklistTooltip", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "handleXpMagnet", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTickGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n1563#2:307\n1634#2,3:308\n1#3:311\n*S KotlinDebug\n*F\n+ 1 TickGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/gene/behavior/TickGenes\n*L\n180#1:307\n180#1:308,3\n*E\n"})
public final class TickGenes {
    @NotNull
    public static final TickGenes INSTANCE = new TickGenes();
    @NotNull
    private static final ResourceKey<DamageType> VIRUS_DAMAGE_KEY;
    @NotNull
    private static final Map<ResourceKey<Gene>, List<ResourceKey<Gene>>> GENE_INFERIORITY_MAP;
    @NotNull
    private static final GeneCooldown RECENTLY_MEATED_TWO;
    @NotNull
    private static final GeneCooldown RECENTLY_LAID_EGGS;

    private TickGenes() {
    }

    public final void handleBioluminescence(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.BIOLUMINESCENCE)) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getBioluminescenceCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        Level level = entity.level();
        if (level.getBrightness(LightLayer.BLOCK, entity.blockPosition()) > 8) {
            return;
        }
        BlockState headBlock = level.getBlockState(entity.blockPosition().above());
        if (!headBlock.isAir()) {
            return;
        }
        level.setBlockAndUpdate(entity.blockPosition().above(), ((BioluminescenceBlock)((Object)ModBlocks.INSTANCE.getBIOLUMINESCENCE_BLOCK().get())).defaultBlockState());
    }

    public final void handlePhotosynthesis(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof Player)) {
            return;
        }
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getPhotosynthesisCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.PHOTOSYNTHESIS)) {
            return;
        }
        FoodData foodData = ((Player)entity).getFoodData();
        if (!foodData.needsFood()) {
            return;
        }
        boolean inDirectSunlight = entity.level().canSeeSky(entity.blockPosition());
        boolean isDay = entity.level().isDay();
        if (!inDirectSunlight || !isDay) {
            return;
        }
        Object object2 = ServerConfig.Companion.getCONFIG().getPhotosynthesisHungerAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        foodData.eat(((Number)object2).intValue(), (float)((Number)ServerConfig.Companion.getCONFIG().getPhotosynthesisSaturationAmount().get()).doubleValue());
    }

    public final void handleNoHunger(@NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getNoHungerCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)entity, ModGenes.NO_HUNGER)) {
            return;
        }
        FoodData foodData = entity.getFoodData();
        int n2 = foodData.getFoodLevel();
        Object object2 = ServerConfig.Companion.getCONFIG().getNoHungerMinimum().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        int n3 = ((Number)object2).intValue();
        foodData.setFoodLevel(Math.max(n2, n3));
    }

    private final boolean isDeathGene(Holder<Gene> geneHolder) {
        return Gene.Companion.isGene(geneHolder, ModGenes.BLACK_DEATH) || Gene.Companion.isGene(geneHolder, ModGenes.GREEN_DEATH) || Gene.Companion.isGene(geneHolder, ModGenes.GRAY_DEATH) || Gene.Companion.isGene(geneHolder, ModGenes.UN_UNDEATH) || Gene.Companion.isGene(geneHolder, ModGenes.WHITE_DEATH);
    }

    public final void handleTickingGenes(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        int n = entity.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getPassivesCheckCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!(entity instanceof Mob) && !(entity instanceof Player)) {
            return;
        }
        Set<Holder<Gene>> geneHolders = GenesData.Companion.getGenes(entity);
        List potionGenes = new ArrayList();
        for (Holder<Gene> geneHolder : geneHolders) {
            if (Gene.Companion.isDisabled(geneHolder)) continue;
            if (!((Collection)((Gene)geneHolder.value()).getPotions()).isEmpty()) {
                potionGenes.add(geneHolder);
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.WATER_BREATHING)) {
                entity.setAirSupply(entity.getMaxAirSupply());
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.FLAMBE)) {
                entity.setRemainingFireTicks(((Number)ServerConfig.Companion.getCONFIG().getPassivesCheckCooldown().get()).intValue() * 2 * 20);
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.LAY_EGG)) {
                this.handleLayEgg(entity);
                continue;
            }
            if (Gene.Companion.isGene(geneHolder, ModGenes.MEATY_TWO)) {
                this.handleMeatyTwo(entity);
                continue;
            }
            if (!this.isDeathGene(geneHolder)) continue;
            this.handleDeathGenes(entity, geneHolder);
        }
        this.handlePotionGenes(entity, potionGenes);
    }

    private final void handleDeathGenes(LivingEntity entity, Holder<Gene> geneHolder) {
        Function1 function1;
        if (Gene.Companion.isGene(geneHolder, ModGenes.BLACK_DEATH)) {
            Level level = entity.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            entity.hurt(this.virusDamageSource(level), entity.getMaxHealth() * (float)1000);
            entity.kill();
            if (entity.isAlive()) {
                DamageSources damageSources = entity.level().damageSources();
                entity.hurt(damageSources.fellOutOfWorld(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.magic(), entity.getMaxHealth() * (float)1000);
                entity.hurt(damageSources.wither(), entity.getMaxHealth() * (float)1000);
                if (entity.isAlive()) {
                    entity.remove(Entity.RemovalReason.KILLED);
                }
            }
        }
        if (Gene.Companion.isGene(geneHolder, ModGenes.GREEN_DEATH)) {
            function1 = TickGenes::handleDeathGenes$lambda$0;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.UN_UNDEATH)) {
            function1 = TickGenes::handleDeathGenes$lambda$1;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.GRAY_DEATH)) {
            function1 = TickGenes::handleDeathGenes$lambda$2;
        } else if (Gene.Companion.isGene(geneHolder, ModGenes.WHITE_DEATH)) {
            function1 = TickGenes::handleDeathGenes$lambda$3;
        } else {
            return;
        }
        Function1 entityPredicate = function1;
        if (!((Boolean)entityPredicate.invoke((Object)entity)).booleanValue()) {
            return;
        }
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        entity.hurt(this.virusDamageSource(level), Math.max(entity.getHealth() / (float)2, 2.0f));
    }

    private final DamageSource virusDamageSource(Level level) {
        DamageSource damageSource = level.damageSources().source(VIRUS_DAMAGE_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"source(...)");
        return damageSource;
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePotionGenes(LivingEntity entity, List<Holder<Gene>> genesWithPotions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (genesWithPotions.isEmpty()) {
            return;
        }
        List genesToSkip = new ArrayList();
        for (Holder geneHolder : CollectionsKt.toList((Iterable)genesWithPotions)) {
            List<ResourceKey<Gene>> redundantGenes;
            if (GENE_INFERIORITY_MAP.get(geneHolder.getKey()) == null) continue;
            boolean bl = false;
            genesToSkip.addAll((Collection)redundantGenes);
        }
        Iterator<Holder<Gene>> iterator = genesToSkip;
        List<Holder<Gene>> list = genesWithPotions;
        boolean $i$f$map = false;
        Iterator<MobEffectInstance> iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceKey resourceKey = (ResourceKey)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RegistryAccess registryAccess = entity.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            collection.add(ModGenes.INSTANCE.getHolderOrThrow((ResourceKey<Gene>)it, (HolderLookup.Provider)registryAccess));
        }
        list.removeAll((List)destination$iv$iv);
        for (Holder<Gene> geneHolder : genesWithPotions) {
            for (MobEffectInstance genePotion : ((Gene)geneHolder.value()).getPotions()) {
                MobEffectInstance existingEffect = entity.getEffect(genePotion.getEffect());
                if (existingEffect != null && existingEffect.getAmplifier() >= genePotion.getAmplifier()) continue;
                entity.removeEffect(genePotion.getEffect());
                entity.addEffect(genePotion);
            }
        }
    }

    public final void handlePotionGeneRemoved(@NotNull LivingEntity entity, @NotNull Holder<Gene> removedGene) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(removedGene, (String)"removedGene");
        List<MobEffectInstance> genePotions = ((Gene)removedGene.value()).getPotions();
        for (MobEffectInstance genePotion : genePotions) {
            MobEffectInstance existingEffect;
            if (entity.getEffect(genePotion.getEffect()) == null || existingEffect.getAmplifier() != genePotion.getAmplifier()) continue;
            entity.removeEffect(genePotion.getEffect());
        }
    }

    private final void handleMeatyTwo(LivingEntity entity) {
        Object v1;
        block2: {
            boolean newlyMeated = RECENTLY_MEATED_TWO.add(entity);
            if (!newlyMeated) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck2 = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity meatEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.COOKED_PORKCHOP, 1 + luck2));
        entity.level().addFreshEntity((Entity)meatEntity);
    }

    private final void handleLayEgg(LivingEntity entity) {
        Object v1;
        block2: {
            boolean hasNotRecentlyLainEgg = RECENTLY_LAID_EGGS.add(entity);
            if (!hasNotRecentlyLainEgg) {
                return;
            }
            Collection collection = entity.getActiveEffects();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActiveEffects(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                MobEffectInstance it = (MobEffectInstance)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getEffect(), (Object)MobEffects.LUCK)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        MobEffectInstance mobEffectInstance = v1;
        int luck2 = mobEffectInstance != null ? mobEffectInstance.getAmplifier() : 0;
        ItemEntity eggEntity = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)Items.EGG, 1 + luck2));
        entity.level().addFreshEntity((Entity)eggEntity);
    }

    public final void handleItemMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getItemMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.ITEM_MAGNET)) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object2 = ServerConfig.Companion.getCONFIG().getItemMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List nearbyItems = level.getEntitiesOfClass(ItemEntity.class, aABB.inflate(((Number)object2).doubleValue()));
        for (ItemEntity itemEntity : nearbyItems) {
            if (itemEntity.getItem().getCount() <= 0 || Intrinsics.areEqual((Object)itemEntity.getOwner(), (Object)player) && itemEntity.getAge() < 60) continue;
            ItemStack itemStack = itemEntity.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
            if (AaronExtensions.INSTANCE.isItem(itemStack, ModItemTagsProvider.Companion.getMAGNET_ITEM_BLACKLIST())) continue;
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = itemEntity.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            itemEntity.playerTouch(player);
        }
    }

    public final void itemMagnetBlacklistTooltip(@NotNull ItemTooltipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!((Boolean)ClientConfig.Companion.getCONFIG().getItemMagnetBlacklistTooltip().get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (!GenesData.Companion.hasGene((Entity)player2, ModGenes.ITEM_MAGNET)) {
            return;
        }
        ItemStack item = event.getItemStack();
        Intrinsics.checkNotNull((Object)item);
        if (!AaronExtensions.INSTANCE.isItem(item, ModItemTagsProvider.Companion.getMAGNET_ITEM_BLACKLIST())) {
            return;
        }
        MutableComponent component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.item_magnet_blacklist", new Object[0]).withStyle(ChatFormatting.DARK_GRAY);
        event.getToolTip().add(component);
    }

    public final void handleXpMagnet(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.isCrouching() || player.isDeadOrDying() || player.isSpectator()) {
            return;
        }
        int n = player.tickCount;
        Object object = ServerConfig.Companion.getCONFIG().getXpMagnetCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (n % ((Number)object).intValue() != 0) {
            return;
        }
        if (!GenesData.Companion.hasGene((Entity)player, ModGenes.XP_MAGNET)) {
            return;
        }
        if (AntiFieldOrbItem.Companion.isActiveForPlayer(player)) {
            return;
        }
        Level level = player.level();
        AABB aABB = player.getBoundingBox();
        Object object2 = ServerConfig.Companion.getCONFIG().getXpMagnetRadius().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        List nearbyXpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, aABB.inflate(((Number)object2).doubleValue()));
        for (ExperienceOrb xpOrb : nearbyXpOrbs) {
            Level level2 = player.level();
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
            BlockPos blockPos = xpOrb.blockPosition();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            if (AntiFieldBlock.Companion.isNearActiveAntifield(level2, blockPos)) continue;
            xpOrb.playerTouch(player);
            player.takeXpDelay = 1;
        }
    }

    private static final boolean handleDeathGenes$lambda$0(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof Creeper;
    }

    private static final boolean handleDeathGenes$lambda$1(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Entity entity = (Entity)it;
        TagKey tagKey = EntityTypeTags.UNDEAD;
        Intrinsics.checkNotNullExpressionValue((Object)tagKey, (String)"UNDEAD");
        return AaronExtensions.INSTANCE.isEntity(entity, tagKey);
    }

    private static final boolean handleDeathGenes$lambda$2(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof AgeableMob || it instanceof Zombie || it instanceof Piglin;
    }

    private static final boolean handleDeathGenes$lambda$3(LivingEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().getCategory() == MobCategory.MONSTER;
    }

    static {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)OtherUtil.INSTANCE.modResource("virus"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        VIRUS_DAMAGE_KEY = resourceKey;
        Pair[] pairArray = new Pair[9];
        Object[] objectArray = new ResourceKey[]{ModGenes.SPEED, ModGenes.SPEED_TWO};
        pairArray[0] = TuplesKt.to(ModGenes.SPEED_FOUR, (Object)CollectionsKt.listOf((Object[])objectArray));
        pairArray[1] = TuplesKt.to(ModGenes.SPEED_TWO, (Object)CollectionsKt.listOf(ModGenes.SPEED));
        pairArray[2] = TuplesKt.to(ModGenes.REGENERATION_FOUR, (Object)CollectionsKt.listOf(ModGenes.REGENERATION));
        pairArray[3] = TuplesKt.to(ModGenes.HASTE_TWO, (Object)CollectionsKt.listOf(ModGenes.HASTE));
        pairArray[4] = TuplesKt.to(ModGenes.RESISTANCE_TWO, (Object)CollectionsKt.listOf(ModGenes.RESISTANCE));
        pairArray[5] = TuplesKt.to(ModGenes.STRENGTH_TWO, (Object)CollectionsKt.listOf(ModGenes.STRENGTH));
        pairArray[6] = TuplesKt.to(ModGenes.POISON_FOUR, (Object)CollectionsKt.listOf(ModGenes.POISON));
        pairArray[7] = TuplesKt.to(ModGenes.SLOWNESS_FOUR, (Object)CollectionsKt.listOf(ModGenes.SLOWNESS));
        objectArray = new ResourceKey[]{ModGenes.SLOWNESS, ModGenes.SLOWNESS_FOUR};
        pairArray[8] = TuplesKt.to(ModGenes.SLOWNESS_SIX, (Object)CollectionsKt.listOf((Object[])objectArray));
        GENE_INFERIORITY_MAP = MapsKt.mapOf((Pair[])pairArray);
        Object object = ServerConfig.Companion.getCONFIG().getMeaty2Cooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        RECENTLY_MEATED_TWO = new GeneCooldown(ModGenes.MEATY_TWO, ((Number)object).intValue(), false);
        Object object2 = ServerConfig.Companion.getCONFIG().getEggCooldown().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        RECENTLY_LAID_EGGS = new GeneCooldown(ModGenes.LAY_EGG, ((Number)object2).intValue(), false);
    }
}

