/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.menu.advanced_incubator;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.client.AaronClientUtil;
import dev.aaronhowser.mods.aaron.menu.MenuWithButtons;
import dev.aaronhowser.mods.aaron.menu.components.FilteredSlot;
import dev.aaronhowser.mods.geneticsresequenced.config.ServerConfig;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.menu.CraftingMachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.GmoRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\rJ\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u0014\u0010\u000e\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/advanced_incubator/AdvancedIncubatorMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/menu/CraftingMachineMenu;", "Ldev/aaronhowser/mods/aaron/menu/MenuWithButtons;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "machineContainer", "Lnet/minecraft/world/Container;", "craftingContainerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/inventory/ContainerData;)V", "(ILnet/minecraft/world/entity/player/Inventory;)V", "amountSlots", "getAmountSlots", "()I", "isHighTemperature", "", "setIsHighTemperature", "", "value", "addSlots", "handleButtonPressed", "buttonId", "Companion", "geneticsresequenced-1.21.1"})
public final class AdvancedIncubatorMenu
extends CraftingMachineMenu
implements MenuWithButtons {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int amountSlots;
    public static final int CYCLE_TEMPERATURE_BUTTON_ID = 0;

    public AdvancedIncubatorMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Container machineContainer, @NotNull ContainerData craftingContainerData) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)machineContainer, (String)"machineContainer");
        Intrinsics.checkNotNullParameter((Object)craftingContainerData, (String)"craftingContainerData");
        Object object = ModMenuTypes.INSTANCE.getADVANCED_INCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, containerId, playerInventory, machineContainer, craftingContainerData);
        this.amountSlots = 6;
        this.addSlots();
        AbstractContainerMenu.checkContainerDataCount((ContainerData)craftingContainerData, (int)5);
    }

    public AdvancedIncubatorMenu(int containerId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this(containerId, playerInventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(5));
    }

    @Override
    protected int getAmountSlots() {
        return this.amountSlots;
    }

    public final boolean isHighTemperature() {
        return this.getMachineContainerData().get(4) == 1;
    }

    public final void setIsHighTemperature(boolean value) {
        this.getMachineContainerData().set(4, value ? 1 : 0);
    }

    @Override
    public void addSlots() {
        FilteredSlot topSlot = new FilteredSlot(this.getMachineContainer(), 0, 83, 21, arg_0 -> AdvancedIncubatorMenu.addSlots$lambda$0(this, arg_0));
        FilteredSlot leftBottleSlot = new FilteredSlot(this.getMachineContainer(), 1, 60, 55, arg_0 -> AdvancedIncubatorMenu.addSlots$lambda$1(this, arg_0));
        FilteredSlot middleBottleSlot = new FilteredSlot(this.getMachineContainer(), 2, 83, 62, arg_0 -> AdvancedIncubatorMenu.addSlots$lambda$2(this, arg_0));
        FilteredSlot rightBottleSlot = new FilteredSlot(this.getMachineContainer(), 3, 106, 55, arg_0 -> AdvancedIncubatorMenu.addSlots$lambda$3(this, arg_0));
        FilteredSlot chorusSlot = new FilteredSlot(this.getMachineContainer(), 4, 141, 38, AdvancedIncubatorMenu::addSlots$lambda$4);
        FilteredSlot overclockerSlot = new FilteredSlot(this.getMachineContainer(), 5, 141, 60, AdvancedIncubatorMenu::addSlots$lambda$5);
        this.addSlot((Slot)topSlot);
        this.addSlot((Slot)leftBottleSlot);
        this.addSlot((Slot)middleBottleSlot);
        this.addSlot((Slot)rightBottleSlot);
        this.addSlot((Slot)overclockerSlot);
        this.addSlot((Slot)chorusSlot);
    }

    public void handleButtonPressed(int buttonId) {
        if (buttonId == 0) {
            boolean newTemperature = !this.isHighTemperature();
            this.setIsHighTemperature(newTemperature);
        }
    }

    private static final boolean addSlots$lambda$0(AdvancedIncubatorMenu this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractIncubatorRecipe.Companion.isValidTopIngredient(this$0.getLevel(), it);
    }

    private static final boolean addSlots$lambda$1(AdvancedIncubatorMenu this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractIncubatorRecipe.Companion.isValidBottomIngredient(this$0.getLevel(), it);
    }

    private static final boolean addSlots$lambda$2(AdvancedIncubatorMenu this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractIncubatorRecipe.Companion.isValidBottomIngredient(this$0.getLevel(), it);
    }

    private static final boolean addSlots$lambda$3(AdvancedIncubatorMenu this$0, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AbstractIncubatorRecipe.Companion.isValidBottomIngredient(this$0.getLevel(), it);
    }

    private static final boolean addSlots$lambda$4(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Item item = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"CHORUS_FRUIT");
        return AaronExtensions.INSTANCE.isItem(it, item);
    }

    private static final boolean addSlots$lambda$5(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AaronExtensions.INSTANCE.isItem(it, (Holder)ModItems.INSTANCE.getOVERCLOCKER());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/advanced_incubator/AdvancedIncubatorMenu$Companion;", "", "<init>", "()V", "CYCLE_TEMPERATURE_BUTTON_ID", "", "showChanceTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void showChanceTooltip(@NotNull ItemTooltipEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Level level = AaronClientUtil.getLocalLevel();
            if (level == null) {
                return;
            }
            Level level2 = level;
            ItemStack potionStack = event.getItemStack();
            Intrinsics.checkNotNull((Object)potionStack);
            Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(potionStack);
            if (holder == null) {
                return;
            }
            Holder<Potion> potion = holder;
            if (!Intrinsics.areEqual(potion, ModPotions.INSTANCE.getCELL_GROWTH()) && !Intrinsics.areEqual(potion, ModPotions.INSTANCE.getMUTATION())) {
                return;
            }
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            Player player2 = player;
            AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
            AdvancedIncubatorMenu advancedIncubatorMenu = abstractContainerMenu instanceof AdvancedIncubatorMenu ? (AdvancedIncubatorMenu)abstractContainerMenu : null;
            if (advancedIncubatorMenu == null) {
                return;
            }
            AdvancedIncubatorMenu menu = advancedIncubatorMenu;
            ItemStack topStack = menu.getMachineContainer().getItem(0);
            Intrinsics.checkNotNull((Object)topStack);
            GmoRecipe gmoRecipe = GmoRecipe.Companion.getGmoRecipe(level2, topStack, potionStack, menu.isHighTemperature());
            if (gmoRecipe == null) {
                return;
            }
            GmoRecipe recipe = gmoRecipe;
            float chanceDecreasePerOverclocker = (float)((Number)ServerConfig.Companion.getCONFIG().getIncubatorOverclockerChanceDecrease().get()).doubleValue();
            float chanceIncreasePerChorus = (float)((Number)ServerConfig.Companion.getCONFIG().getIncubatorChorusFruitChanceIncrease().get()).doubleValue();
            float baseChance = recipe.getGeneChance();
            int amountOverclockers = menu.getMachineContainer().getItem(5).getCount();
            float overclockerChanceFactor = 1.0f - (float)amountOverclockers * chanceDecreasePerOverclocker;
            float reducedChance = RangesKt.coerceIn((float)(baseChance * overclockerChanceFactor), (float)0.0f, (float)1.0f);
            int chorusRequiredForMaxChance = Mth.ceil((float)((1.0f - reducedChance) / chanceIncreasePerChorus));
            int chorusAvailable = menu.getMachineContainer().getItem(4).getCount();
            int chorusUsed = Math.min(chorusRequiredForMaxChance, chorusAvailable);
            float chorusBoost = (float)chorusUsed * chanceIncreasePerChorus;
            float finalChance = reducedChance + chorusBoost;
            int index = event.getToolTip().size();
            event.getToolTip().add(index++, CommonComponents.EMPTY);
            int n = index++;
            Object[] objectArray = new Object[]{Gene.Companion.getNameComponent$default(Gene.Companion, recipe.getIdealGeneRk(), null, 2, null), (int)(baseChance * (float)100)};
            event.getToolTip().add(n, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.chance", objectArray).withStyle(ChatFormatting.GRAY));
            if (amountOverclockers != 0) {
                int n2 = index++;
                objectArray = new Object[]{amountOverclockers, (int)(reducedChance * (float)100)};
                event.getToolTip().add(n2, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.overclocker", objectArray).withStyle(ChatFormatting.GRAY));
            }
            if (chorusUsed != 0) {
                objectArray = new Object[]{chorusUsed, (int)(finalChance * (float)100)};
                event.getToolTip().add(index, ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gmo.chorus", objectArray).withStyle(ChatFormatting.GRAY));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

