/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.menu.components;

import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.Arrays;
import java.util.function.IntSupplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/components/EnergyBar;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "x", "", "y", "maxGetter", "Ljava/util/function/IntSupplier;", "currentGetter", "font", "Lnet/minecraft/client/gui/Font;", "<init>", "(IILjava/util/function/IntSupplier;Ljava/util/function/IntSupplier;Lnet/minecraft/client/gui/Font;)V", "getMaxGetter", "()Ljava/util/function/IntSupplier;", "getCurrentGetter", "getFont", "()Lnet/minecraft/client/gui/Font;", "renderWidget", "", "pGuiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "pMouseX", "pMouseY", "pPartialTick", "", "renderTooltip", "updateWidgetNarration", "pNarrationElementOutput", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "Companion", "geneticsresequenced-1.21.1"})
public final class EnergyBar
extends AbstractWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntSupplier maxGetter;
    @NotNull
    private final IntSupplier currentGetter;
    @NotNull
    private final Font font;
    public static final int WIDTH = 18;
    public static final int HEIGHT = 57;
    public static final int TEXTURE_SIZE = 64;
    @NotNull
    private static final ResourceLocation TEXTURE = OtherUtil.INSTANCE.modResource("energy");

    public EnergyBar(int x, int y, @NotNull IntSupplier maxGetter, @NotNull IntSupplier currentGetter, @NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)maxGetter, (String)"maxGetter");
        Intrinsics.checkNotNullParameter((Object)currentGetter, (String)"currentGetter");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        super(x, y, 18, 57, (Component)Component.empty());
        this.maxGetter = maxGetter;
        this.currentGetter = currentGetter;
        this.font = font;
    }

    @NotNull
    public final IntSupplier getMaxGetter() {
        return this.maxGetter;
    }

    @NotNull
    public final IntSupplier getCurrentGetter() {
        return this.currentGetter;
    }

    @NotNull
    public final Font getFont() {
        return this.font;
    }

    protected void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Intrinsics.checkNotNullParameter((Object)pGuiGraphics, (String)"pGuiGraphics");
        float percentFull = (float)this.currentGetter.getAsInt() / (float)this.maxGetter.getAsInt();
        int energyTotalHeight = this.height;
        int energyCurrentHeight = Mth.ceil((double)((double)energyTotalHeight * (double)percentFull));
        pGuiGraphics.blitSprite(TEXTURE, 64, 64, 0, energyTotalHeight - energyCurrentHeight, this.getX(), this.getY() + energyTotalHeight - energyCurrentHeight, 64, energyCurrentHeight);
        if (this.isHovered) {
            this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        }
    }

    private final void renderTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        String string = "%,d";
        Object[] objectArray = new Object[]{this.currentGetter.getAsInt()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String currentAmountString = string2;
        objectArray = "%,d";
        Object[] objectArray2 = new Object[]{this.maxGetter.getAsInt()};
        String string3 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String maxAmountString = string3;
        objectArray = new Object[]{currentAmountString, maxAmountString};
        MutableComponent component = ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.fe", objectArray);
        pGuiGraphics.renderComponentTooltip(this.font, CollectionsKt.listOf((Object)component), pMouseX, pMouseY);
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)pNarrationElementOutput, (String)"pNarrationElementOutput");
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/components/EnergyBar$Companion;", "", "<init>", "()V", "WIDTH", "", "HEIGHT", "TEXTURE_SIZE", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "getTEXTURE", "()Lnet/minecraft/resources/ResourceLocation;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getTEXTURE() {
            return TEXTURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

