/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.menu.plasmid_infuser;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.aaron.menu.components.FilteredSlot;
import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.PlasmidItem;
import dev.aaronhowser.mods.geneticsresequenced.menu.CraftingMachineMenu;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModDataComponents;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModMenuTypes;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/plasmid_infuser/PlasmidInfuserMenu;", "Ldev/aaronhowser/mods/geneticsresequenced/menu/CraftingMachineMenu;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "machineContainer", "Lnet/minecraft/world/Container;", "craftingContainerData", "Lnet/minecraft/world/inventory/ContainerData;", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/inventory/ContainerData;)V", "(ILnet/minecraft/world/entity/player/Inventory;)V", "inputFilter", "", "inputStack", "Lnet/minecraft/world/item/ItemStack;", "addSlots", "", "Companion", "geneticsresequenced-1.21.1"})
public final class PlasmidInfuserMenu
extends CraftingMachineMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PlasmidInfuserMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Container machineContainer, @NotNull ContainerData craftingContainerData) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)machineContainer, (String)"machineContainer");
        Intrinsics.checkNotNullParameter((Object)craftingContainerData, (String)"craftingContainerData");
        Object object = ModMenuTypes.INSTANCE.getPLASMID_INFUSER().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        super((MenuType)object, containerId, playerInventory, machineContainer, craftingContainerData);
        this.addSlots();
    }

    public PlasmidInfuserMenu(int containerId, @NotNull Inventory playerInventory) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        this(containerId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    @Override
    protected boolean inputFilter(@NotNull ItemStack inputStack) {
        Intrinsics.checkNotNullParameter((Object)inputStack, (String)"inputStack");
        return AaronExtensions.INSTANCE.isItem(inputStack, (Holder)ModItems.INSTANCE.getDNA_HELIX()) && inputStack.has((Supplier)ModDataComponents.INSTANCE.getGENE());
    }

    @Override
    public void addSlots() {
        FilteredSlot helixSlot2 = new FilteredSlot(this.getMachineContainer(), 0, 63, 42, (Function1)new Function1<ItemStack, Boolean>((Object)this){

            public final Boolean invoke(ItemStack p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PlasmidInfuserMenu)((Object)this.receiver)).inputFilter(p0);
            }
        });
        FilteredSlot plasmidSlot2 = new FilteredSlot(this.getMachineContainer(), 1, 110, 42, PlasmidInfuserMenu::addSlots$lambda$0);
        FilteredSlot overclockSlot = new FilteredSlot(this.getMachineContainer(), 2, 26, 54, PlasmidInfuserMenu::addSlots$lambda$1);
        this.addSlot((Slot)helixSlot2);
        this.addSlot((Slot)plasmidSlot2);
        this.addSlot((Slot)overclockSlot);
    }

    private static final boolean addSlots$lambda$0(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AaronExtensions.INSTANCE.isItem(it, (Holder)ModItems.INSTANCE.getPLASMID());
    }

    private static final boolean addSlots$lambda$1(ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AaronExtensions.INSTANCE.isItem(it, (Holder)ModItems.INSTANCE.getOVERCLOCKER());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/menu/plasmid_infuser/PlasmidInfuserMenu$Companion;", "", "<init>", "()V", "showTooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "addAntiPlasmidTooltip", "addHelixTooltip", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void showTooltip(@NotNull ItemTooltipEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ItemStack hoverStack = event.getItemStack();
            if (hoverStack.isEmpty()) {
                return;
            }
            Intrinsics.checkNotNull((Object)hoverStack);
            if (AaronExtensions.INSTANCE.isItem(hoverStack, (Holder)ModItems.INSTANCE.getDNA_HELIX())) {
                this.addHelixTooltip(event);
            } else if (AaronExtensions.INSTANCE.isItem(hoverStack, (Holder)ModItems.INSTANCE.getANTI_PLASMID())) {
                this.addAntiPlasmidTooltip(event);
            }
        }

        private final void addAntiPlasmidTooltip(ItemTooltipEvent event) {
            ItemStack itemStack = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            if (PlasmidItem.Companion.getGene(itemStack) != null) {
                return;
            }
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid_infuser.anti_plasmid_1", new Object[0]).withStyle(ChatFormatting.RED));
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid_infuser.anti_plasmid_2", new Object[0]).withStyle(ChatFormatting.RED));
        }

        private final void addHelixTooltip(ItemTooltipEvent event) {
            ItemStack hoverStack = event.getItemStack();
            Intrinsics.checkNotNull((Object)hoverStack);
            Holder<Gene> holder = DnaHelixItem.Companion.getGeneHolder(hoverStack);
            if (holder == null) {
                return;
            }
            Holder<Gene> hoveredGeneHolder = holder;
            Player player = event.getEntity();
            if (player == null || (player = player.containerMenu) == null || (player = player.slots) == null) {
                return;
            }
            Player slots = player;
            int plasmidSlotId = 37;
            Slot slot = (Slot)CollectionsKt.getOrNull((List)((List)slots), (int)plasmidSlotId);
            if (slot == null || (slot = slot.getItem()) == null) {
                return;
            }
            Slot outputItem = slot;
            Holder<Gene> holder2 = PlasmidItem.Companion.getGene((ItemStack)outputItem);
            if (holder2 == null) {
                return;
            }
            Holder<Gene> outputGene = holder2;
            MutableComponent component = (Gene.Companion.isGene(hoveredGeneHolder, ModGenes.INSTANCE.getBASIC()) ? ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid_infuser.basic_gene", new Object[0]) : (Gene.Companion.isGene(hoveredGeneHolder, outputGene) ? ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid_infuser.matching_gene", new Object[0]) : ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.plasmid_infuser.different_gene", new Object[0]))).withStyle(ChatFormatting.GRAY);
            event.getToolTip().add(2, component);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

