/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.mixin;

import dev.aaronhowser.mods.geneticsresequenced.registry.ModAttributes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={EnchantedCountIncreaseFunction.class})
public abstract class EnchantedCountIncreaseFunctionMixin {
    @ModifyVariable(method={"run"}, at=@At(value="STORE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;getEnchantmentLevel(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/LivingEntity;)I"))
    private int modifyEnchantmentLevel(int originalLevel, ItemStack stack, LootContext context) {
        Entity target = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        double bountifulLevel = 0.0;
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            bountifulLevel = le.getAttributeValue(ModAttributes.BASE_LOOTING);
        }
        return originalLevel + Mth.ceil((double)bountifulLevel);
    }
}

