/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client;

import dev.aaronhowser.mods.aaron.packet.AaronPacket;
import dev.aaronhowser.mods.geneticsresequenced.attachment.GenesData;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.packet.server_to_client.GeneChangedPacket;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.util.ClientUtil;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J-\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket;", "Ldev/aaronhowser/mods/aaron/packet/AaronPacket;", "entityId", "", "geneHolder", "Lnet/minecraft/core/Holder;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "wasAdded", "", "<init>", "(ILnet/minecraft/core/Holder;Z)V", "getEntityId", "()I", "getGeneHolder", "()Lnet/minecraft/core/Holder;", "getWasAdded", "()Z", "handleOnClient", "", "context", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "type", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "geneticsresequenced-1.21.1"})
public final class GeneChangedPacket
extends AaronPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int entityId;
    @NotNull
    private final Holder<Gene> geneHolder;
    private final boolean wasAdded;
    @NotNull
    private static final CustomPacketPayload.Type<GeneChangedPacket> TYPE = new CustomPacketPayload.Type(OtherUtil.INSTANCE.modResource("gene_changed"));
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, GeneChangedPacket> STREAM_CODEC;

    public GeneChangedPacket(int entityId, @NotNull Holder<Gene> geneHolder, boolean wasAdded) {
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        this.entityId = entityId;
        this.geneHolder = geneHolder;
        this.wasAdded = wasAdded;
    }

    public final int getEntityId() {
        return this.entityId;
    }

    @NotNull
    public final Holder<Gene> getGeneHolder() {
        return this.geneHolder;
    }

    public final boolean getWasAdded() {
        return this.wasAdded;
    }

    protected void handleOnClient(@NotNull IPayloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level level = context.player().level();
        Entity entity = level.getEntity(this.entityId);
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity == null) {
            return;
        }
        LivingEntity entity2 = livingEntity;
        boolean bl = this.wasAdded ? GenesData.Companion.addGene(entity2, this.geneHolder) : GenesData.Companion.removeGene(entity2, this.geneHolder);
        if (Gene.Companion.isGene(this.geneHolder, ModGenes.CRINGE)) {
            ClientUtil.handleCringe$default(ClientUtil.INSTANCE, this.wasAdded, 0, 2, null);
        }
        ((Gene)this.geneHolder.value()).setAttributeModifiers(entity2, this.wasAdded);
    }

    @NotNull
    public CustomPacketPayload.Type<GeneChangedPacket> type() {
        return TYPE;
    }

    public final int component1() {
        return this.entityId;
    }

    @NotNull
    public final Holder<Gene> component2() {
        return this.geneHolder;
    }

    public final boolean component3() {
        return this.wasAdded;
    }

    @NotNull
    public final GeneChangedPacket copy(int entityId, @NotNull Holder<Gene> geneHolder, boolean wasAdded) {
        Intrinsics.checkNotNullParameter(geneHolder, (String)"geneHolder");
        return new GeneChangedPacket(entityId, geneHolder, wasAdded);
    }

    public static /* synthetic */ GeneChangedPacket copy$default(GeneChangedPacket geneChangedPacket, int n, Holder holder, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = geneChangedPacket.entityId;
        }
        if ((n2 & 2) != 0) {
            holder = geneChangedPacket.geneHolder;
        }
        if ((n2 & 4) != 0) {
            bl = geneChangedPacket.wasAdded;
        }
        return geneChangedPacket.copy(n, holder, bl);
    }

    @NotNull
    public String toString() {
        return "GeneChangedPacket(entityId=" + this.entityId + ", geneHolder=" + this.geneHolder + ", wasAdded=" + this.wasAdded + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.entityId);
        result = result * 31 + this.geneHolder.hashCode();
        result = result * 31 + Boolean.hashCode(this.wasAdded);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeneChangedPacket)) {
            return false;
        }
        GeneChangedPacket geneChangedPacket = (GeneChangedPacket)((Object)other);
        if (this.entityId != geneChangedPacket.entityId) {
            return false;
        }
        if (!Intrinsics.areEqual(this.geneHolder, geneChangedPacket.geneHolder)) {
            return false;
        }
        return this.wasAdded == geneChangedPacket.wasAdded;
    }

    private static final Integer STREAM_CODEC$lambda$0(KProperty1 $tmp0, GeneChangedPacket p0) {
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Holder STREAM_CODEC$lambda$1(KProperty1 $tmp0, GeneChangedPacket p0) {
        return (Holder)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean STREAM_CODEC$lambda$2(KProperty1 $tmp0, GeneChangedPacket p0) {
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$0((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), Gene.Companion.getSTREAM_CODEC(), arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$1((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.BOOL, arg_0 -> GeneChangedPacket.STREAM_CODEC$lambda$2((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), GeneChangedPacket::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket$Companion;", "", "<init>", "()V", "TYPE", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/aaronhowser/mods/geneticsresequenced/packet/server_to_client/GeneChangedPacket;", "getTYPE", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<GeneChangedPacket> getTYPE() {
            return TYPE;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, GeneChangedPacket> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

