/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe;

import dev.aaronhowser.mods.geneticsresequenced.datagen.lang.ModLanguageProvider;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.item.EntityDnaItem;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020 R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u001d\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/BrewingRecipes;", "", "<init>", "()V", "modPotions", "", "Lnet/minecraft/world/item/alchemy/Potion;", "getModPotions", "()Ljava/util/List;", "tooltip", "", "event", "Lnet/neoforged/neoforge/event/entity/player/ItemTooltipEvent;", "ingredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "potion", "Lnet/minecraft/core/Holder;", "itemLike", "Lnet/minecraft/world/level/ItemLike;", "substratePotionStack", "Lnet/minecraft/world/item/ItemStack;", "getSubstratePotionStack", "()Lnet/minecraft/world/item/ItemStack;", "cellGrowthPotionStack", "getCellGrowthPotionStack", "mutationPotionStack", "getMutationPotionStack", "viralAgentsPotionStack", "getViralAgentsPotionStack", "panaceaPotionStack", "getPanaceaPotionStack", "setRecipes", "Lnet/neoforged/neoforge/event/brewing/RegisterBrewingRecipesEvent;", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBrewingRecipes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrewingRecipes.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/BrewingRecipes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1563#2:114\n1634#2,3:115\n*S KotlinDebug\n*F\n+ 1 BrewingRecipes.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/BrewingRecipes\n*L\n27#1:114\n27#1:115,3\n*E\n"})
public final class BrewingRecipes {
    @NotNull
    public static final BrewingRecipes INSTANCE = new BrewingRecipes();

    private BrewingRecipes() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<Potion> getModPotions() {
        void $this$mapTo$iv$iv;
        Collection collection = ModPotions.INSTANCE.getPOTION_REGISTRY().getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntries(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeferredHolder deferredHolder = (DeferredHolder)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((Potion)it.get());
        }
        return (List)destination$iv$iv;
    }

    public final void tooltip(@NotNull ItemTooltipEvent event) {
        EntityType<?> itemEntity;
        Holder<Gene> itemGeneHolder;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ItemStack stack = event.getItemStack();
        Intrinsics.checkNotNull((Object)stack);
        Holder<Potion> holder = OtherUtil.INSTANCE.getPotion(stack);
        if (holder == null) {
            return;
        }
        Holder<Potion> itemPotion = holder;
        if (Intrinsics.areEqual(itemPotion, ModPotions.INSTANCE.getZOMBIFY_VILLAGER()) || Intrinsics.areEqual(itemPotion, ModPotions.INSTANCE.getPANACEA())) {
            return;
        }
        if (!this.getModPotions().contains(itemPotion.value())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)stack.getItem(), (Object)Items.POTION)) {
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.potion.ignore", new Object[0]).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
        if ((itemGeneHolder = DnaHelixItem.Companion.getGeneHolder(stack)) != null) {
            Object[] objectArray = new Object[]{Gene.Companion.getNameComponent(itemGeneHolder).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY))};
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.gene", objectArray));
        }
        if ((itemEntity = EntityDnaItem.Companion.getEntityType(stack)) != null) {
            Object[] objectArray = new Object[]{itemEntity.getDescription()};
            event.getToolTip().add(ModLanguageProvider.Companion.toComponent("tooltip.geneticsresequenced.helix_entity", objectArray).withStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        }
    }

    private final Ingredient ingredient(Holder<Potion> potion) {
        Ingredient ingredient = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack(potion));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    private final Ingredient ingredient(ItemLike itemLike) {
        ItemLike[] itemLikeArray = new ItemLike[]{itemLike};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    @NotNull
    public final ItemStack getSubstratePotionStack() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getSUBSTRATE()));
    }

    @NotNull
    public final ItemStack getCellGrowthPotionStack() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getCELL_GROWTH()));
    }

    @NotNull
    public final ItemStack getMutationPotionStack() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getMUTATION()));
    }

    @NotNull
    public final ItemStack getViralAgentsPotionStack() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getVIRAL_AGENTS()));
    }

    @NotNull
    public final ItemStack getPanaceaPotionStack() {
        return OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getPANACEA()));
    }

    public final void setRecipes(@NotNull RegisterBrewingRecipesEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Holder holder = Potions.MUNDANE;
        Intrinsics.checkNotNullExpressionValue((Object)holder, (String)"MUNDANE");
        BrewingRecipe substrateRecipe = new BrewingRecipe(this.ingredient((Holder<Potion>)holder), this.ingredient((ItemLike)ModItems.INSTANCE.getORGANIC_MATTER()), this.getSubstratePotionStack());
        Ingredient ingredient = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getCELL_GROWTH()));
        Item item = Items.FERMENTED_SPIDER_EYE;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"FERMENTED_SPIDER_EYE");
        BrewingRecipe mutationRecipe = new BrewingRecipe(ingredient, this.ingredient((ItemLike)item), this.getMutationPotionStack());
        Ingredient ingredient2 = this.ingredient((Holder<Potion>)((Holder)ModPotions.INSTANCE.getMUTATION()));
        Item item2 = Items.CHORUS_FRUIT;
        Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"CHORUS_FRUIT");
        BrewingRecipe viralRecipe = new BrewingRecipe(ingredient2, this.ingredient((ItemLike)item2), this.getViralAgentsPotionStack());
        BrewingRecipe[] brewingRecipeArray = new BrewingRecipe[]{substrateRecipe, mutationRecipe, viralRecipe};
        List allRecipes = CollectionsKt.listOf((Object[])brewingRecipeArray);
        for (BrewingRecipe recipe : allRecipes) {
            event.getBuilder().addRecipe((IBrewingRecipe)recipe);
        }
    }
}

