/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.base;

import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeTypes;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "topIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "bottomIngredient", "<init>", "(Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/crafting/Ingredient;)V", "getTopIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getBottomIngredient", "canCraftInDimensions", "", "p0", "", "p1", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "getIngredients", "Lnet/minecraft/core/NonNullList;", "Companion", "geneticsresequenced-1.21.1"})
public abstract class AbstractIncubatorRecipe
implements Recipe<IncubatorRecipeInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ingredient topIngredient;
    @NotNull
    private final Ingredient bottomIngredient;

    public AbstractIncubatorRecipe(@NotNull Ingredient topIngredient, @NotNull Ingredient bottomIngredient) {
        Intrinsics.checkNotNullParameter((Object)topIngredient, (String)"topIngredient");
        Intrinsics.checkNotNullParameter((Object)bottomIngredient, (String)"bottomIngredient");
        this.topIngredient = topIngredient;
        this.bottomIngredient = bottomIngredient;
    }

    @NotNull
    public final Ingredient getTopIngredient() {
        return this.topIngredient;
    }

    @NotNull
    public final Ingredient getBottomIngredient() {
        return this.bottomIngredient;
    }

    public boolean canCraftInDimensions(int p0, int p1) {
        return true;
    }

    @NotNull
    public final RecipeType<?> getType() {
        Object object = ModRecipeTypes.INSTANCE.getINCUBATOR().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.topIngredient);
        list.add((Object)this.bottomIngredient);
        Intrinsics.checkNotNull((Object)list);
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe$Companion;", "", "<init>", "()V", "getIncubatorRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "isValidTopIngredient", "", "level", "Lnet/minecraft/world/level/Level;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "isValidBottomIngredient", "getIncubatorRecipe", "incubatorRecipeInput", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "hasIncubatorRecipe", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nAbstractIncubatorRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractIncubatorRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1761#2,3:71\n1761#2,3:74\n*S KotlinDebug\n*F\n+ 1 AbstractIncubatorRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe$Companion\n*L\n36#1:71,3\n46#1:74,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<RecipeHolder<AbstractIncubatorRecipe>> getIncubatorRecipes(@NotNull RecipeManager recipeManager) {
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List list = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.INSTANCE.getINCUBATOR().get());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isValidTopIngredient(@NotNull Level level, @NotNull ItemStack itemStack) {
            boolean bl;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                RecipeManager recipeManager = level.getRecipeManager();
                Intrinsics.checkNotNullExpressionValue((Object)recipeManager, (String)"getRecipeManager(...)");
                Iterable iterable = this.getIncubatorRecipes(recipeManager);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RecipeHolder recipeHolder = (RecipeHolder)element$iv;
                        boolean bl2 = false;
                        if (!((AbstractIncubatorRecipe)recipeHolder.value()).getTopIngredient().test(itemStack)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean usedInIncubatorRecipe = bl;
            boolean usedInBrewingRecipe = level.potionBrewing().isIngredient(itemStack);
            return usedInIncubatorRecipe || usedInBrewingRecipe;
        }

        public final boolean isValidBottomIngredient(@NotNull Level level, @NotNull ItemStack itemStack) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
                RecipeManager recipeManager = level.getRecipeManager();
                Intrinsics.checkNotNullExpressionValue((Object)recipeManager, (String)"getRecipeManager(...)");
                Iterable $this$any$iv = this.getIncubatorRecipes(recipeManager);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        RecipeHolder recipeHolder = (RecipeHolder)element$iv;
                        boolean bl2 = false;
                        if (!((AbstractIncubatorRecipe)recipeHolder.value()).getBottomIngredient().test(itemStack)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean usedInIncubatorRecipe = bl;
            boolean usedInBrewingRecipe = level.potionBrewing().isInput(itemStack);
            return usedInIncubatorRecipe || usedInBrewingRecipe;
        }

        @Nullable
        public final AbstractIncubatorRecipe getIncubatorRecipe(@NotNull Level level, @NotNull IncubatorRecipeInput incubatorRecipeInput) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)incubatorRecipeInput, (String)"incubatorRecipeInput");
                RecipeManager recipeManager = level.getRecipeManager();
                Intrinsics.checkNotNullExpressionValue((Object)recipeManager, (String)"getRecipeManager(...)");
                Iterable iterable = this.getIncubatorRecipes(recipeManager);
                for (Object t : iterable) {
                    RecipeHolder recipeHolder = (RecipeHolder)t;
                    boolean bl = false;
                    if (!((AbstractIncubatorRecipe)recipeHolder.value()).matches(incubatorRecipeInput, level)) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            RecipeHolder recipeHolder = v1;
            return recipeHolder != null ? (AbstractIncubatorRecipe)recipeHolder.value() : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasIncubatorRecipe(@NotNull Level level, @NotNull IncubatorRecipeInput incubatorRecipeInput) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)incubatorRecipeInput, (String)"incubatorRecipeInput");
            if (this.getIncubatorRecipe(level, incubatorRecipeInput) != null) return true;
            PotionBrewing potionBrewing = level.potionBrewing();
            Intrinsics.checkNotNullExpressionValue((Object)potionBrewing, (String)"potionBrewing(...)");
            if (!incubatorRecipeInput.isValidPotionRecipe(potionBrewing)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

