/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.recipe.incubator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.item.DnaHelixItem;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.AbstractIncubatorRecipe;
import dev.aaronhowser.mods.geneticsresequenced.recipe.base.IncubatorRecipeInput;
import dev.aaronhowser.mods.geneticsresequenced.recipe.incubator.VirusRecipe;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModGenes;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModItems;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModPotions;
import dev.aaronhowser.mods.geneticsresequenced.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/AbstractIncubatorRecipe;", "inputDnaGene", "Lnet/minecraft/resources/ResourceKey;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "outputGene", "<init>", "(Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/resources/ResourceKey;)V", "getInputDnaGene", "()Lnet/minecraft/resources/ResourceKey;", "getOutputGene", "matches", "", "input", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/base/IncubatorRecipeInput;", "level", "Lnet/minecraft/world/level/Level;", "assemble", "Lnet/minecraft/world/item/ItemStack;", "lookup", "Lnet/minecraft/core/HolderLookup$Provider;", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Serializer", "Companion", "geneticsresequenced-1.21.1"})
public final class VirusRecipe
extends AbstractIncubatorRecipe {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceKey<Gene> inputDnaGene;
    @NotNull
    private final ResourceKey<Gene> outputGene;

    public VirusRecipe(@NotNull ResourceKey<Gene> inputDnaGene, @NotNull ResourceKey<Gene> outputGene) {
        Intrinsics.checkNotNullParameter(inputDnaGene, (String)"inputDnaGene");
        Intrinsics.checkNotNullParameter(outputGene, (String)"outputGene");
        ItemLike[] itemLikeArray = new ItemLike[]{ModItems.INSTANCE.getDNA_HELIX().get()};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        Ingredient ingredient2 = DataComponentIngredient.of((boolean)false, (ItemStack)OtherUtil.INSTANCE.getPotionStack((Holder<Potion>)((Holder)ModPotions.INSTANCE.getVIRAL_AGENTS())));
        Intrinsics.checkNotNullExpressionValue((Object)ingredient2, (String)"of(...)");
        super(ingredient, ingredient2);
        this.inputDnaGene = inputDnaGene;
        this.outputGene = outputGene;
    }

    @NotNull
    public final ResourceKey<Gene> getInputDnaGene() {
        return this.inputDnaGene;
    }

    @NotNull
    public final ResourceKey<Gene> getOutputGene() {
        return this.outputGene;
    }

    public boolean matches(@NotNull IncubatorRecipeInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack helixStack = input.getTopItem();
        ItemStack potionStack = input.getBottomItem();
        if (!this.getTopIngredient().test(helixStack)) {
            return false;
        }
        if (!this.getBottomIngredient().test(potionStack)) {
            return false;
        }
        return Gene.Companion.isGene(DnaHelixItem.Companion.getGeneHolder(helixStack), this.inputDnaGene);
    }

    @NotNull
    public ItemStack assemble(@NotNull IncubatorRecipeInput input, @NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        return this.getResultItem(lookup);
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        ItemStack itemStack = ModItems.INSTANCE.getDNA_HELIX().toStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"toStack(...)");
        ItemStack output = DnaHelixItem.Companion.setGeneHolder(itemStack, (Holder<Gene>)((Holder)ModGenes.INSTANCE.getHolderOrThrow(this.outputGene, lookup)));
        return output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getVIRUS().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe$Companion;", "", "<init>", "()V", "getVirusRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "geneticsresequenced-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nVirusRecipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirusRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1617#2,9:107\n1869#2:116\n1870#2:118\n1626#2:119\n1#3:117\n*S KotlinDebug\n*F\n+ 1 VirusRecipe.kt\ndev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe$Companion\n*L\n102#1:107,9\n102#1:116\n102#1:118\n102#1:119\n102#1:117\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<RecipeHolder<VirusRecipe>> getVirusRecipes(@NotNull RecipeManager recipeManager) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List<RecipeHolder<AbstractIncubatorRecipe>> incubatorRecipes = AbstractIncubatorRecipe.Companion.getIncubatorRecipes(recipeManager);
            Iterable $this$mapNotNull$iv = incubatorRecipes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RecipeHolder it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                RecipeHolder it = (RecipeHolder)element$iv$iv;
                boolean bl2 = false;
                if ((it.value() instanceof VirusRecipe ? (it instanceof RecipeHolder ? it : null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "geneticsresequenced-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<VirusRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<VirusRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, VirusRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<VirusRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, VirusRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final ResourceKey CODEC$lambda$2$lambda$0(KProperty1 $tmp0, VirusRecipe p0) {
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ResourceKey CODEC$lambda$2$lambda$1(KProperty1 $tmp0, VirusRecipe p0) {
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
            return instance.group((App)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()).fieldOf("input_gene").forGetter(arg_0 -> Serializer.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)ResourceKey.codec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()).fieldOf("output_gene").forGetter(arg_0 -> Serializer.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, VirusRecipe::new);
        }

        private static final ResourceKey STREAM_CODEC$lambda$3(KProperty1 $tmp0, VirusRecipe p0) {
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ResourceKey STREAM_CODEC$lambda$4(KProperty1 $tmp0, VirusRecipe p0) {
            return (ResourceKey)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()), arg_0 -> Serializer.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ResourceKey.streamCodec(ModGenes.INSTANCE.getGENE_REGISTRY_KEY()), arg_0 -> Serializer.STREAM_CODEC$lambda$4((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), VirusRecipe::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/geneticsresequenced/recipe/incubator/VirusRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "geneticsresequenced-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<VirusRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, VirusRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

