/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.registry;

import dev.aaronhowser.mods.geneticsresequenced.gene.Gene;
import dev.aaronhowser.mods.geneticsresequenced.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\bf\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J&\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u0007J \u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J \u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0019H\u0007J.\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00170\u001d2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u001fJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\"\u001a\u00020\u0019H\u0002J!\u0010\u0083\u0001\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010*\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\f\u001a\u00020\rR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\tR\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010^\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010h\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010l\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010o\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010w\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010x\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010z\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010{\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010}\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010~\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/registry/ModGenes;", "", "<init>", "()V", "GENE_REGISTRY_KEY", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/core/Registry;", "Ldev/aaronhowser/mods/geneticsresequenced/gene/Gene;", "getGENE_REGISTRY_KEY", "()Lnet/minecraft/resources/ResourceKey;", "getGeneRegistry", "Lnet/minecraft/core/HolderLookup$RegistryLookup;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getAllGeneHolders", "Ljava/util/stream/Stream;", "Lnet/minecraft/core/Holder$Reference;", "fromResourceKey", "rk", "fromResourceLocation", "rl", "Lnet/minecraft/resources/ResourceLocation;", "fromString", "Lnet/minecraft/core/Holder;", "id", "", "fromIdPath", "path", "getRegistrySorted", "", "includeHelixOnly", "", "includeDisabled", "resourceKey", "geneName", "BASIC", "getBASIC", "BIOLUMINESCENCE", "CHATTERBOX", "CHILLING", "CLAWS", "DRAGON_BREATH", "EAT_GRASS", "EFFICIENCY", "EMERALD_HEART", "ENDER_DRAGON_HEALTH", "EXPLOSIVE_EXIT", "FIRE_PROOF", "HASTE", "INFINITY", "INVISIBLE", "ITEM_MAGNET", "JUMP_BOOST", "JOHNNY", "KEEP_INVENTORY", "KNOCKBACK", "LAY_EGG", "LUCK", "MEATY", "MILKY", "MOB_SIGHT", "MORE_HEARTS", "NIGHT_VISION", "NO_FALL_DAMAGE", "NO_HUNGER", "POISON_IMMUNITY", "REGENERATION", "REACHING", "RESISTANCE", "SCARE_CREEPERS", "SCARE_SKELETONS", "SHOOT_FIREBALLS", "SLIMY_DEATH", "SPEED", "STEP_ASSIST", "STRENGTH", "TELEPORT", "THORNS", "WALL_CLIMBING", "WATER_BREATHING", "WEB_DEFENSE", "WEB_WALKER", "WITHER_HIT", "WITHER_PROOF", "WOOLY", "XP_MAGNET", "BOUNTIFUL", "BOUNTIFUL_TWO", "EXPERIENCED", "FERTILE", "FRENZIED", "PLACID", "CLAWS_TWO", "EFFICIENCY_FOUR", "FLIGHT", "HASTE_TWO", "MEATY_TWO", "MORE_HEARTS_TWO", "PHOTOSYNTHESIS", "REGENERATION_FOUR", "RESISTANCE_TWO", "SPEED_FOUR", "SPEED_TWO", "STRENGTH_TWO", "SCARE_ZOMBIES", "SCARE_SPIDERS", "LAVA_PROOF", "BLINDNESS", "CRINGE", "CURSED", "FLAMBE", "HUNGER", "INFESTED", "LEVITATION", "MINING_FATIGUE", "NAUSEA", "OOZING", "POISON", "POISON_FOUR", "SLOWNESS", "SLOWNESS_FOUR", "SLOWNESS_SIX", "WEAVING", "WEAKNESS", "WIND_CHARGED", "WITHER", "BLACK_DEATH", "GREEN_DEATH", "WHITE_DEATH", "GRAY_DEATH", "UN_UNDEATH", "getHolder", "getHolderOrThrow", "geneticsresequenced-1.21.1"})
@SourceDebugExtension(value={"SMAP\nModGenes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/registry/ModGenes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1056#2:199\n*S KotlinDebug\n*F\n+ 1 ModGenes.kt\ndev/aaronhowser/mods/geneticsresequenced/registry/ModGenes\n*L\n72#1:199\n*E\n"})
public final class ModGenes {
    @NotNull
    public static final ModGenes INSTANCE = new ModGenes();
    @NotNull
    private static final ResourceKey<Registry<Gene>> GENE_REGISTRY_KEY;
    @NotNull
    private static final ResourceKey<Gene> BASIC;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> BIOLUMINESCENCE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CHATTERBOX;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CHILLING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CLAWS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> DRAGON_BREATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EAT_GRASS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EFFICIENCY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EMERALD_HEART;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> ENDER_DRAGON_HEALTH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EXPLOSIVE_EXIT;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> FIRE_PROOF;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> HASTE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> INFINITY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> INVISIBLE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> ITEM_MAGNET;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> JUMP_BOOST;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> JOHNNY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> KEEP_INVENTORY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> KNOCKBACK;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> LAY_EGG;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> LUCK;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MEATY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MILKY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MOB_SIGHT;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MORE_HEARTS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> NIGHT_VISION;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> NO_FALL_DAMAGE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> NO_HUNGER;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> POISON_IMMUNITY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> REGENERATION;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> REACHING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> RESISTANCE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SCARE_CREEPERS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SCARE_SKELETONS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SHOOT_FIREBALLS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SLIMY_DEATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SPEED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> STEP_ASSIST;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> STRENGTH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> TELEPORT;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> THORNS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WALL_CLIMBING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WATER_BREATHING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WEB_DEFENSE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WEB_WALKER;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WITHER_HIT;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WITHER_PROOF;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WOOLY;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> XP_MAGNET;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> BOUNTIFUL;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> BOUNTIFUL_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EXPERIENCED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> FERTILE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> FRENZIED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> PLACID;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CLAWS_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> EFFICIENCY_FOUR;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> FLIGHT;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> HASTE_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MEATY_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MORE_HEARTS_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> PHOTOSYNTHESIS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> REGENERATION_FOUR;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> RESISTANCE_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SPEED_FOUR;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SPEED_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> STRENGTH_TWO;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SCARE_ZOMBIES;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SCARE_SPIDERS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> LAVA_PROOF;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> BLINDNESS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CRINGE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> CURSED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> FLAMBE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> HUNGER;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> INFESTED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> LEVITATION;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> MINING_FATIGUE;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> NAUSEA;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> OOZING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> POISON;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> POISON_FOUR;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SLOWNESS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SLOWNESS_FOUR;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> SLOWNESS_SIX;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WEAVING;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WEAKNESS;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WIND_CHARGED;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WITHER;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> BLACK_DEATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> GREEN_DEATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> WHITE_DEATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> GRAY_DEATH;
    @JvmField
    @NotNull
    public static final ResourceKey<Gene> UN_UNDEATH;

    private ModGenes() {
    }

    @NotNull
    public final ResourceKey<Registry<Gene>> getGENE_REGISTRY_KEY() {
        return GENE_REGISTRY_KEY;
    }

    @JvmStatic
    @NotNull
    public static final HolderLookup.RegistryLookup<Gene> getGeneRegistry(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        HolderLookup.RegistryLookup registryLookup = registries.lookupOrThrow(GENE_REGISTRY_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)registryLookup, (String)"lookupOrThrow(...)");
        return registryLookup;
    }

    @JvmStatic
    @NotNull
    public static final Stream<Holder.Reference<Gene>> getAllGeneHolders(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Stream stream = ModGenes.getGeneRegistry(registries).listElements();
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"listElements(...)");
        return stream;
    }

    @JvmStatic
    @Nullable
    public static final Holder.Reference<Gene> fromResourceKey(@NotNull HolderLookup.Provider registries, @NotNull ResourceKey<Gene> rk) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter(rk, (String)"rk");
        Optional optional = ModGenes.getGeneRegistry(registries).get(rk);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
        return (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
    }

    @JvmStatic
    @Nullable
    public static final Holder.Reference<Gene> fromResourceLocation(@NotNull HolderLookup.Provider registries, @NotNull ResourceLocation rl) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)rl, (String)"rl");
        ResourceKey resourceKey = ResourceKey.create(GENE_REGISTRY_KEY, (ResourceLocation)rl);
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        return ModGenes.fromResourceKey(registries, (ResourceKey<Gene>)resourceKey);
    }

    @JvmStatic
    @Nullable
    public static final Holder<Gene> fromString(@NotNull HolderLookup.Provider registries, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResourceLocation resourceLocation = ResourceLocation.parse((String)id);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"parse(...)");
        return (Holder)ModGenes.fromResourceLocation(registries, resourceLocation);
    }

    @JvmStatic
    @Nullable
    public static final Holder.Reference<Gene> fromIdPath(@NotNull HolderLookup.Provider registries, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return ModGenes.getAllGeneHolders(registries).filter(arg_0 -> ModGenes.fromIdPath$lambda$1(arg_0 -> ModGenes.fromIdPath$lambda$0(path, arg_0), arg_0)).findFirst().orElse(null);
    }

    @NotNull
    public final List<Holder<Gene>> getRegistrySorted(@NotNull HolderLookup.Provider registries, boolean includeHelixOnly, boolean includeDisabled) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        List mutations = new ArrayList();
        List negatives = new ArrayList();
        List other = new ArrayList();
        Iterator iterator = ModGenes.getAllGeneHolders(registries).iterator();
        while (iterator.hasNext()) {
            Holder.Reference geneHolder = (Holder.Reference)iterator.next();
            Intrinsics.checkNotNull((Object)geneHolder);
            if (Gene.Companion.isDisabled((Holder<Gene>)((Holder)geneHolder)) && !includeDisabled) continue;
            if (Gene.Companion.isHelixOnly((Holder<Gene>)((Holder)geneHolder))) {
                if (!includeHelixOnly) continue;
            }
            boolean bl = Gene.Companion.isMutation((Holder<Gene>)((Holder)geneHolder)) ? mutations.add(geneHolder) : (Gene.Companion.isNegative((Holder<Gene>)((Holder)geneHolder)) ? negatives.add(geneHolder) : other.add(geneHolder));
        }
        Iterable $this$sortedBy$iv = other;
        boolean $i$f$sortedBy = false;
        Collection collection = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Holder it = (Holder)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getKey();
                it = (Holder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
            }
        });
        $this$sortedBy$iv = mutations;
        $i$f$sortedBy = false;
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Holder it = (Holder)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getKey();
                it = (Holder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
            }
        }));
        $this$sortedBy$iv = negatives;
        $i$f$sortedBy = false;
        return CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Holder it = (Holder)a;
                boolean bl = false;
                Comparable comparable = (Comparable)it.getKey();
                it = (Holder)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getKey()));
            }
        }));
    }

    public static /* synthetic */ List getRegistrySorted$default(ModGenes modGenes, HolderLookup.Provider provider, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return modGenes.getRegistrySorted(provider, bl, bl2);
    }

    private final ResourceKey<Gene> resourceKey(String geneName) {
        ResourceKey resourceKey = ResourceKey.create(GENE_REGISTRY_KEY, (ResourceLocation)OtherUtil.INSTANCE.modResource(geneName));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"create(...)");
        return resourceKey;
    }

    @NotNull
    public final ResourceKey<Gene> getBASIC() {
        return BASIC;
    }

    @Nullable
    public final Holder.Reference<Gene> getHolder(@NotNull ResourceKey<Gene> $this$getHolder, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter($this$getHolder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        return ModGenes.fromResourceKey(registries, $this$getHolder);
    }

    @NotNull
    public final Holder.Reference<Gene> getHolderOrThrow(@NotNull ResourceKey<Gene> $this$getHolderOrThrow, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter($this$getHolderOrThrow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Holder.Reference<Gene> reference = this.getHolder($this$getHolderOrThrow, registries);
        if (reference == null) {
            throw new IllegalArgumentException("Gene " + $this$getHolderOrThrow.location() + " not found");
        }
        return reference;
    }

    private static final boolean fromIdPath$lambda$0(String $path, Holder.Reference it) {
        ResourceKey resourceKey = it.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        return Intrinsics.areEqual((Object)resourceKey.location().getPath(), (Object)$path);
    }

    private static final boolean fromIdPath$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        ResourceKey resourceKey = ResourceKey.createRegistryKey((ResourceLocation)OtherUtil.INSTANCE.modResource("gene"));
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"createRegistryKey(...)");
        GENE_REGISTRY_KEY = resourceKey;
        BASIC = INSTANCE.resourceKey("basic");
        BIOLUMINESCENCE = INSTANCE.resourceKey("bioluminescence");
        CHATTERBOX = INSTANCE.resourceKey("chatterbox");
        CHILLING = INSTANCE.resourceKey("chilling");
        CLAWS = INSTANCE.resourceKey("claws");
        DRAGON_BREATH = INSTANCE.resourceKey("dragons_breath");
        EAT_GRASS = INSTANCE.resourceKey("eat_grass");
        EFFICIENCY = INSTANCE.resourceKey("efficiency");
        EMERALD_HEART = INSTANCE.resourceKey("emerald_heart");
        ENDER_DRAGON_HEALTH = INSTANCE.resourceKey("ender_dragon_health");
        EXPLOSIVE_EXIT = INSTANCE.resourceKey("explosive_exit");
        FIRE_PROOF = INSTANCE.resourceKey("fire_proof");
        HASTE = INSTANCE.resourceKey("haste");
        INFINITY = INSTANCE.resourceKey("infinity");
        INVISIBLE = INSTANCE.resourceKey("invisible");
        ITEM_MAGNET = INSTANCE.resourceKey("item_magnet");
        JUMP_BOOST = INSTANCE.resourceKey("jump_boost");
        JOHNNY = INSTANCE.resourceKey("johnny");
        KEEP_INVENTORY = INSTANCE.resourceKey("keep_inventory");
        KNOCKBACK = INSTANCE.resourceKey("knockback");
        LAY_EGG = INSTANCE.resourceKey("lay_egg");
        LUCK = INSTANCE.resourceKey("luck");
        MEATY = INSTANCE.resourceKey("meaty");
        MILKY = INSTANCE.resourceKey("milky");
        MOB_SIGHT = INSTANCE.resourceKey("mob_sight");
        MORE_HEARTS = INSTANCE.resourceKey("more_hearts");
        NIGHT_VISION = INSTANCE.resourceKey("night_vision");
        NO_FALL_DAMAGE = INSTANCE.resourceKey("no_fall_damage");
        NO_HUNGER = INSTANCE.resourceKey("no_hunger");
        POISON_IMMUNITY = INSTANCE.resourceKey("poison_immunity");
        REGENERATION = INSTANCE.resourceKey("regeneration");
        REACHING = INSTANCE.resourceKey("reaching");
        RESISTANCE = INSTANCE.resourceKey("resistance");
        SCARE_CREEPERS = INSTANCE.resourceKey("scare_creepers");
        SCARE_SKELETONS = INSTANCE.resourceKey("scare_skeletons");
        SHOOT_FIREBALLS = INSTANCE.resourceKey("shoot_fireballs");
        SLIMY_DEATH = INSTANCE.resourceKey("slimy_death");
        SPEED = INSTANCE.resourceKey("speed");
        STEP_ASSIST = INSTANCE.resourceKey("step_assist");
        STRENGTH = INSTANCE.resourceKey("strength");
        TELEPORT = INSTANCE.resourceKey("teleport");
        THORNS = INSTANCE.resourceKey("thorns");
        WALL_CLIMBING = INSTANCE.resourceKey("wall_climbing");
        WATER_BREATHING = INSTANCE.resourceKey("water_breathing");
        WEB_DEFENSE = INSTANCE.resourceKey("web_defense");
        WEB_WALKER = INSTANCE.resourceKey("web_walker");
        WITHER_HIT = INSTANCE.resourceKey("wither_hit");
        WITHER_PROOF = INSTANCE.resourceKey("wither_proof");
        WOOLY = INSTANCE.resourceKey("wooly");
        XP_MAGNET = INSTANCE.resourceKey("xp_magnet");
        BOUNTIFUL = INSTANCE.resourceKey("bountiful");
        BOUNTIFUL_TWO = INSTANCE.resourceKey("bountiful_2");
        EXPERIENCED = INSTANCE.resourceKey("experienced");
        FERTILE = INSTANCE.resourceKey("fertile");
        FRENZIED = INSTANCE.resourceKey("frenzied");
        PLACID = INSTANCE.resourceKey("placid");
        CLAWS_TWO = INSTANCE.resourceKey("claws_2");
        EFFICIENCY_FOUR = INSTANCE.resourceKey("efficiency_4");
        FLIGHT = INSTANCE.resourceKey("flight");
        HASTE_TWO = INSTANCE.resourceKey("haste_2");
        MEATY_TWO = INSTANCE.resourceKey("meaty_2");
        MORE_HEARTS_TWO = INSTANCE.resourceKey("more_hearts_2");
        PHOTOSYNTHESIS = INSTANCE.resourceKey("photosynthesis");
        REGENERATION_FOUR = INSTANCE.resourceKey("regeneration_4");
        RESISTANCE_TWO = INSTANCE.resourceKey("resistance_2");
        SPEED_FOUR = INSTANCE.resourceKey("speed_4");
        SPEED_TWO = INSTANCE.resourceKey("speed_2");
        STRENGTH_TWO = INSTANCE.resourceKey("strength_2");
        SCARE_ZOMBIES = INSTANCE.resourceKey("scare_zombies");
        SCARE_SPIDERS = INSTANCE.resourceKey("scare_spiders");
        LAVA_PROOF = INSTANCE.resourceKey("lava_proof");
        BLINDNESS = INSTANCE.resourceKey("blindness");
        CRINGE = INSTANCE.resourceKey("cringe");
        CURSED = INSTANCE.resourceKey("cursed");
        FLAMBE = INSTANCE.resourceKey("flambe");
        HUNGER = INSTANCE.resourceKey("hunger");
        INFESTED = INSTANCE.resourceKey("infested");
        LEVITATION = INSTANCE.resourceKey("levitation");
        MINING_FATIGUE = INSTANCE.resourceKey("mining_fatigue");
        NAUSEA = INSTANCE.resourceKey("nausea");
        OOZING = INSTANCE.resourceKey("oozing");
        POISON = INSTANCE.resourceKey("poison");
        POISON_FOUR = INSTANCE.resourceKey("poison_4");
        SLOWNESS = INSTANCE.resourceKey("slowness");
        SLOWNESS_FOUR = INSTANCE.resourceKey("slowness_4");
        SLOWNESS_SIX = INSTANCE.resourceKey("slowness_6");
        WEAVING = INSTANCE.resourceKey("weaving");
        WEAKNESS = INSTANCE.resourceKey("weakness");
        WIND_CHARGED = INSTANCE.resourceKey("wind_charged");
        WITHER = INSTANCE.resourceKey("wither");
        BLACK_DEATH = INSTANCE.resourceKey("black_death");
        GREEN_DEATH = INSTANCE.resourceKey("green_death");
        WHITE_DEATH = INSTANCE.resourceKey("white_death");
        GRAY_DEATH = INSTANCE.resourceKey("gray_death");
        UN_UNDEATH = INSTANCE.resourceKey("un_undeath");
    }
}

